/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.location.Location;
import android.os.Build;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopgun.android.sdk.utils.SgnUserAgent;
import com.shopgun.android.utils.DateUtils;
import com.shopgun.android.utils.DeviceUtils;
import com.shopgun.android.utils.DisplayUtils;
import com.shopgun.android.utils.LocationUtils;
import com.shopgun.android.utils.PackageUtils;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class EventUtils {
    public static final String TAG = EventUtils.class.getSimpleName();

    private EventUtils() {
    }

    public static JsonObject getContext(Context context) {
        JsonObject object = new JsonObject();
        object.add("application", (JsonElement)EventUtils.application(context));
        object.add("device", (JsonElement)EventUtils.device(context));
        object.addProperty("locale", Locale.getDefault().toString());
        object.add("location", (JsonElement)EventUtils.location(context));
        object.add("network", (JsonElement)EventUtils.network(context));
        object.add("os", (JsonElement)EventUtils.os(context));
        object.add("session", (JsonElement)EventUtils.session(null));
        object.add("timeZone", (JsonElement)EventUtils.timezone(context));
        object.addProperty("userAgent", SgnUserAgent.getUserAgent(context));
        return object;
    }

    public static JsonObject network(Context context) {
        JsonObject object = new JsonObject();
        object.add("bluetooth", null);
        object.add("carrier", null);
        object.add("cellular", null);
        object.add("ip", null);
        object.add("wifi", null);
        object.add("bluetooth", null);
        return object;
    }

    public static JsonObject os(Context context) {
        JsonObject object = new JsonObject();
        object.addProperty("name", "Android");
        object.addProperty("version", Build.VERSION.RELEASE);
        return object;
    }

    public static JsonObject timezone(Context context) {
        JsonObject object = new JsonObject();
        int seconds = TimeZone.getDefault().getRawOffset() / 1000;
        object.addProperty("utcOffsetSeconds", (Number)seconds);
        return object;
    }

    public static JsonObject session(String id) {
        JsonObject object = new JsonObject();
        object.addProperty("id", id);
        object.add("referrer", null);
        return object;
    }

    public static JsonObject device(Context context) {
        JsonObject screen = new JsonObject();
        screen.addProperty("width", (Number)DisplayUtils.getScreenWidth((Context)context));
        screen.addProperty("height", (Number)DisplayUtils.getScreenHeight((Context)context));
        JsonObject object = new JsonObject();
        object.addProperty("manufacturer", DeviceUtils.getManufacturer());
        object.addProperty("model", DeviceUtils.getModel());
        object.add("screen", (JsonElement)screen);
        return object;
    }

    public static JsonObject application(Context context) {
        JsonObject object = new JsonObject();
        ApplicationInfo ai = PackageUtils.getApplicationInfo((Context)context);
        object.addProperty("name", (String)context.getPackageManager().getApplicationLabel(ai));
        object.addProperty("version", PackageUtils.getVersionName((Context)context));
        object.addProperty("build", String.valueOf(PackageUtils.getVersionCode((Context)context)));
        object.addProperty("id", context.getPackageName());
        return object;
    }

    public static JsonObject location(Context mContext) {
        Location loc = LocationUtils.getLastKnownLocation((Context)mContext);
        return EventUtils.location(loc);
    }

    public static JsonObject location(Location loc) {
        if (loc == null) {
            return null;
        }
        JsonObject object = new JsonObject();
        object.addProperty("determinedAt", DateUtils.format((Date)new Date(loc.getTime())));
        object.addProperty("latitude", (Number)loc.getLatitude());
        object.addProperty("longitude", (Number)loc.getLongitude());
        object.addProperty("altitude", loc.hasAltitude() ? Double.valueOf(loc.getAltitude()) : null);
        object.addProperty("speed", loc.hasSpeed() ? Float.valueOf(loc.getSpeed()) : null);
        if (loc.hasAccuracy()) {
            JsonObject accuracy = new JsonObject();
            accuracy.addProperty("horizontal", (Number)Float.valueOf(loc.getAccuracy()));
            accuracy.addProperty("vertical", (Number)Float.valueOf(loc.getAccuracy()));
            object.add("accuracy", (JsonElement)accuracy);
        }
        object.add("floor", null);
        return object;
    }
}

