/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import android.net.Uri;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopgun.android.sdk.eventskit.Event;
import com.shopgun.android.sdk.eventskit.EventManager;
import com.shopgun.android.sdk.eventskit.EventTracker;

class EventTrackerImpl
extends EventTracker {
    EventTrackerImpl(String trackerId) {
        super(trackerId);
    }

    @Override
    public void setView(String[] path) {
        this.setView(path, null, null);
    }

    @Override
    public void setView(String[] path, String[] previousPath, Uri uri) {
        JsonArray jPath = this.pathToJson(path);
        if (jPath == null) {
            this.setView((JsonObject)null);
            return;
        }
        JsonObject map = new JsonObject();
        map.add("path", (JsonElement)jPath);
        if (previousPath != null) {
            map.add("previousPath", (JsonElement)this.pathToJson(previousPath));
        }
        if (uri != null) {
            map.addProperty("uri", uri.toString());
        }
        this.setView(map);
    }

    private JsonArray pathToJson(String[] array) {
        if (array == null) {
            return null;
        }
        JsonArray jsonArray = new JsonArray();
        for (String s : array) {
            jsonArray.add(s);
        }
        return jsonArray;
    }

    @Override
    public void track(Event event) {
        EventManager manager = EventManager.getInstance();
        JsonObject context = manager.getContext(true);
        JsonObject view = this.getView();
        if (view != null) {
            context.add("view", (JsonElement)this.getView());
        }
        event.setClient(this.getClient());
        event.setContext(context);
        manager.addEvent(event);
    }
}

