/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import com.google.gson.JsonObject;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.corekit.SgnPreferences;
import com.shopgun.android.sdk.eventskit.Event;
import com.shopgun.android.sdk.eventskit.EventManager;
import com.shopgun.android.sdk.eventskit.EventTrackerImpl;
import com.shopgun.android.sdk.eventskit.EventTrackerNoOp;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.utils.PackageUtils;
import com.shopgun.android.utils.TextUtils;

public abstract class EventTracker {
    public static final String TAG = EventTracker.class.getSimpleName();
    public static final String META_GLOBAL_TRACKER = "com.shopgun.android.sdk.eventskit.global_tracker_id";
    private static EventTracker mGlobalInstance;
    private JsonObject mClient = new JsonObject();
    private JsonObject mView;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventTracker globalTracker() {
        if (mGlobalInstance != null) return mGlobalInstance;
        Class<EventTracker> clazz = EventTracker.class;
        synchronized (EventTracker.class) {
            if (mGlobalInstance != null) return mGlobalInstance;
            Context c = ShopGun.getInstance().getContext();
            Bundle b = PackageUtils.getMetaData((Context)c);
            String trackerId = b.getString(META_GLOBAL_TRACKER);
            if (TextUtils.isEmpty((CharSequence)trackerId)) {
                SgnLog.w(TAG, "No tracker id found for global tracker instance.");
                mGlobalInstance = new EventTrackerNoOp();
            } else {
                mGlobalInstance = new EventTrackerImpl(trackerId);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mGlobalInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setGlobalTracker(EventTracker tracker) {
        Class<EventTracker> clazz = EventTracker.class;
        synchronized (EventTracker.class) {
            mGlobalInstance = tracker;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected EventTracker(String trackId) {
        this.mClient.addProperty("id", SgnPreferences.getInstance().getInstallationId());
        this.mClient.addProperty("trackId", trackId);
    }

    public static EventTracker newTracker(String trackerId) {
        EventTrackerImpl tracker = new EventTrackerImpl(trackerId);
        EventManager.getInstance().registerTracker(tracker);
        return tracker;
    }

    public abstract void setView(String[] var1);

    public abstract void setView(String[] var1, String[] var2, Uri var3);

    public abstract void track(Event var1);

    public void setView(JsonObject view) {
        this.mView = view;
    }

    public JsonObject getView() {
        return this.mView;
    }

    public void track(String type, JsonObject properties) {
        this.track(new Event(type, properties));
    }

    public JsonObject getClient() {
        return this.mClient;
    }

    public void flush() {
        EventManager.getInstance().flush();
    }
}

