/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EventResponse {
    public static final String TAG = EventResponse.class.getSimpleName();
    @SerializedName(value="events")
    List<Item> mEvents = new ArrayList<Item>();
    private static final String ACK = "ack";
    private static final String NACK = "nack";

    public Set<String> getRemovableItems() {
        HashSet<String> ids = new HashSet<String>(this.mEvents.size());
        for (Item item : this.mEvents) {
            if (!item.isAck() && item.isNack()) continue;
            ids.add(item.mId);
        }
        return ids;
    }

    public Set<String> getNackItems() {
        HashSet<String> ids = new HashSet<String>(this.mEvents.size());
        for (Item item : this.mEvents) {
            if (!item.isNack()) continue;
            ids.add(item.mId);
        }
        return ids;
    }

    public Set<String> getAckItems() {
        HashSet<String> ids = new HashSet<String>(this.mEvents.size());
        for (Item item : this.mEvents) {
            if (!item.isAck()) continue;
            ids.add(item.mId);
        }
        return ids;
    }

    public List<Item> getErrors() {
        ArrayList<Item> ids = new ArrayList<Item>(this.mEvents.size());
        for (Item item : this.mEvents) {
            if (!item.isError()) continue;
            ids.add(item);
        }
        return ids;
    }

    public String toString() {
        return new GsonBuilder().create().toJson((Object)this);
    }

    public static class Item {
        @SerializedName(value="id")
        private String mId;
        @SerializedName(value="status")
        private String mStatus;
        @SerializedName(value="errors")
        private JsonArray mErrors;

        public String getId() {
            return this.mId;
        }

        public void setId(String id) {
            this.mId = id;
        }

        public String getStatus() {
            return this.mStatus;
        }

        public void setStatus(String status) {
            this.mStatus = status;
        }

        public JsonArray getErrors() {
            return this.mErrors;
        }

        public void setErrors(JsonArray errors) {
            this.mErrors = errors;
        }

        public boolean isAck() {
            return EventResponse.ACK.equalsIgnoreCase(this.mStatus);
        }

        public boolean isNack() {
            return EventResponse.NACK.equalsIgnoreCase(this.mStatus);
        }

        public boolean isError() {
            return !this.isAck() && !this.isNack();
        }
    }
}

