/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.eventskit;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.corekit.LifecycleManager;
import com.shopgun.android.sdk.eventskit.Event;
import com.shopgun.android.sdk.eventskit.EventDispatcher;
import com.shopgun.android.sdk.eventskit.EventListener;
import com.shopgun.android.sdk.eventskit.EventTracker;
import com.shopgun.android.sdk.eventskit.EventUtils;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnUtils;
import com.shopgun.android.utils.LocationUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class EventManager {
    public static final String TAG = Constants.getTag(EventManager.class);
    private static final int DISPATCH_MSG = 5738629;
    private static final long DISPATCH_INTERVAL = TimeUnit.SECONDS.toMillis(120L);
    public static final int MAX_QUEUE_SIZE = 1024;
    private static EventManager mInstance;
    private static final Handler mHandler;
    private Collection<WeakReference<EventTracker>> mTrackers;
    private static BlockingQueue<Event> mEventQueue;
    private JsonObject mJsonContext;
    private Location mLastKnownLocation;
    private JsonObject mJsonLocation;
    private EventDispatcher mEventDispatcher;
    private long mDispatchInterval = DISPATCH_INTERVAL;
    private final List<EventListener> mEventListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<EventManager> clazz = EventManager.class;
        synchronized (EventManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new EventManager(ShopGun.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private EventManager(ShopGun shopGun) {
        this.mTrackers = new HashSet<WeakReference<EventTracker>>();
        this.mEventListeners = new ArrayList<EventListener>();
        mEventQueue = new LinkedBlockingQueue<Event>(1024);
        this.mEventDispatcher = new EventDispatcher(mEventQueue, shopGun.getClient(), shopGun.getEventEnvironment());
        this.mJsonContext = EventUtils.getContext(shopGun.getContext());
        EventLifecycle lifecycleCallback = new EventLifecycle();
        shopGun.getLifecycleManager().registerCallback(lifecycleCallback);
        if (shopGun.getLifecycleManager().isActive()) {
            lifecycleCallback.onCreate(shopGun.getLifecycleManager().getActivity());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTracker(EventTracker tracker) {
        Class<EventManager> clazz = EventManager.class;
        synchronized (EventManager.class) {
            this.mTrackers.add(new WeakReference<EventTracker>(tracker));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTracker(EventTracker tracker) {
        Class<EventManager> clazz = EventManager.class;
        synchronized (EventManager.class) {
            Iterator<WeakReference<EventTracker>> it = this.mTrackers.iterator();
            while (it.hasNext()) {
                WeakReference<EventTracker> weakTracker = it.next();
                EventTracker tmp = (EventTracker)weakTracker.get();
                if (tracker == tmp) {
                    it.remove();
                    break;
                }
                if (tmp != null) continue;
                it.remove();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setCampaign(JsonObject campaign) {
        this.mJsonContext.add("campaign", (JsonElement)campaign);
    }

    public JsonObject getContext(boolean updateLocation) {
        if (updateLocation || this.mLastKnownLocation == null) {
            Context ctx = ShopGun.getInstance().getContext();
            Location currentLoc = LocationUtils.getLastKnownLocation((Context)ctx);
            if (LocationUtils.isBetterLocation((Location)currentLoc, (Location)this.mLastKnownLocation)) {
                this.mLastKnownLocation = currentLoc;
                this.mJsonLocation = EventUtils.location(this.mLastKnownLocation);
            }
            this.mJsonContext.add("location", (JsonElement)this.mJsonLocation);
        }
        return this.mJsonContext;
    }

    public void addEvent(Event event) {
        boolean isActive = ShopGun.getInstance().getLifecycleManager().isActive();
        if (!isActive) {
            this.mEventDispatcher.start();
        }
        if (mEventQueue.remainingCapacity() > 0) {
            this.dispatchOnEvent(event);
            mEventQueue.add(event);
        }
        if (!isActive) {
            this.mEventDispatcher.quit();
        }
    }

    private void resetTimer() {
        mHandler.removeMessages(5738629);
        mHandler.sendEmptyMessageDelayed(5738629, this.mDispatchInterval);
    }

    public void flush() {
        this.resetTimer();
        this.mEventDispatcher.flush();
    }

    private void startDispatcher() {
        if (this.mEventDispatcher == null || this.mEventDispatcher.getState() == Thread.State.TERMINATED) {
            ShopGun sgn = ShopGun.getInstance();
            this.mEventDispatcher = new EventDispatcher(mEventQueue, sgn.getClient(), sgn.getEventEnvironment());
        }
        this.mEventDispatcher.start();
    }

    public void addEventListener(EventListener tracker) {
        this.mEventListeners.add(tracker);
    }

    public void removeEventListener(EventListener tracker) {
        this.mEventListeners.remove(tracker);
    }

    public void removeAllEventListeners() {
        this.mEventListeners.clear();
    }

    private void dispatchOnEvent(Event event) {
        for (EventListener tracker : this.mEventListeners) {
            tracker.onEvent(event);
        }
    }

    static {
        mHandler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 5738629: {
                        mInstance.flush();
                    }
                }
            }
        };
    }

    private class EventLifecycle
    extends LifecycleManager.SimpleCallback {
        private EventLifecycle() {
        }

        @Override
        public void onCreate(Activity activity) {
            if (EventManager.this.mJsonContext != null) {
                String sessionId = SgnUtils.createUUID();
                EventManager.this.mJsonContext.add("session", (JsonElement)EventUtils.session(sessionId));
            }
            EventManager.this.startDispatcher();
        }

        @Override
        public void onDestroy(Activity activity) {
            mHandler.removeMessages(5738629);
            EventManager.this.mEventDispatcher.quit();
        }
    }
}

