/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.database;

import android.content.Context;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.database.SgnDataSource;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.ListUtils;
import com.shopgun.android.sdk.utils.PermissionUtils;
import com.shopgun.android.utils.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;

public class SgnDatabase {
    public static final String TAG = Constants.getTag(SgnDatabase.class);
    private static SgnDatabase mWrapper;
    private SgnDataSource mDataSource;

    private SgnDatabase(Context c) {
        this.mDataSource = new SgnDataSource(c);
    }

    public static SgnDatabase getInstance(Context c) {
        if (mWrapper == null) {
            mWrapper = new SgnDatabase(c);
        }
        return mWrapper;
    }

    public static SgnDatabase getInstance(ShopGun shopGun) {
        return SgnDatabase.getInstance(shopGun.getContext());
    }

    public void open() {
        this.mDataSource.open();
    }

    public void close() {
        this.mDataSource.close();
    }

    private boolean successId(long id) {
        return id > -1L;
    }

    private boolean successCount(int count) {
        return count > 0;
    }

    private boolean successCount(int count, List list) {
        return count == list.size();
    }

    public int clear() {
        return this.mDataSource.clear();
    }

    public int clear(int userId) {
        return this.mDataSource.clear(userId);
    }

    public boolean insertList(Shoppinglist sl, User user) {
        long id = this.mDataSource.insertList(sl, String.valueOf(user.getUserId()));
        return this.successId(id);
    }

    public boolean insertLists(List<Shoppinglist> lists, User user) {
        if (lists.isEmpty()) {
            return true;
        }
        int count = this.mDataSource.insertList(lists, String.valueOf(user.getUserId()));
        return this.successCount(count, lists);
    }

    public Shoppinglist getList(String id, User user) {
        Shoppinglist sl = this.mDataSource.getList(id, String.valueOf(user.getUserId()));
        if (sl != null && !sl.getShares().containsKey(user.getEmail())) {
            return null;
        }
        return sl;
    }

    public List<Shoppinglist> getLists(User user) {
        return this.getLists(user, false);
    }

    public List<Shoppinglist> getLists(User user, boolean includeDeleted) {
        List<Shoppinglist> lists = this.mDataSource.getLists(String.valueOf(user.getUserId()), includeDeleted);
        Iterator<Shoppinglist> it = lists.iterator();
        while (it.hasNext()) {
            Shoppinglist sl = it.next();
            if (sl.getShares().containsKey(user.getEmail()) || includeDeleted) continue;
            String format = "Shoppinglist %s does not contain a share for %s, removing Shoppinglist from the final list.";
            String text = String.format(format, sl.getName(), user.getEmail());
            SgnLog.d(TAG, text);
            it.remove();
        }
        return lists;
    }

    public boolean deleteList(Shoppinglist sl, User user) {
        return this.deleteList(sl.getId(), user);
    }

    public boolean deleteList(String shoppinglistId, User user) {
        return this.deleteList(shoppinglistId, String.valueOf(user.getUserId()));
    }

    public boolean deleteList(String shoppinglistId, String userId) {
        int count = this.mDataSource.deleteList(shoppinglistId, userId);
        return this.successCount(count);
    }

    public boolean editList(Shoppinglist sl, User user) {
        return this.insertList(sl, user);
    }

    public boolean insertItem(ShoppinglistItem sli, User user) {
        long id = this.mDataSource.insertItem(sli, String.valueOf(user.getUserId()));
        return this.successId(id);
    }

    public boolean insertItems(List<ShoppinglistItem> items, User user) {
        int count = this.mDataSource.insertItem(items, String.valueOf(user.getUserId()));
        return this.successCount(count, items);
    }

    public ShoppinglistItem getItem(String itemId, User user) {
        return this.mDataSource.getItem(itemId, String.valueOf(user.getUserId()));
    }

    public List<ShoppinglistItem> getItems(Shoppinglist sl, User user) {
        return this.getItems(sl.getId(), user, false);
    }

    public List<ShoppinglistItem> getItems(Shoppinglist sl, User user, boolean includeDeleted) {
        return this.getItems(sl.getId(), user, includeDeleted);
    }

    public List<ShoppinglistItem> getItems(String shoppinglistId, User user, boolean includeDeleted) {
        return this.mDataSource.getItems(shoppinglistId, String.valueOf(user.getUserId()), includeDeleted);
    }

    public ShoppinglistItem getFirstItem(String shoppinglistId, User user) {
        return this.getItemPrevious(shoppinglistId, "00000000-0000-0000-0000-000000000000", user);
    }

    public ShoppinglistItem getItemPrevious(String shoppinglistId, String previousId, User user) {
        return this.mDataSource.getItemPrevious(shoppinglistId, previousId, String.valueOf(user.getUserId()));
    }

    public Shoppinglist getFirstList(User user) {
        return this.getListPrevious("00000000-0000-0000-0000-000000000000", user);
    }

    public Shoppinglist getListPrevious(String previousId, User user) {
        return this.mDataSource.getListPrevious(previousId, String.valueOf(user.getUserId()));
    }

    public boolean deleteItem(ShoppinglistItem sli, User user) {
        int count = this.mDataSource.deleteItem(sli.getId(), String.valueOf(user.getUserId()));
        return this.successCount(count);
    }

    public int deleteItems(String shoppinglistId, Boolean state, User user) {
        return this.mDataSource.deleteItems(shoppinglistId, state, String.valueOf(user.getUserId()));
    }

    public boolean editItems(ShoppinglistItem sli, User user) {
        long id = this.mDataSource.insertItem(sli, String.valueOf(user.getUserId()));
        return this.successId(id);
    }

    public boolean editItems(List<ShoppinglistItem> list, User user) {
        int count = this.mDataSource.insertItem(list, String.valueOf(user.getUserId()));
        return this.successCount(count, list);
    }

    public boolean editItemState(List<ShoppinglistItem> list, User user, Date modified, int syncState) {
        HashMap map = new HashMap();
        for (ShoppinglistItem sli : list) {
            String key = sli.getShoppinglistId();
            if (!map.containsKey(key)) {
                map.put(key, new ArrayList());
            }
            ((List)map.get(key)).add(sli);
        }
        int count = 0;
        for (Map.Entry e : map.entrySet()) {
            count += this.mDataSource.editItemState((String)e.getKey(), user.getId(), modified, syncState);
        }
        return this.successCount(count, list);
    }

    public int editItemState(Shoppinglist sl, User user, Date modified, int syncState) {
        modified = DateUtils.roundTime((Date)modified);
        return this.mDataSource.editItemState(sl.getId(), user.getId(), modified, syncState);
    }

    public List<Share> getShares(Shoppinglist sl, User user, boolean includeDeleted) {
        return this.mDataSource.getShares(sl.getId(), String.valueOf(user.getUserId()), includeDeleted);
    }

    public boolean insertShare(Share s, User user) {
        long id = this.mDataSource.insertShare(s, String.valueOf(user.getUserId()));
        return this.successId(id);
    }

    public int cleanShares(Shoppinglist sl, User user) {
        this.deleteShares(sl, user);
        int count = 0;
        for (Share s : sl.getShares().values()) {
            if (!this.editShare(s, user)) continue;
            ++count;
        }
        return count;
    }

    public boolean editShare(Share s, User user) {
        this.deleteShare(s, user);
        return this.insertShare(s, user);
    }

    public int deleteShare(Share s, User user) {
        return this.mDataSource.deleteShare(s, user);
    }

    public int deleteShares(Shoppinglist sl, User user) {
        return this.deleteShares(sl.getId(), String.valueOf(user.getUserId()));
    }

    public int deleteShares(String shoppinglistId, User user) {
        return this.deleteShares(shoppinglistId, String.valueOf(user.getUserId()));
    }

    public int deleteShares(String shoppinglistId, String userId) {
        return this.mDataSource.deleteShares(shoppinglistId, userId);
    }

    public Shoppinglist allowEditOrThrow(ShoppinglistItem sli, User user) {
        return this.allowEditOrThrow(sli.getShoppinglistId(), user);
    }

    public Shoppinglist allowEditOrThrow(Shoppinglist sl, User user) {
        return this.allowEditOrThrow(sl.getId(), user);
    }

    public Shoppinglist allowEditOrThrow(String shoppinglistId, User user) {
        Shoppinglist sl = this.getList(shoppinglistId, user);
        PermissionUtils.allowEditOrThrow(sl, user);
        return sl;
    }

    public List<Shoppinglist> allowEditItemsOrThrow(List<ShoppinglistItem> items, User user) {
        HashSet<String> ids = ListUtils.getShoppinglistIdsFromItems(items);
        return this.allowEditOrThrow(ids, user);
    }

    public List<Shoppinglist> allowEditListOrThrow(List<Shoppinglist> lists, User user) {
        HashSet<String> ids = ListUtils.getShoppinglistIdsFromLists(lists);
        return this.allowEditOrThrow(ids, user);
    }

    public List<Shoppinglist> allowEditOrThrow(Set<String> shoppinglistIds, User user) {
        HashMap<String, Shoppinglist> map = new HashMap<String, Shoppinglist>(shoppinglistIds.size());
        for (String id : shoppinglistIds) {
            if (map.containsKey(id)) continue;
            Shoppinglist sl = this.getList(id, user);
            map.put(sl.getId(), sl);
        }
        ArrayList<Shoppinglist> lists = new ArrayList<Shoppinglist>(map.values());
        for (Shoppinglist sl : lists) {
            PermissionUtils.allowEditOrThrow(sl, user);
        }
        return lists;
    }

    public JSONArray dumpListTable() {
        return this.mDataSource.dumpListTable();
    }

    public JSONArray dumpShareTable() {
        return this.mDataSource.dumpShareTable();
    }

    public JSONArray dumpItemTable() {
        return this.mDataSource.dumpItemTable();
    }
}

