/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.shopgun.android.sdk.database.DbUtils;
import com.shopgun.android.sdk.database.SgnOpenHelper;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.utils.Constants;
import com.shopgun.android.sdk.utils.SgnUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ItemSQLiteHelper
extends SgnOpenHelper {
    public static final String TAG = Constants.getTag(ItemSQLiteHelper.class);
    public static final String TABLE = "shoppinglistitems";
    public static final String CREATE_TABLE = "create table if not exists shoppinglistitems(id text not null primary key, ern text not null, modified text not null, description text, count integer not null, tick integer not null, offer_id text, creator text, shopping_list_id text not null, state integer not null, previous_id text, meta text, user  integer not null );";
    public static final String INSERT_STATEMENT = "INSERT OR REPLACE INTO shoppinglistitems VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public ItemSQLiteHelper(Context context) {
        super(context);
    }

    public static void bind(SQLiteStatement s, ShoppinglistItem sli, String userId) {
        ContentValues cv = ItemSQLiteHelper.objectToContentValues(sli, userId);
        DbUtils.bindOrNull(s, 1, cv.getAsString("id"));
        DbUtils.bindOrNull(s, 2, cv.getAsString("ern"));
        DbUtils.bindOrNull(s, 3, cv.getAsString("modified"));
        DbUtils.bindOrNull(s, 4, cv.getAsString("description"));
        s.bindLong(5, (long)cv.getAsInteger("count").intValue());
        s.bindLong(6, (long)cv.getAsInteger("tick").intValue());
        DbUtils.bindOrNull(s, 7, cv.getAsString("offer_id"));
        DbUtils.bindOrNull(s, 8, cv.getAsString("creator"));
        DbUtils.bindOrNull(s, 9, cv.getAsString("shopping_list_id"));
        DbUtils.bindOrNull(s, 10, cv.getAsString("state"));
        DbUtils.bindOrNull(s, 11, cv.getAsString("previous_id"));
        DbUtils.bindOrNull(s, 12, cv.getAsString("meta"));
        DbUtils.bindOrNull(s, 13, cv.getAsString("user"));
    }

    public static SQLiteStatement getInsertStatement(SQLiteDatabase db) {
        return db.compileStatement(INSERT_STATEMENT);
    }

    public static void create(SQLiteDatabase db) {
        db.acquireReference();
        db.execSQL(CREATE_TABLE);
        db.releaseReference();
    }

    public static void upgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.acquireReference();
        db.execSQL("DROP TABLE IF EXISTS shoppinglistitems");
        db.releaseReference();
    }

    public static List<ShoppinglistItem> cursorToList(Cursor c) {
        ArrayList<ShoppinglistItem> list = new ArrayList<ShoppinglistItem>();
        for (ContentValues cv : DbUtils.cursorToContentValues(c)) {
            ShoppinglistItem sli = ItemSQLiteHelper.contentValuesToObject(cv);
            if (sli == null) continue;
            list.add(sli);
        }
        return list;
    }

    public static ShoppinglistItem contentValuesToObject(ContentValues cv) {
        ShoppinglistItem sli = new ShoppinglistItem();
        sli.setId(cv.getAsString("id"));
        sli.setErn(cv.getAsString("ern"));
        sli.setModified(SgnUtils.stringToDate(cv.getAsString("modified")));
        sli.setDescription(cv.getAsString("description"));
        sli.setCount(cv.getAsInteger("count"));
        sli.setTick(DbUtils.intToBool(cv.getAsInteger("tick")));
        sli.setOfferId(cv.getAsString("offer_id"));
        sli.setCreator(cv.getAsString("creator"));
        sli.setShoppinglistId(cv.getAsString("shopping_list_id"));
        sli.setState(cv.getAsInteger("state"));
        sli.setPreviousId(cv.getAsString("previous_id"));
        try {
            String meta = cv.getAsString("meta");
            sli.setMeta(meta == null ? null : new JSONObject(meta));
        }
        catch (JSONException e) {
            SgnLog.e(TAG, null, e);
        }
        sli.setUserId(cv.getAsInteger("user"));
        return sli;
    }

    public static ContentValues objectToContentValues(ShoppinglistItem sli, String userId) {
        ContentValues cv = new ContentValues();
        cv.put("id", sli.getId());
        cv.put("ern", sli.getErn());
        cv.put("modified", SgnUtils.dateToString(sli.getModified()));
        cv.put("description", sli.getDescription());
        cv.put("count", Integer.valueOf(sli.getCount()));
        cv.put("tick", Integer.valueOf(DbUtils.unescape(sli.isTicked())));
        cv.put("offer_id", sli.getOfferId());
        cv.put("creator", sli.getCreator());
        cv.put("shopping_list_id", sli.getShoppinglistId());
        cv.put("state", Integer.valueOf(sli.getState()));
        cv.put("previous_id", sli.getPreviousId());
        cv.put("meta", sli.getMeta().toString());
        cv.put("user", userId);
        return cv;
    }

    public static ContentValues stateToContentValues(Date modified, int syncState) {
        ContentValues cv = new ContentValues();
        cv.put("modified", SgnUtils.dateToString(modified));
        cv.put("state", Integer.valueOf(syncState));
        return cv;
    }
}

