/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.corekit;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.corekit.utils.ActivityLifecycleCallbacksLogger;
import com.shopgun.android.sdk.corekit.utils.LifecycleManagerCallbackLogger;
import com.shopgun.android.sdk.utils.Constants;
import java.util.Collection;
import java.util.HashSet;

public class LifecycleManager {
    public static final String TAG = Constants.getTag(LifecycleManager.class);
    private static final int DEF_DESTROY_DELAY = 3000;
    private final Collection<Callback> mCallbacks = new HashSet<Callback>();
    private ApplicationCallbacks mApplicationCallbacks = new ApplicationCallbacks();

    public LifecycleManager(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.mApplicationCallbacks);
        application.registerComponentCallbacks((ComponentCallbacks)this.mApplicationCallbacks);
    }

    private void addLoggers(Application application) {
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleCallbacksLogger(TAG));
        this.registerCallback(new LifecycleManagerCallbackLogger(TAG));
    }

    public boolean isActive() {
        return this.mApplicationCallbacks.mCurrentActivity != null;
    }

    public Activity getActivity() {
        return this.mApplicationCallbacks.mCurrentActivity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerCallback(Callback callback) {
        Collection<Callback> collection = this.mCallbacks;
        synchronized (collection) {
            return this.mCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCallback(Callback callback) {
        Collection<Callback> collection = this.mCallbacks;
        synchronized (collection) {
            this.mCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllCallbacks() {
        Collection<Callback> collection = this.mCallbacks;
        synchronized (collection) {
            this.mCallbacks.clear();
        }
    }

    private void dispatchCreate(Activity activity) {
        Callback[] callbacks = this.collectCallbacks();
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                callback.onCreate(activity);
            }
        }
    }

    private void dispatchStart(Activity activity) {
        Callback[] callbacks = this.collectCallbacks();
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                callback.onStart(activity);
            }
        }
    }

    private void dispatchStop(Activity activity) {
        Callback[] callbacks = this.collectCallbacks();
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                callback.onStop(activity);
            }
        }
    }

    private void dispatchDestroy(Activity activity) {
        Callback[] callbacks = this.collectCallbacks();
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                callback.onDestroy(activity);
            }
        }
    }

    private void dispatchTrimMemory(int level) {
        Callback[] callbacks = this.collectCallbacks();
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                callback.onTrimMemory(level);
            }
        }
    }

    private void dispatchConfigurationChanged(Configuration newConfig) {
        Callback[] callbacks = this.collectCallbacks();
        if (callbacks != null) {
            for (Callback callback : callbacks) {
                callback.onConfigurationChanged(newConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Callback[] collectCallbacks() {
        Callback[] callbacks = null;
        Collection<Callback> collection = this.mCallbacks;
        synchronized (collection) {
            if (this.mCallbacks.size() > 0) {
                callbacks = this.mCallbacks.toArray(new Callback[this.mCallbacks.size()]);
            }
        }
        return callbacks;
    }

    public static class SimpleCallback
    implements Callback {
        @Override
        public void onCreate(Activity activity) {
        }

        @Override
        public void onStart(Activity activity) {
        }

        @Override
        public void onStop(Activity activity) {
        }

        @Override
        public void onDestroy(Activity activity) {
        }

        @Override
        public void onTrimMemory(int level) {
        }

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
        }
    }

    public static interface Callback {
        public void onCreate(Activity var1);

        public void onStart(Activity var1);

        public void onStop(Activity var1);

        public void onDestroy(Activity var1);

        public void onTrimMemory(int var1);

        public void onConfigurationChanged(Configuration var1);
    }

    private class ApplicationCallbacks
    implements Application.ActivityLifecycleCallbacks,
    ComponentCallbacks2,
    Runnable {
        Activity mCurrentActivity;

        private ApplicationCallbacks() {
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            ShopGun.getInstance().getHandler().removeCallbacks((Runnable)this);
            if (this.mCurrentActivity == null) {
                this.mCurrentActivity = activity;
                LifecycleManager.this.dispatchCreate(this.mCurrentActivity);
            }
        }

        public void onActivityStarted(Activity activity) {
            this.onActivityCreated(activity, null);
            this.mCurrentActivity = activity;
            LifecycleManager.this.dispatchStart(activity);
        }

        public void onActivityResumed(Activity activity) {
            if (activity == null) {
                throw new IllegalStateException("Activity passed in Application.ActivityLifecycleCallbacks.onActivityResumed is null");
            }
            this.mCurrentActivity = activity;
        }

        public void onActivityPaused(Activity activity) {
            if (this.mCurrentActivity == null) {
                String msg = "No activity set in " + TAG + ". Make sure to instantiate ShopGun in Application.onCreate()";
                throw new IllegalStateException(msg);
            }
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityStopped(Activity activity) {
            if (activity == this.mCurrentActivity) {
                LifecycleManager.this.dispatchStop(activity);
                ShopGun.getInstance().getHandler().postDelayed((Runnable)this, 3000L);
            }
        }

        public void onActivityDestroyed(Activity activity) {
        }

        @Override
        public void run() {
            Activity tmp = this.mCurrentActivity;
            this.mCurrentActivity = null;
            LifecycleManager.this.dispatchDestroy(tmp);
        }

        public void onTrimMemory(int level) {
            LifecycleManager.this.dispatchTrimMemory(level);
        }

        public void onConfigurationChanged(Configuration newConfig) {
            LifecycleManager.this.dispatchConfigurationChanged(newConfig);
        }

        public void onLowMemory() {
            this.onTrimMemory(80);
        }
    }
}

