/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.corekit;

import com.shopgun.android.sdk.SessionManager;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.utils.HashUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.json.JSONObject;

public class ApiV2Interceptor
implements Interceptor {
    public static final String TAG = ApiV2Interceptor.class.getSimpleName();
    AtomicBoolean isSessionMissing = new AtomicBoolean(true);
    CountDownLatch mLatch = new CountDownLatch(1);
    String sessionEndpoint = "http://oiznet.dk/";

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.isV2Endpoint(request)) {
            this.log(request, "Intercepted V2 Request: " + request.url().toString());
            Response response = this.runRequest(chain, request);
            if (response.isSuccessful()) {
                this.updateHeaders(response.headers());
            } else {
                ShopGunError error = this.parseJsonError(response);
                if (SessionManager.recoverableError(error) && !this.isSessionEndpoint(request)) {
                    response = this.runRequest(chain, request);
                }
            }
            return response;
        }
        return chain.proceed(request);
    }

    private Response runRequest(Interceptor.Chain chain, Request request) throws IOException {
        this.latchAndFetchSession(request);
        request = this.applyTokenHeaders(request);
        return chain.proceed(request);
    }

    private boolean isV2Endpoint(Request request) {
        return request.url().host().contains("etilbudsavis.dk") && ((String)request.url().pathSegments().get(0)).contains("v2");
    }

    private boolean isSessionEndpoint(Request request) {
        List path = request.url().pathSegments();
        return this.isV2Endpoint(request) && ((String)path.get(path.size() - 1)).contains("sessions");
    }

    private void updateHeaders(Headers headers) {
        if (headers != null) {
            String token = headers.get("X-Token");
            String expire = headers.get("X-Token-Expires");
            if (token != null && expire != null) {
                ShopGun.getInstance().getSessionManager().updateTokens(token, expire);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShopGunError parseJsonError(Response response) throws IOException {
        try (ResponseBody body = response.body();){
            JSONObject jsonError = new JSONObject(body.string());
            ShopGunError shopGunError = ShopGunError.fromJSON(jsonError);
            return shopGunError;
        }
        return null;
    }

    private Request applyTokenHeaders(Request request) {
        boolean newSession;
        boolean bl = newSession = "POST".equalsIgnoreCase(request.method()) && this.isSessionEndpoint(request);
        if (!newSession) {
            ShopGun sgn = ShopGun.getInstance();
            String token = sgn.getSessionManager().getSession().getToken();
            String sha256 = HashUtils.sha256((String)(sgn.getApiSecret() + token));
            HttpUrl url = request.url().newBuilder().addQueryParameter("X-Token", token).addQueryParameter("X-Signature", sha256).build();
            request = request.newBuilder().url(url).build();
        }
        return request;
    }

    private synchronized void latchAndFetchSession(Request request) throws IOException {
        if (this.isSessionMissing.getAndSet(false)) {
            this.mLatch = new CountDownLatch(1);
            this.fetchSession(request);
            this.mLatch.countDown();
        }
        if (!this.isSessionEndpoint(request)) {
            try {
                this.mLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void fetchSession(Request request) throws IOException {
        this.log(request, "fetching session");
        Request sessionRequest = new Request.Builder().url(this.sessionEndpoint).build();
        Call call = ShopGun.getInstance().getClient().newCall(sessionRequest);
        Response response = call.execute();
        response.body().close();
        this.log(request, "Session update complete");
    }

    private void log(Request request, String msg) {
        SgnLog.d(TAG, "[" + request.toString() + "] " + msg);
    }
}

