/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.bus;

import com.shopgun.android.sdk.bus.ShopGunEvent;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.utils.Constants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ShoppinglistEvent
extends ShopGunEvent {
    public static final String TAG = Constants.getTag(ShoppinglistEvent.class);
    public Map<String, StateWrapper<ShoppinglistItem>> mItems = Collections.synchronizedMap(new HashMap());
    public Map<String, StateWrapper<Shoppinglist>> mLists = Collections.synchronizedMap(new HashMap());
    boolean mIsServer = false;
    boolean mFirstSync = false;

    public ShoppinglistEvent(boolean isServer) {
        this.mIsServer = isServer;
    }

    public static <T> List<T> getValues(Map<String, StateWrapper<T>> map, int action) {
        ArrayList<T> list = new ArrayList<T>(map.size());
        for (Map.Entry<String, StateWrapper<T>> e : map.entrySet()) {
            if (e.getValue().getAction() != action && action != 0) continue;
            list.add(e.getValue().getItem());
        }
        return list;
    }

    public static List<ShoppinglistItem> getCleanItemValues(Map<String, StateWrapper<ShoppinglistItem>> map, int action, String shoppinglistId) {
        List<ShoppinglistItem> list = ShoppinglistEvent.getValues(map, action);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ShoppinglistItem item = (ShoppinglistItem)i.next();
            if (item.getShoppinglistId().equals(shoppinglistId)) continue;
            i.remove();
        }
        return list;
    }

    public static List<Shoppinglist> getCleanListValues(Map<String, StateWrapper<Shoppinglist>> map, int action, String shoppinglistId) {
        List<Shoppinglist> list = ShoppinglistEvent.getValues(map, action);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Shoppinglist item = (Shoppinglist)i.next();
            if (item.getId().equals(shoppinglistId)) continue;
            i.remove();
        }
        return list;
    }

    public boolean isServer() {
        return this.mIsServer;
    }

    public boolean isFirstSync() {
        return this.mFirstSync;
    }

    public void setFirstSync(boolean firstSync) {
        this.mFirstSync = firstSync;
    }

    public void add(Shoppinglist s) {
        this.mLists.put(s.getId(), new StateWrapper<Shoppinglist>(2, s));
    }

    public void del(Shoppinglist s) {
        this.mLists.put(s.getId(), new StateWrapper<Shoppinglist>(4, s));
    }

    public void edit(Shoppinglist s) {
        this.mLists.put(s.getId(), new StateWrapper<Shoppinglist>(1, s));
    }

    public void add(ShoppinglistItem s) {
        this.mItems.put(s.getId(), new StateWrapper<ShoppinglistItem>(2, s));
    }

    public void del(ShoppinglistItem s) {
        this.mItems.put(s.getId(), new StateWrapper<ShoppinglistItem>(4, s));
    }

    public void edit(ShoppinglistItem s) {
        this.mItems.put(s.getId(), new StateWrapper<ShoppinglistItem>(1, s));
    }

    public List<ShoppinglistItem> getItems() {
        return ShoppinglistEvent.getValues(this.mItems, 0);
    }

    public List<ShoppinglistItem> getItems(String shoppinglistId) {
        return ShoppinglistEvent.getCleanItemValues(this.mItems, 0, shoppinglistId);
    }

    public List<ShoppinglistItem> getAddedItems() {
        return ShoppinglistEvent.getValues(this.mItems, 2);
    }

    public List<ShoppinglistItem> getAddedItems(String shoppinglistId) {
        return ShoppinglistEvent.getCleanItemValues(this.mItems, 2, shoppinglistId);
    }

    public List<ShoppinglistItem> getDeletedItems() {
        return ShoppinglistEvent.getValues(this.mItems, 4);
    }

    public List<ShoppinglistItem> getDeletedItems(String shoppinglistId) {
        return ShoppinglistEvent.getCleanItemValues(this.mItems, 4, shoppinglistId);
    }

    public List<ShoppinglistItem> getEditedItems() {
        return ShoppinglistEvent.getValues(this.mItems, 1);
    }

    public List<ShoppinglistItem> getEditedItems(String shoppinglistId) {
        return ShoppinglistEvent.getCleanItemValues(this.mItems, 1, shoppinglistId);
    }

    public List<Shoppinglist> getLists() {
        return ShoppinglistEvent.getValues(this.mLists, 0);
    }

    public List<Shoppinglist> getLists(String shoppinglistId) {
        return ShoppinglistEvent.getCleanListValues(this.mLists, 0, shoppinglistId);
    }

    public List<Shoppinglist> getAddedLists() {
        return ShoppinglistEvent.getValues(this.mLists, 2);
    }

    public List<Shoppinglist> getAddedLists(String shoppinglistId) {
        return ShoppinglistEvent.getCleanListValues(this.mLists, 2, shoppinglistId);
    }

    public List<Shoppinglist> getDeletedLists() {
        return ShoppinglistEvent.getValues(this.mLists, 4);
    }

    public List<Shoppinglist> getDeletedLists(String shoppinglistId) {
        return ShoppinglistEvent.getCleanListValues(this.mLists, 4, shoppinglistId);
    }

    public List<Shoppinglist> getEditedLists() {
        return ShoppinglistEvent.getValues(this.mLists, 1);
    }

    public List<Shoppinglist> getEditedLists(String shoppinglistId) {
        return ShoppinglistEvent.getCleanListValues(this.mLists, 1, shoppinglistId);
    }

    public boolean hasListNotifications() {
        return !this.mLists.isEmpty();
    }

    public boolean hasItemNotifications() {
        return !this.mItems.isEmpty();
    }

    @Override
    public String toString() {
        String format = "%s[ isServer: %s, isFirstSync: %s, list.count: %s, item.count: %s ]";
        return String.format(format, this.getType(), this.mIsServer, this.mFirstSync, this.mLists.size(), this.mItems.size());
    }

    public String toString(boolean printAll) {
        if (!printAll) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("isServer: ").append(this.mIsServer).append("\n");
        sb.append("isFirstSync: ").append(this.mFirstSync).append("\n");
        if (this.hasListNotifications()) {
            sb.append("# LISTS: ").append("\n");
            this.buildList(sb, "List.Del", this.getDeletedLists());
            this.buildList(sb, "List.Edit", this.getEditedLists());
            this.buildList(sb, "List.Add", this.getAddedLists());
        }
        if (this.hasItemNotifications()) {
            sb.append("# ITEMS: ").append("\n");
            this.buildItem(sb, "Item.Del", this.getDeletedItems());
            this.buildItem(sb, "Item.Edit", this.getEditedItems());
            this.buildItem(sb, "Item.Add", this.getAddedItems());
        }
        return sb.toString();
    }

    private void buildItem(StringBuilder sb, String action, List<ShoppinglistItem> list) {
        for (ShoppinglistItem sli : list) {
            sb.append(action).append(": ").append(sli.toString()).append("\n");
        }
    }

    private void buildList(StringBuilder sb, String action, List<Shoppinglist> list) {
        for (Shoppinglist sli : list) {
            sb.append(action).append(": ").append(sli.toString()).append("\n");
        }
    }

    public static class Builder {
        public Map<String, StateWrapper<ShoppinglistItem>> items = Collections.synchronizedMap(new HashMap());
        public Map<String, StateWrapper<Shoppinglist>> lists = Collections.synchronizedMap(new HashMap());
        public boolean isServer = false;
        public boolean firstSync = false;

        public Builder(boolean isServer) {
            this.isServer = isServer;
        }

        public List<ShoppinglistItem> getItems() {
            return ShoppinglistEvent.getValues(this.items, 0);
        }

        public List<ShoppinglistItem> getAddedItems() {
            return ShoppinglistEvent.getValues(this.items, 2);
        }

        public List<ShoppinglistItem> getDeletedItems() {
            return ShoppinglistEvent.getValues(this.items, 4);
        }

        public List<ShoppinglistItem> getEditedItems() {
            return ShoppinglistEvent.getValues(this.items, 1);
        }

        public List<Shoppinglist> getLists() {
            return ShoppinglistEvent.getValues(this.lists, 0);
        }

        public List<Shoppinglist> getAddedLists() {
            return ShoppinglistEvent.getValues(this.lists, 2);
        }

        public List<Shoppinglist> getDeletedLists() {
            return ShoppinglistEvent.getValues(this.lists, 4);
        }

        public List<Shoppinglist> getEditedLists() {
            return ShoppinglistEvent.getValues(this.lists, 1);
        }

        public void add(Shoppinglist s) {
            this.lists.put(s.getId(), new StateWrapper<Shoppinglist>(2, s));
        }

        public void del(Shoppinglist s) {
            this.lists.put(s.getId(), new StateWrapper<Shoppinglist>(4, s));
        }

        public void edit(Shoppinglist s) {
            this.lists.put(s.getId(), new StateWrapper<Shoppinglist>(1, s));
        }

        public void add(ShoppinglistItem s) {
            this.items.put(s.getId(), new StateWrapper<ShoppinglistItem>(2, s));
        }

        public void del(ShoppinglistItem s) {
            this.items.put(s.getId(), new StateWrapper<ShoppinglistItem>(4, s));
        }

        public void edit(ShoppinglistItem s) {
            this.items.put(s.getId(), new StateWrapper<ShoppinglistItem>(1, s));
        }

        public boolean hasChanges() {
            return !this.lists.isEmpty() || !this.items.isEmpty() || this.firstSync;
        }

        public ShoppinglistEvent build() {
            ShoppinglistEvent e = new ShoppinglistEvent(this.isServer);
            e.mItems = this.items;
            e.mLists = this.lists;
            e.mFirstSync = this.firstSync;
            return e;
        }
    }

    public static class StateWrapper<T> {
        int mAction = -1;
        T mItem;

        public StateWrapper(int action, T item) {
            this.mAction = action;
            this.mItem = item;
        }

        public int getAction() {
            return this.mAction;
        }

        public T getItem() {
            return this.mItem;
        }

        public static interface Action {
            public static final int ALL = 0;
            public static final int EDITED = 1;
            public static final int ADDED = 2;
            public static final int DELETED = 4;
        }
    }
}

