/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

public class Version {
    public static final String TAG = Version.class.getSimpleName();
    public static final int MASK_MAJOR = 100000;
    public static final int MASK_MINOR = 1000;
    private final int mVersion;

    public Version(int version) {
        this.mVersion = version;
    }

    public Version(int major, int minor, int patch) {
        this(major * 100000 + minor * 1000 + patch);
    }

    public int getCode() {
        return this.mVersion;
    }

    public int getMajor() {
        return this.mVersion / 100000;
    }

    public int getMinor() {
        return this.mVersion % 100000 / 1000;
    }

    public int getPatch() {
        return this.mVersion % 1000;
    }

    public String toString() {
        return String.format("%s.%s.%s", this.getMajor(), this.getMinor(), this.getPatch());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.mVersion == version.mVersion;
    }

    public int hashCode() {
        return this.mVersion;
    }
}

