/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.utils.DateUtils;
import com.shopgun.android.utils.ExceptionUtils;
import com.shopgun.android.utils.PackageUtils;
import com.shopgun.android.utils.UnitUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public final class Utils {
    public static final String TAG = Constants.getTag(Utils.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZZZZ";
    public static final String DATE_EPOC = "1970-01-01T00:00:00+0000";
    private static SimpleDateFormat mSdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZZZZ", Locale.US);
    private static final Object DATE_LOCK = new Object();

    private Utils() {
    }

    public static String createUUID() {
        return UUID.randomUUID().toString();
    }

    public static String requestToUrlAndQueryString(Request<?> r) {
        if (r == null || r.getUrl() == null) {
            return null;
        }
        if (r.getParameters() == null || r.getParameters().isEmpty()) {
            return r.getUrl();
        }
        return r.getUrl() + "?" + Utils.mapToQueryString(r.getParameters(), r.getParamsEncoding());
    }

    public static String mapToQueryString(Map<String, String> apiParams, String encoding) {
        if (apiParams == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        LinkedList<String> keys = new LinkedList<String>(apiParams.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String value = Utils.valueIsNull(apiParams.get(key));
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(Utils.encode(key, encoding)).append("=").append(Utils.encode(value, encoding));
        }
        return sb.toString();
    }

    public static String mapToQueryString(Map<String, String> parameters) {
        if (parameters == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        LinkedList<String> keys = new LinkedList<String>(parameters.keySet());
        for (String key : keys) {
            String value = Utils.valueIsNull(parameters.get(key));
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        return sb.toString();
    }

    private static String valueIsNull(Object value) {
        return value == null ? "" : value.toString();
    }

    public static String encode(String value, String encoding) {
        try {
            value = URLEncoder.encode(value, encoding);
        }
        catch (NullPointerException e) {
            value = URLEncoder.encode(value);
        }
        catch (UnsupportedEncodingException e) {
            value = URLEncoder.encode(value);
        }
        catch (IllegalCharsetNameException e) {
            value = URLEncoder.encode(value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date stringToDate(String date) {
        Object object = DATE_LOCK;
        synchronized (object) {
            try {
                return mSdf.parse(date);
            }
            catch (ParseException e) {
                return new Date(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String dateToString(Date date) {
        Object object = DATE_LOCK;
        synchronized (object) {
            try {
                return mSdf.format(date);
            }
            catch (NullPointerException e) {
                return DATE_EPOC;
            }
        }
    }

    public static boolean isSuccess(int statusCode) {
        return 200 <= statusCode && statusCode < 300 || statusCode == 304;
    }

    @Deprecated
    public static Date roundTime(Date date) {
        return DateUtils.roundTime((Date)date);
    }

    @Deprecated
    public static String humanReadableByteCount(long bytes, boolean si) {
        return UnitUtils.humanReadableByteCount((long)bytes, (boolean)si);
    }

    @Deprecated
    public static String exceptionToString(Throwable t) {
        return ExceptionUtils.exceptionToString((Throwable)t);
    }

    public static <T> List<T> copyIterator(Iterator<T> it) {
        ArrayList<T> copy = new ArrayList<T>();
        while (it.hasNext()) {
            copy.add(it.next());
        }
        return copy;
    }

    @Deprecated
    public static int convertDpToPx(int dp, Context c) {
        return UnitUtils.dpToPx((int)dp, (Context)c);
    }

    @Deprecated
    public static int convertPxToDp(int px, Context c) {
        return UnitUtils.pxToDp((int)px, (Context)c);
    }

    @Deprecated
    public static String getAppVersion(Context c) {
        return PackageUtils.getVersionName((Context)c);
    }

    public static <T extends Parcelable> T copyParcelable(T obj, Parcelable.Creator<T> creator) {
        Parcel parcel = Parcel.obtain();
        obj.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        return (T)((Parcelable)creator.createFromParcel(parcel));
    }

    public static <T extends Parcelable> List<T> copyParcelable(List<T> list, Parcelable.Creator<T> creator) {
        ArrayList<Parcelable> tmp = new ArrayList<Parcelable>();
        for (Parcelable t : list) {
            tmp.add(Utils.copyParcelable(t, creator));
        }
        return tmp;
    }

    @Deprecated
    public static Bundle getMetaData(Context c) {
        return PackageUtils.getMetaData((Context)c);
    }

    public static int getMaxHeap(Context c) {
        ActivityManager am = (ActivityManager)c.getSystemService("activity");
        if (Build.VERSION.SDK_INT >= 11) {
            return am.getLargeMemoryClass();
        }
        return am.getMemoryClass();
    }
}

