/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.test.SdkTest;
import com.shopgun.android.sdk.utils.Version;
import junit.framework.TestCase;

public class VersionTest
extends TestCase {
    public static final String TAG = Constants.getTag(VersionTest.class);

    public static void test() {
        SdkTest.start(TAG);
        VersionTest.testVersion();
    }

    public static void testVersion() {
        int[] versions = new int[]{0, 1, 1000, 1001, 100000, 101000, 101001};
        String[] expected = new String[]{"0.0.0", "0.0.1", "0.1.0", "0.1.1", "1.0.0", "1.1.0", "1.1.1"};
        for (int i = 0; i < versions.length; ++i) {
            int intVersion = versions[i];
            Version v = new Version(intVersion);
            VersionTest.assertEquals((int)intVersion, (int)v.getCode());
            VersionTest.assertEquals((String)expected[i], (String)v.toString());
        }
        Version version = new Version(0);
        VersionTest.assertEquals((int)version.getMajor(), (int)0);
        VersionTest.assertEquals((int)version.getMinor(), (int)0);
        VersionTest.assertEquals((int)version.getPatch(), (int)0);
        version = new Version(101001);
        VersionTest.assertEquals((int)version.getMajor(), (int)1);
        VersionTest.assertEquals((int)version.getMinor(), (int)1);
        VersionTest.assertEquals((int)version.getPatch(), (int)1);
        SdkTest.logTest(TAG, "Version");
    }
}

