/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.pageflip.Orientation;
import com.shopgun.android.sdk.pageflip.stats.Clock;
import com.shopgun.android.sdk.pageflip.stats.EventType;
import com.shopgun.android.sdk.pageflip.stats.PageEvent;
import com.shopgun.android.sdk.pageflip.stats.PageflipStatsCollector;
import com.shopgun.android.sdk.pageflip.stats.StatDelivery;
import com.shopgun.android.sdk.pageflip.stats.impl.PageflipStatsCollectorImpl;
import com.shopgun.android.sdk.test.SdkTest;
import com.shopgun.android.sdk.test.impl.TestClock;
import com.shopgun.android.sdk.test.impl.TestStatDelivery;
import junit.framework.TestCase;

public class PageflipTest
extends TestCase {
    public static final String TAG = Constants.getTag(PageflipTest.class);

    public static void test() {
        SdkTest.start(TAG);
        PageflipTest.testPageEvent();
        PageflipTest.testPageStatCollector();
    }

    public static void testPageEvent() {
        TestClock clock = new TestClock();
        String viewSession = "my-session";
        int[] pages = new int[]{1};
        PageEvent e = new PageEvent(EventType.VIEW, viewSession, Orientation.LANDSCAPE, pages, clock);
        PageflipTest.assertFalse((boolean)e.isActive());
        PageflipTest.assertFalse((boolean)e.isCollected());
        PageflipTest.assertFalse((boolean)e.isStarted());
        PageflipTest.assertFalse((boolean)e.isStopped());
        PageflipTest.assertEquals((long)0L, (long)e.getDuration());
        PageflipTest.assertEquals((long)0L, (long)e.getDurationAbsolute());
        PageflipTest.assertEquals((int)0, (int)e.getSubEvents().size());
        PageflipTest.assertEquals((int)0, (int)e.getSubEventsRecursive().size());
        PageflipTest.assertEquals((long)0L, (long)e.getStart());
        PageflipTest.assertEquals((long)0L, (long)e.getStop());
        e.start();
        PageflipTest.assertEquals((long)0L, (long)e.getStart());
        clock.increment();
        PageflipTest.assertEquals((long)10L, (long)e.getDuration());
        PageflipTest.assertEquals((long)10L, (long)e.getDurationAbsolute());
        PageflipTest.assertTrue((boolean)e.isActive());
        PageflipTest.assertFalse((boolean)e.isCollected());
        PageflipTest.assertTrue((boolean)e.isStarted());
        PageflipTest.assertFalse((boolean)e.isStopped());
        clock.increment();
        e.stop();
        PageflipTest.assertEquals((long)20L, (long)e.getDurationAbsolute());
        PageflipTest.assertEquals((long)20L, (long)e.getDuration());
        PageflipTest.assertFalse((boolean)e.isActive());
        PageflipTest.assertFalse((boolean)e.isCollected());
        PageflipTest.assertTrue((boolean)e.isStarted());
        PageflipTest.assertTrue((boolean)e.isStopped());
        e.reset();
        PageflipTest.assertFalse((boolean)e.isActive());
        PageflipTest.assertFalse((boolean)e.isCollected());
        PageflipTest.assertFalse((boolean)e.isStarted());
        PageflipTest.assertFalse((boolean)e.isStopped());
        clock.reset();
        e.start();
        clock.increment();
        for (int i = 0; i < 10; ++i) {
            PageEvent subEvent = new PageEvent(EventType.ZOOM, viewSession, Orientation.LANDSCAPE, pages, clock);
            subEvent.start();
            e.addSubEvent(subEvent);
            clock.increment();
            subEvent.stop();
        }
        PageflipTest.assertEquals((long)10L, (long)e.getDuration());
        PageflipTest.assertEquals((long)110L, (long)e.getDurationAbsolute());
        e.stop();
        SdkTest.logTest(TAG, "PageEvent");
    }

    public static void testPageStatCollector() {
        String viewSession = "my-view-session";
        String catalogId = "my-catalog-id";
        int[] pages = new int[]{1, 2};
        TestClock clock = new TestClock();
        TestStatDelivery delivery = new TestStatDelivery();
        PageflipStatsCollectorImpl collector = new PageflipStatsCollectorImpl(viewSession, catalogId, pages, Orientation.LANDSCAPE, (Clock)clock, (StatDelivery)delivery);
        PageflipTest.testPageflipStatsCollector(collector, clock, delivery);
    }

    public static void testPageflipStatsCollector(PageflipStatsCollector collector, TestClock clock, TestStatDelivery delivery) {
        PageflipTest.reset(collector, clock, delivery);
        PageflipTest.assertEquals((int)0, (int)collector.getEvents().size());
        collector.startView();
        PageflipTest.assertEquals((int)1, (int)collector.getEvents().size());
        clock.increment();
        collector.startZoom();
        PageflipTest.assertEquals((int)2, (int)collector.getEvents().size());
        clock.increment();
        collector.stopZoom();
        PageflipTest.assertEquals((int)2, (int)collector.getEvents().size());
        clock.increment();
        collector.stopView();
        PageflipTest.assertEquals((int)2, (int)collector.getEvents().size());
        PageflipTest.assertEquals((long)20L, (long)collector.getRootEvent().getDuration());
        PageflipTest.assertEquals((long)30L, (long)collector.getRootEvent().getDurationAbsolute());
        PageflipTest.reset(collector, clock, delivery);
        collector.startZoom();
        PageflipTest.assertEquals((int)2, (int)collector.getEvents().size());
        clock.increment();
        delivery.reset();
        collector.collect();
        PageflipTest.assertTrue((boolean)delivery.recievedCollect());
        PageflipTest.assertTrue((boolean)collector.getRootEvent().isCollected());
        PageflipTest.assertEquals((long)0L, (long)collector.getRootEvent().getDuration());
        PageflipTest.assertEquals((long)10L, (long)collector.getRootEvent().getDurationAbsolute());
        PageflipTest.reset(collector, clock, delivery);
        collector.collect();
        PageflipTest.assertFalse((boolean)delivery.recievedCollect());
        PageflipTest.reset(collector, clock, delivery);
        collector.stopView();
        collector.collect();
        PageflipTest.assertTrue((boolean)delivery.recievedCollect());
        PageflipTest.assertEquals((long)0L, (long)collector.getRootEvent().getDurationAbsolute());
        PageflipTest.reset(collector, clock, delivery);
        collector.stopZoom();
        clock.increment();
        collector.collect();
        PageflipTest.assertTrue((boolean)delivery.recievedCollect());
        PageflipTest.assertEquals((int)2, (int)collector.getEvents().size());
        PageflipTest.assertEquals((long)10L, (long)collector.getRootEvent().getDurationAbsolute());
        PageflipTest.assertEquals((long)0L, (long)collector.getRootEvent().getSubEvents().get(0).getDurationAbsolute());
        PageflipTest.reset(collector, clock, delivery);
    }

    private static void reset(PageflipStatsCollector collector, TestClock clock, TestStatDelivery delivery) {
        collector.reset();
        clock.reset();
        delivery.reset();
        PageflipTest.assertEquals((int)0, (int)collector.getEvents().size());
    }
}

