/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Branding;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Country;
import com.shopgun.android.sdk.model.Dealer;
import com.shopgun.android.sdk.model.Dimension;
import com.shopgun.android.sdk.model.Hotspot;
import com.shopgun.android.sdk.model.HotspotMap;
import com.shopgun.android.sdk.model.Images;
import com.shopgun.android.sdk.model.Links;
import com.shopgun.android.sdk.model.Offer;
import com.shopgun.android.sdk.model.Pageflip;
import com.shopgun.android.sdk.model.Permission;
import com.shopgun.android.sdk.model.Pieces;
import com.shopgun.android.sdk.model.Pricing;
import com.shopgun.android.sdk.model.Quantity;
import com.shopgun.android.sdk.model.Session;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.model.Si;
import com.shopgun.android.sdk.model.Size;
import com.shopgun.android.sdk.model.Store;
import com.shopgun.android.sdk.model.Subscription;
import com.shopgun.android.sdk.model.Typeahead;
import com.shopgun.android.sdk.model.Unit;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.model.interfaces.ICatalog;
import com.shopgun.android.sdk.model.interfaces.IDealer;
import com.shopgun.android.sdk.model.interfaces.IErn;
import com.shopgun.android.sdk.model.interfaces.IStore;
import com.shopgun.android.sdk.test.ModelCreator;
import com.shopgun.android.sdk.test.SdkTest;
import com.shopgun.android.sdk.utils.Utils;
import junit.framework.Assert;
import org.json.JSONException;
import org.json.JSONObject;

public class ModelTest {
    public static final String TAG = Constants.getTag(ModelTest.class);

    public static void test() {
        SdkTest.start(TAG);
        ModelTest.testSi();
        ModelTest.testSize();
        ModelTest.testPieces();
        ModelTest.testImages();
        ModelTest.testLinks();
        ModelTest.testUnit();
        ModelTest.testPricing();
        ModelTest.testTypeahead();
        ModelTest.testSubscription();
        ModelTest.testPermission();
        ModelTest.testPageflip();
        ModelTest.testHotspot();
        ModelTest.testDimension();
        ModelTest.testCountry();
        ModelTest.testHotspotMap();
        ModelTest.testQuantity();
        ModelTest.testBranding();
        ModelTest.testShare();
        ModelTest.testUser();
        ModelTest.testStore();
        ModelTest.testCatalog();
        ModelTest.testDealer();
        ModelTest.testSession();
        ModelTest.testShoppinglist();
        ModelTest.testShoppinglistitem();
        ModelTest.testOffer();
    }

    public static void testShoppinglistitem() {
        ShoppinglistItem obj = ModelCreator.getShoppinglistItem();
        ShoppinglistItem tmp = ModelCreator.getShoppinglistItem();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        obj.setState(2);
        tmp.setState(4);
        Assert.assertNotSame((Object)obj, (Object)tmp);
        Assert.assertTrue((boolean)obj.same(tmp));
        ModelTest.testParcelable(obj, ShoppinglistItem.CREATOR);
        Assert.assertNull((Object)ShoppinglistItem.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        ShoppinglistItem jsonObj = ShoppinglistItem.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        Assert.assertTrue((boolean)obj.same(jsonObj));
        try {
            jObj.put("description", (Object)"not-pizza");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = ShoppinglistItem.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "ShoppinglistItem");
    }

    public static void testShoppinglist() {
        Shoppinglist obj = ModelCreator.getShoppinglist();
        Shoppinglist tmp = ModelCreator.getShoppinglist();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testIErn(obj, null, null);
        ModelTest.testIErn(obj, "shopping:list", "12fakeid56");
        obj.setState(2);
        tmp.setState(4);
        Assert.assertNotSame((Object)obj, (Object)tmp);
        Assert.assertTrue((boolean)obj.same(tmp));
        Assert.assertNotNull((Object)obj.getType());
        obj.setType(null);
        Assert.assertNotNull((Object)obj.getType());
        Assert.assertEquals((String)"shopping_list", (String)obj.getType());
        ModelTest.testParcelable(obj, Shoppinglist.CREATOR);
        Assert.assertNull((Object)Shoppinglist.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Shoppinglist jsonObj = Shoppinglist.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        Assert.assertTrue((boolean)obj.same(jsonObj));
        try {
            jObj.put("name", (Object)"not bents list anymore");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Shoppinglist.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Shoppinglist");
    }

    public static void testSession() {
        Session obj = ModelCreator.getSession();
        Session tmp = ModelCreator.getSession();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Session.CREATOR);
        Assert.assertNull((Object)Session.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Session jsonObj = Session.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("token", (Object)"new-fake-token");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Session.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Session");
    }

    public static void testDealer() {
        Dealer obj = ModelCreator.getDealer();
        Dealer tmp = ModelCreator.getDealer();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testIErn(obj, null, null);
        ModelTest.testIErn(obj, "dealer", "12fakeid56");
        ModelTest.testParcelable(obj, Dealer.CREATOR);
        obj.setColor(null);
        ModelTest.testParcelable(obj, Dealer.CREATOR);
        Assert.assertNull((Object)Dealer.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Dealer jsonObj = Dealer.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("name", (Object)"bentes fris\u00f8r salon");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Dealer.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        Assert.assertEquals((Object)obj, (Object)new Dealer(obj));
        SdkTest.logTest(TAG, "Dealer");
    }

    public static void testCatalog() {
        Catalog obj = ModelCreator.getCatalog();
        Catalog tmp = ModelCreator.getCatalog();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testIErn(obj, null, null);
        ModelTest.testIErn(obj, "catalog", "12fakeid56");
        ModelTest.testParcelable(obj, Catalog.CREATOR);
        obj.setBackground(null);
        ModelTest.testParcelable(obj, Catalog.CREATOR);
        Assert.assertNull((Object)Catalog.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Catalog jsonObj = Catalog.fromJSON(jObj);
        obj.setHotspots(null);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("offer_count", 0);
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Catalog.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        ModelTest.testIDealer(obj);
        ModelTest.testIStore(obj);
        Assert.assertEquals((Object)obj, (Object)new Catalog(obj));
        SdkTest.logTestWarning(TAG, "Catalog", "NO TEST OF HOTSPOTMAP, see HotspotMap test");
    }

    public static void testStore() {
        Store obj = ModelCreator.getStore();
        Store tmp = ModelCreator.getStore();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testIErn(obj, null, null);
        ModelTest.testIErn(obj, "store", "12fakeid56");
        ModelTest.testParcelable(obj, Store.CREATOR);
        Assert.assertNull((Object)Store.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Store jsonObj = Store.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("street", (Object)"fake-street-new");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Store.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        ModelTest.testIDealer(obj);
        Assert.assertEquals((Object)obj, (Object)new Store(obj));
        SdkTest.logTest(TAG, "Store");
    }

    public static void testCountry() {
        Country obj = ModelCreator.getCountry();
        Country tmp = ModelCreator.getCountry();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testIErn(obj, null, null);
        ModelTest.testIErn(obj, "country", "EU");
        ModelTest.testParcelable(obj, Country.CREATOR);
        Assert.assertNull((Object)Country.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Country jsonObj = Country.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("id", (Object)"US");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Country.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Country");
    }

    public static void testShare() {
        Share obj = ModelCreator.getShare();
        Share tmp = ModelCreator.getShare();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        obj.setState(2);
        tmp.setState(4);
        Assert.assertNotSame((Object)obj, (Object)tmp);
        Assert.assertTrue((boolean)obj.same(tmp));
        ModelTest.testParcelable(obj, Share.CREATOR);
        Assert.assertNull((Object)Share.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        try {
            jObj.put("email", (Object)"fake-wrong-email@nomail.org");
        }
        catch (JSONException e) {
            // empty catch block
        }
        Share jsonObj = Share.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Share");
    }

    public static void testUser() {
        User obj = ModelCreator.getUser();
        User tmp = ModelCreator.getUser();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        String fakeUser = String.valueOf(-1);
        String fakeErn = "ern:user:" + fakeUser;
        ModelTest.testIErn(obj, null, null, fakeUser, fakeErn);
        ModelTest.testIErn(obj, "user", "1569");
        ModelTest.testParcelable(obj, User.CREATOR);
        Assert.assertNull((Object)User.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        User jsonObj = User.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("gender", (Object)"male");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = User.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "User");
    }

    public static void testBranding() {
        Branding obj = ModelCreator.getBranding();
        Branding tmp = ModelCreator.getBranding();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Branding.CREATOR);
        obj.setColor(null);
        ModelTest.testParcelable(obj, Branding.CREATOR);
        Assert.assertNull((Object)Branding.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Branding jsonObj = Branding.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("name", (Object)"fake-branding-name-new");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Branding.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Branding");
    }

    public static void testDimension() {
        Dimension obj = ModelCreator.getDimension();
        Dimension tmp = ModelCreator.getDimension();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Dimension.CREATOR);
        Assert.assertNull((Object)Dimension.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Dimension jsonObj = Dimension.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("height", 2.0);
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Dimension.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Dimension");
    }

    public static void testHotspot() {
        Hotspot obj = ModelCreator.getHotspot();
        Hotspot tmp = ModelCreator.getHotspot();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Hotspot.CREATOR);
        SdkTest.logTestWarning(TAG, "Hotspot", "NO JSON TESTING DONE - Json will fail");
        SdkTest.logTest(TAG, "Hotspot");
    }

    public static void testHotspotMap() {
        HotspotMap obj = ModelCreator.getHotspotMap();
        HotspotMap tmp = ModelCreator.getHotspotMap();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, HotspotMap.CREATOR);
        SdkTest.logTestWarning(TAG, "HotspotMap", "NO JSON TESTING DONE - Json will fail");
        SdkTest.logTest(TAG, "HotspotMap");
    }

    public static void testPageflip() {
        Pageflip obj = ModelCreator.getPageflip();
        Pageflip tmp = ModelCreator.getPageflip();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Pageflip.CREATOR);
        obj.setColor(null);
        ModelTest.testParcelable(obj, Pageflip.CREATOR);
        Assert.assertNull((Object)Pageflip.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Pageflip jsonObj = Pageflip.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("logo", (Object)"fake-logo-url-new");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Pageflip.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Pageflip");
    }

    public static void testPermission() {
        Permission obj = ModelCreator.getPermission();
        Permission tmp = ModelCreator.getPermission();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Permission.CREATOR);
        Assert.assertNull((Object)Permission.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Permission jsonObj = Permission.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Permission");
    }

    public static void testTypeahead() {
        Typeahead obj = ModelCreator.getTypeahead();
        Typeahead tmp = ModelCreator.getTypeahead();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Typeahead.CREATOR);
        Assert.assertNull((Object)Typeahead.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Typeahead jsonObj = Typeahead.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("subject", (Object)"fake-subject-new");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Typeahead.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Typeahead");
    }

    public static void testSubscription() {
        Subscription obj = ModelCreator.getSubscription();
        Subscription tmp = ModelCreator.getSubscription();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Subscription.CREATOR);
        Assert.assertNull((Object)Subscription.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Subscription jsonObj = Subscription.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("dealer_id", (Object)"fake-dealer-new");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Subscription.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Subscription");
    }

    public static void testPricing() {
        Pricing obj = ModelCreator.getPricing();
        Pricing tmp = ModelCreator.getPricing();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Pricing.CREATOR);
        Assert.assertNull((Object)Pricing.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Pricing jsonObj = Pricing.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("price", Double.MAX_VALUE);
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Pricing.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Pricing");
    }

    public static void testLinks() {
        String id2 = "fake-id";
        Links obj = ModelCreator.getLinks(id2);
        Links tmp = ModelCreator.getLinks(id2);
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Links.CREATOR);
        Assert.assertNull((Object)Links.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Links jsonObj = Links.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("webshop", (Object)"not fake-id");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Links.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Links");
    }

    public static void testImages() {
        String id2 = "fake-id";
        int page = 0;
        Images obj = ModelCreator.getImages(id2, page);
        Images tmp = ModelCreator.getImages(id2, page);
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Images.CREATOR);
        Assert.assertNull((Object)Images.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Images jsonObj = Images.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("view", (Object)"not fake-id");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Images.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Images");
    }

    public static void testSi() {
        Si obj = ModelCreator.getSi();
        Si tmp = ModelCreator.getSi();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Si.CREATOR);
        Assert.assertNull((Object)Si.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Si jsonObj = Si.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("symbol", (Object)"not foobar");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Si.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Si");
    }

    public static void testUnit() {
        Unit obj = ModelCreator.getUnit();
        Unit tmp = ModelCreator.getUnit();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Unit.CREATOR);
        Assert.assertNull((Object)Unit.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Unit jsonObj = Unit.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("symbol", (Object)"not foobar");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Unit.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Unit");
    }

    public static void testPieces() {
        Pieces obj = ModelCreator.getPieces();
        Pieces tmp = ModelCreator.getPieces();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Pieces.CREATOR);
        Assert.assertNull((Object)Pieces.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Pieces jsonObj = Pieces.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("to", (Object)"4.0");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Pieces.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Pieces");
    }

    public static void testSize() {
        Size obj = ModelCreator.getSize();
        Size tmp = ModelCreator.getSize();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Size.CREATOR);
        Assert.assertNull((Object)Size.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Size jsonObj = Size.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jObj.put("to", (Object)"4.0");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Size.fromJSON(jObj);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Size");
    }

    public static void testQuantity() {
        Quantity obj = ModelCreator.getQuantity();
        Quantity tmp = ModelCreator.getQuantity();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testParcelable(obj, Quantity.CREATOR);
        Assert.assertNull((Object)Quantity.fromJSON((JSONObject)null));
        JSONObject jObj = obj.toJSON();
        Quantity jsonObj = Quantity.fromJSON(jObj);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        SdkTest.logTest(TAG, "Quantity");
    }

    public static void testOffer() {
        Offer obj = ModelCreator.getOffer();
        Offer tmp = ModelCreator.getOffer();
        Assert.assertEquals((Object)obj, (Object)tmp);
        Assert.assertEquals((int)obj.hashCode(), (int)tmp.hashCode());
        ModelTest.testIErn(obj, null, null);
        ModelTest.testIErn(obj, "offer", "12fakeid56");
        ModelTest.testParcelable(obj, Offer.CREATOR);
        Assert.assertNull((Object)Offer.fromJSON((JSONObject)null));
        JSONObject jOffer = obj.toJSON();
        Offer jsonObj = Offer.fromJSON(jOffer);
        Assert.assertEquals((Object)obj, (Object)jsonObj);
        try {
            jOffer.put("heading", (Object)"Not an offer heading");
        }
        catch (JSONException e) {
            // empty catch block
        }
        jsonObj = Offer.fromJSON(jOffer);
        Assert.assertNotSame((Object)obj, (Object)jsonObj);
        ModelTest.testIDealer(obj);
        ModelTest.testIStore(obj);
        ModelTest.testICatalog(obj);
        Assert.assertEquals((Object)obj, (Object)new Offer(obj));
        SdkTest.logTest(TAG, "Offer");
    }

    private static void testICatalog(ICatalog<?> obj) {
        String catalogId = obj.getCatalogId();
        obj.setCatalog(ModelCreator.getCatalog());
        Assert.assertNotSame((Object)catalogId, (Object)obj.getCatalogId());
        Assert.assertEquals((String)obj.getCatalogId(), (String)obj.getCatalog().getId());
        obj.setCatalog(null);
        Assert.assertNull((Object)obj.getCatalogId());
    }

    private static void testIStore(IStore<?> obj) {
        String storeId = obj.getStoreId();
        obj.setStore(ModelCreator.getStore());
        Assert.assertNotSame((Object)storeId, (Object)obj.getStoreId());
        Assert.assertEquals((String)obj.getStoreId(), (String)obj.getStore().getId());
        obj.setStore(null);
        Assert.assertNull((Object)obj.getStoreId());
    }

    private static void testIDealer(IDealer<?> obj) {
        String dealerId = obj.getDealerId();
        obj.setDealer(ModelCreator.getDealer());
        Assert.assertNotSame((Object)dealerId, (Object)obj.getDealerId());
        Assert.assertEquals((String)obj.getDealerId(), (String)obj.getDealer().getId());
        obj.setDealer(null);
        Assert.assertNull((Object)obj.getDealerId());
    }

    public static void testIErn(IErn<?> obj, String type, String fakeId) {
        ModelTest.testIErn(obj, type, fakeId, null, null);
    }

    public static void testIErn(IErn<?> obj, String type, String fakeId, String fakeExpectedId, String fakeExpectedErn) {
        String origId = obj.getId();
        if (origId != null) {
            Assert.assertTrue((boolean)obj.getErn().startsWith("ern:"));
        } else {
            Assert.assertEquals(null, (String)obj.getErn());
        }
        Assert.assertNotNull((Object)obj.getErnType());
        if (type != null) {
            Assert.assertEquals((String)type, (String)obj.getErnType());
        } else {
            Assert.assertNotSame((Object)type, (Object)obj.getErnType());
        }
        if (fakeId == null) {
            obj.setId(null);
            Assert.assertEquals((String)fakeExpectedId, (String)obj.getId());
            Assert.assertEquals((String)fakeExpectedErn, (String)obj.getErn());
        } else {
            obj.setId(fakeId);
            Assert.assertTrue((boolean)obj.getErn().startsWith("ern:"));
            Assert.assertTrue((boolean)obj.getErn().contains(fakeId));
            Assert.assertTrue((boolean)obj.getErn().contains(obj.getErnType()));
        }
        obj.setId(origId);
    }

    public static <T extends Parcelable> void testParcelable(T obj, Parcelable.Creator<T> creator) {
        T copy = Utils.copyParcelable(obj, creator);
        Assert.assertNotSame(obj, copy);
        Assert.assertEquals(obj, copy);
    }
}

