/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.model.Branding;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Country;
import com.shopgun.android.sdk.model.Dealer;
import com.shopgun.android.sdk.model.Dimension;
import com.shopgun.android.sdk.model.Hotspot;
import com.shopgun.android.sdk.model.HotspotMap;
import com.shopgun.android.sdk.model.Images;
import com.shopgun.android.sdk.model.Links;
import com.shopgun.android.sdk.model.Offer;
import com.shopgun.android.sdk.model.Pageflip;
import com.shopgun.android.sdk.model.Permission;
import com.shopgun.android.sdk.model.Pieces;
import com.shopgun.android.sdk.model.Pricing;
import com.shopgun.android.sdk.model.Quantity;
import com.shopgun.android.sdk.model.Session;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.model.Si;
import com.shopgun.android.sdk.model.Size;
import com.shopgun.android.sdk.model.Store;
import com.shopgun.android.sdk.model.Subscription;
import com.shopgun.android.sdk.model.Typeahead;
import com.shopgun.android.sdk.model.Unit;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.palette.SgnColor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class ModelCreator {
    public static final String UUID_V4_FAKE = "de305d54-75b4-431b-adb2-eb6b9e546013";

    private static String getUrl(String id2, String path) {
        return String.format("https://eta.dk/%s/%s", id2, path);
    }

    private static String getUrl(String id2) {
        return String.format("https://eta.dk/%s", id2);
    }

    private static String getID(String type, String id2) {
        return String.format("%s-%s", type, id2);
    }

    public static Date getDate(int dayOffset) {
        Calendar c = GregorianCalendar.getInstance();
        int day = c.get(5) + dayOffset;
        c.set(5, day);
        c.set(11, 16);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Country getCountry() {
        return ModelCreator.getCountry("DK");
    }

    public static Country getCountry(String id2) {
        Country c = new Country();
        c.setId(id2);
        c.setUnsubscribePrintUrl(ModelCreator.getUrl(id2));
        return c;
    }

    public static Store getStore() {
        return ModelCreator.getStore("fds893r");
    }

    public static Store getStore(String id2) {
        Store s = new Store();
        s.setBranding(ModelCreator.getBranding());
        s.setCity("fake-city");
        s.setContact("fake-email@fake.com");
        s.setCountry(ModelCreator.getCountry());
        String dealerId = ModelCreator.getID("dealer", id2);
        s.setDealerId(dealerId);
        s.setDealerUrl(ModelCreator.getUrl(dealerId));
        s.setId(id2);
        s.setLatitude(12.5);
        s.setLongitude(9.5);
        s.setStreet("fake-street");
        s.setZipcode("fake-zipcode");
        s.setCategoryIds(ModelCreator.getCategoryIds());
        return s;
    }

    public static Share getShare() {
        return ModelCreator.getShare("fake-mail@eta.dk", "owner", "fake-accept-url");
    }

    public static Share getShare(String email, String access, String acceptUrl) {
        return new Share(email, access, acceptUrl);
    }

    public static User getUser() {
        return ModelCreator.getUser(1932, "fake-mail@eta.dk", "female", "fake-user-name", ModelCreator.getPermission(), 1992);
    }

    public static User getUser(int year, String email, String gender, String name, Permission permissions, int id2) {
        User u = new User();
        u.setBirthYear(year);
        u.setEmail(email);
        u.setGender(gender);
        u.setName(name);
        u.setPermissions(permissions);
        u.setUserId(id2);
        return u;
    }

    public static Branding getBranding() {
        return ModelCreator.getBranding(-16711936, "fake-logo-url", "fake-branding-name", ModelCreator.getPageflip(), "fake-website-url", "fake-description");
    }

    public static Branding getBranding(int color, String logoUrl, String name, Pageflip pageflip, String website, String description) {
        Branding b = new Branding();
        b.setColor(color);
        b.setLogo(logoUrl);
        b.setName(name);
        b.setDescription(description);
        b.setPageflip(pageflip);
        b.setWebsite(website);
        return b;
    }

    public static Dimension getDimension() {
        return ModelCreator.getDimension(1.3, 1.0);
    }

    public static Dimension getDimension(double height, double width) {
        Dimension d = new Dimension();
        d.setHeight(height);
        d.setWidth(width);
        return d;
    }

    public static Hotspot getHotspot() {
        return ModelCreator.getHotspot(0, 100, 100, 0);
    }

    public static Hotspot getHotspot(int top, int right, int bottom, int left) {
        Hotspot h = new Hotspot();
        h.mAbsBottom = bottom;
        h.mAbsTop = top;
        h.mAbsLeft = left;
        h.mAbsRight = right;
        h.setOffer(ModelCreator.getOffer());
        return h;
    }

    public static HotspotMap getHotspotMap() {
        return ModelCreator.getHotspotMap("fake-logo-url", -16711936);
    }

    public static HotspotMap getHotspotMap(String logoUrl, int color) {
        HotspotMap h = new HotspotMap();
        ArrayList<Hotspot> list = new ArrayList<Hotspot>();
        for (int i = 0; i < 10; ++i) {
            list.add(ModelCreator.getHotspot(i, 100 + i, 100 + i, i));
        }
        h.put(1, list);
        return h;
    }

    public static Pageflip getPageflip() {
        return ModelCreator.getPageflip(ModelCreator.getUrl("fake-id"), -16711936);
    }

    public static Pageflip getPageflip(String logoUrl, int color) {
        Pageflip p = new Pageflip();
        p.setLogo(logoUrl);
        p.setColor(new SgnColor(color));
        return p;
    }

    public static Permission getPermission() {
        Permission p = new Permission();
        String group = "group";
        ArrayList<String> groupPermissions = new ArrayList<String>();
        groupPermissions.add("group-permission-read");
        groupPermissions.add("group-permission-write");
        p.put(group, groupPermissions);
        String user = "user";
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("user-permission-read");
        permissions.add("user-permission-write");
        HashMap<String, ArrayList<String>> userPermissions = new HashMap<String, ArrayList<String>>();
        userPermissions.put(user, permissions);
        p.putAll(userPermissions);
        return p;
    }

    public static Typeahead getTypeahead() {
        return ModelCreator.getTypeahead("fake-subject", 0, 3);
    }

    public static Typeahead getTypeahead(String subject, int offset, int length) {
        Typeahead t = new Typeahead();
        t.setSubject(subject);
        t.setOffset(offset);
        t.setLength(length);
        return t;
    }

    public static Images getImages() {
        return ModelCreator.getImages("fake-id", 0);
    }

    public static Images getImages(String id2, int page) {
        Images i = new Images();
        i.setThumb(ModelCreator.getImageUrl(id2, "thumb", page));
        i.setView(ModelCreator.getImageUrl(id2, "view", page));
        i.setZoom(ModelCreator.getImageUrl(id2, "zoom", page));
        return i;
    }

    private static String getImageUrl(String id2, String path, int page) {
        return String.format("https://eta.dk/%s/%s-%s.jpg", id2, path, page);
    }

    public static Links getLinks() {
        return ModelCreator.getLinks("fake-id");
    }

    public static Links getLinks(String id2) {
        Links l = new Links();
        l.setWebshop(ModelCreator.getUrl(id2, "webshop"));
        return l;
    }

    public static Pricing getPricing() {
        return ModelCreator.getPricing("DKK", 20.0, 15.0);
    }

    public static Pricing getPricing(String currency, double prePrice, double price) {
        Pricing p = new Pricing();
        p.setCurrency(currency);
        p.setPrePrice(prePrice);
        p.setPrice(price);
        return p;
    }

    public static Pieces getPieces() {
        return ModelCreator.getPieces(1, 1);
    }

    public static Pieces getPieces(int from, int to) {
        Pieces p = new Pieces();
        p.setFrom(from);
        p.setTo(to);
        return p;
    }

    public static Si getSi() {
        return ModelCreator.getSi("FOOBAR", 1.0);
    }

    public static Si getSi(String symbol, double factor) {
        Si s = new Si();
        s.setFactor(factor);
        s.setSymbol(symbol);
        return s;
    }

    public static Unit getUnit() {
        return ModelCreator.getUnit("fake-symbol", ModelCreator.getSi());
    }

    public static Unit getUnit(String symbol, Si si) {
        Unit u = new Unit();
        u.setSi(si);
        u.setSymbol(symbol);
        return u;
    }

    public static Size getSize() {
        return ModelCreator.getSize(1.0, 1.0);
    }

    public static Size getSize(double from, double to) {
        Size s = new Size();
        s.setFrom(from);
        s.setTo(to);
        return s;
    }

    public static Subscription getSubscription() {
        return ModelCreator.getSubscription("fake-dealer", true);
    }

    public static Subscription getSubscription(String dealerId, boolean subscribed) {
        Subscription s = new Subscription(dealerId);
        s.setSubscribed(subscribed);
        return s;
    }

    public static Quantity getQuantity() {
        return ModelCreator.getQuantity(ModelCreator.getPieces(), ModelCreator.getUnit(), ModelCreator.getSize());
    }

    public static Quantity getQuantity(Pieces pieces, Unit unit, Size size) {
        Quantity q = new Quantity();
        q.setPieces(pieces);
        q.setUnit(unit);
        q.setSize(size);
        return q;
    }

    public static HashSet<String> getCategoryIds() {
        return ModelCreator.getCategoryIds(new String[]{"discount", "pets", "fashion", "sport"});
    }

    public static HashSet<String> getCategoryIds(String[] ids) {
        HashSet<String> s = new HashSet<String>();
        s.addAll(Arrays.asList(ids));
        return s;
    }

    public static ShoppinglistItem getShoppinglistItem() {
        return ModelCreator.getShoppinglistItem("89azf82", "pizza");
    }

    public static ShoppinglistItem getShoppinglistItem(String id2, String description) {
        Shoppinglist sl = ModelCreator.getShoppinglist();
        ShoppinglistItem s = new ShoppinglistItem(sl, description);
        s.setComment("fake-comment");
        s.setCount(187);
        s.setCreator("fake-user@eta.dk");
        s.setDescription("fake-description");
        s.setId(id2);
        JSONObject o = new JSONObject();
        try {
            o.put("metadata", (Object)"foobar");
        }
        catch (JSONException e) {
            // empty catch block
        }
        s.setMeta(o);
        s.setModified(ModelCreator.getDate(1));
        s.setOffer(ModelCreator.getOffer());
        s.setOfferId(s.getOffer().getId());
        s.setPreviousId(UUID_V4_FAKE);
        s.setShoppinglistId(sl.getId());
        s.setState(0);
        s.setTick(true);
        s.setUserId(187);
        return s;
    }

    public static Shoppinglist getShoppinglist() {
        return ModelCreator.getShoppinglist("489efdb2", "bents liste");
    }

    public static Shoppinglist getShoppinglist(String id2, String name) {
        Shoppinglist s = Shoppinglist.fromName(name);
        s.setAccess("private");
        s.setId(id2);
        JSONObject o = new JSONObject();
        try {
            o.put("metadata", (Object)"foobar");
        }
        catch (JSONException e) {
            // empty catch block
        }
        s.setMeta(o);
        s.setModified(ModelCreator.getDate(1));
        s.setName(name);
        s.setPreviousId(UUID_V4_FAKE);
        ArrayList<Share> shares = new ArrayList<Share>(10);
        for (int i = 0; i < 10; ++i) {
            String email = String.format("danny%s@eta.dk", i);
            shares.add(ModelCreator.getShare(email, "rw", ModelCreator.getUrl(id2)));
        }
        s.setShares(shares);
        s.setState(0);
        s.setType("shopping_list");
        s.setUserId(187);
        return s;
    }

    public static Session getSession() {
        return ModelCreator.getSession(ModelCreator.getDate(1).getTime(), "token-bafa555b");
    }

    public static Session getSession(long expires, String token) {
        Session s = new Session();
        s.setClientId("fake-cid");
        long exp = expires + TimeUnit.HOURS.toMillis(1L);
        s.setExpires(new Date(exp));
        s.setPermission(ModelCreator.getPermission());
        s.setProvider("fake-provider");
        s.setReference("fake-reference");
        s.setToken(token);
        s.setUser(ModelCreator.getUser());
        return s;
    }

    public static Dealer getDealer() {
        return ModelCreator.getDealer("bcd825a", "fake-netto");
    }

    public static Dealer getDealer(String id2, String name) {
        Dealer d = new Dealer();
        d.setColor(-65281);
        d.setId(id2);
        d.setLogo(ModelCreator.getUrl(id2, "fake-logo"));
        d.setName(name);
        d.setPageflip(ModelCreator.getPageflip());
        d.setWebsite(ModelCreator.getUrl(id2, "website"));
        d.setCategoryIds(ModelCreator.getCategoryIds());
        d.setCountry(ModelCreator.getCountry());
        d.setDescription("fake-description");
        return d;
    }

    public static Catalog getCatalog() {
        return ModelCreator.getCatalog("156fab7");
    }

    public static Catalog getCatalog(String id2) {
        Catalog c = new Catalog();
        c.setBackground(-16777216);
        c.setBranding(ModelCreator.getBranding());
        c.setCategoryIds(ModelCreator.getCategoryIds());
        c.setDimension(ModelCreator.getDimension());
        c.setId(id2);
        c.setHotspots(ModelCreator.getHotspotMap());
        c.setImages(ModelCreator.getImages());
        c.setLabel("fake-label");
        c.setOfferCount(32);
        c.setPageCount(9);
        ArrayList<Images> images = new ArrayList<Images>(10);
        for (int i = 0; i < 10; ++i) {
            images.add(ModelCreator.getImages(id2, i));
        }
        c.setPages(images);
        c.setPdfUrl(ModelCreator.getUrl("pdf"));
        c.setRunFrom(ModelCreator.getDate(-3));
        c.setRunTill(ModelCreator.getDate(3));
        String dealerId = ModelCreator.getID("dealer", id2);
        c.setDealerId(dealerId);
        c.setDealerUrl(ModelCreator.getUrl(dealerId));
        String storeId = ModelCreator.getID("store", id2);
        c.setStoreId(storeId);
        c.setStoreUrl(ModelCreator.getUrl(storeId));
        return c;
    }

    public static Offer getOffer() {
        String name = "Chicken Soup";
        String id2 = "32abf85";
        String description = "The great taste of homemade chicken soup.";
        return ModelCreator.getOffer(name, description, id2);
    }

    public static Offer getOffer(String name, String description, String id2) {
        Offer o = new Offer();
        String offerId = ModelCreator.getID("offer", id2);
        o.setId(offerId);
        o.setHeading(name);
        o.setDescription(description);
        o.setCatalogPage(32);
        o.setImages(ModelCreator.getImages(offerId, 0));
        o.setLinks(ModelCreator.getLinks(offerId));
        o.setPricing(ModelCreator.getPricing());
        o.setQuantity(ModelCreator.getQuantity());
        o.setRunFrom(ModelCreator.getDate(-3));
        o.setRunTill(ModelCreator.getDate(3));
        String catalogId = ModelCreator.getID("catalog", id2);
        o.setCatalogId(catalogId);
        o.setCatalogUrl(ModelCreator.getUrl(catalogId));
        String dealerId = ModelCreator.getID("dealer", id2);
        o.setDealerId(dealerId);
        o.setDealerUrl(ModelCreator.getUrl(dealerId));
        String storeId = ModelCreator.getID("store", id2);
        o.setStoreId(storeId);
        o.setStoreUrl(ModelCreator.getUrl(storeId));
        o.setCategoryIds(ModelCreator.getCategoryIds());
        Pageflip pf = ModelCreator.getPageflip("fake-logo-url", -16776961);
        o.setBranding(ModelCreator.getBranding(-16776961, "fake-logo-url", "fake-name", pf, "fake-website", "fake-description"));
        return o;
    }
}

