/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.test;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.api.Environment;
import com.shopgun.android.sdk.test.SdkTest;
import junit.framework.TestCase;

public class EnvironmentTest
extends TestCase {
    public static final String TAG = Constants.getTag(EnvironmentTest.class);
    private static final String PROD = "https://api.etilbudsavis.dk";
    private static final String EDGE = "https://api-edge.etilbudsavis.dk";
    private static final String STAG = "https://api-staging.etilbudsavis.dk";

    public static void test() {
        SdkTest.start(TAG);
        EnvironmentTest.testEnvironment();
        EnvironmentTest.testApply();
        EnvironmentTest.testFromString();
    }

    public static void testEnvironment() {
        EnvironmentTest.assertEquals((String)Environment.PRODUCTION.toString(), (String)PROD);
        EnvironmentTest.assertEquals((String)Environment.EDGE.toString(), (String)EDGE);
        EnvironmentTest.assertEquals((String)Environment.STAGING.toString(), (String)STAG);
        EnvironmentTest.assertNotNull((Object)Environment.CUSTOM.toString());
        SdkTest.logTest(TAG, "Environment");
    }

    public static void testApply() {
        Environment e = Environment.PRODUCTION;
        String nul = e.apply(null);
        EnvironmentTest.assertEquals((String)PROD, (String)nul);
        String empty = e.apply("");
        EnvironmentTest.assertEquals((String)PROD, (String)empty);
        String etaApiUrl = "https://api.etilbudsavis.dk/some/path";
        String path = "/some/path";
        String standard = e.apply(path);
        EnvironmentTest.assertEquals((String)etaApiUrl, (String)standard);
        String noSlashPath = "some/path";
        String noSlash = e.apply(noSlashPath);
        EnvironmentTest.assertEquals((String)etaApiUrl, (String)noSlash);
        String fullBuild = e.apply(etaApiUrl);
        EnvironmentTest.assertEquals((String)etaApiUrl, (String)fullBuild);
        String httpUrl = "http://www.jubii.dk/";
        String http = e.apply(httpUrl);
        EnvironmentTest.assertEquals((String)httpUrl, (String)http);
        String httpsUrl = "https://www.jubii.dk/";
        String https = e.apply(httpsUrl);
        EnvironmentTest.assertEquals((String)httpsUrl, (String)https);
        SdkTest.logTest(TAG, "Apply");
    }

    public static void testFromString() {
        String customOriginal = Environment.CUSTOM.toString();
        String prod1 = Environment.PRODUCTION.toString();
        EnvironmentTest.assertEquals((Object)((Object)Environment.PRODUCTION), (Object)((Object)Environment.fromString(prod1)));
        String edge1 = Environment.EDGE.toString();
        EnvironmentTest.assertEquals((Object)((Object)Environment.EDGE), (Object)((Object)Environment.fromString(edge1)));
        String staging1 = Environment.STAGING.toString();
        EnvironmentTest.assertEquals((Object)((Object)Environment.STAGING), (Object)((Object)Environment.fromString(staging1)));
        EnvironmentTest.assertEquals((Object)((Object)Environment.CUSTOM), (Object)((Object)Environment.fromString(null)));
        EnvironmentTest.assertEquals((String)Environment.PRODUCTION.toString(), (String)Environment.CUSTOM.toString());
        EnvironmentTest.assertEquals((Object)((Object)Environment.CUSTOM), (Object)((Object)Environment.fromString("")));
        EnvironmentTest.assertEquals((String)Environment.PRODUCTION.toString(), (String)Environment.CUSTOM.toString());
        EnvironmentTest.assertEquals((Object)((Object)Environment.CUSTOM), (Object)((Object)Environment.fromString("random")));
        EnvironmentTest.assertEquals((Object)((Object)Environment.CUSTOM), (Object)((Object)Environment.fromString("https://api.shopgun.c")));
        EnvironmentTest.assertEquals((Object)((Object)Environment.CUSTOM), (Object)((Object)Environment.fromString("https://api.shopgun.com/")));
        EnvironmentTest.assertEquals((Object)((Object)Environment.CUSTOM), (Object)((Object)Environment.fromString("https://shopgun.com/")));
        String first_url = "first_url";
        String second_url = "second_url";
        Environment custom = Environment.fromString(first_url);
        EnvironmentTest.assertTrue((custom == Environment.CUSTOM ? 1 : 0) != 0);
        EnvironmentTest.assertEquals((String)first_url, (String)custom.toString());
        EnvironmentTest.assertEquals((String)first_url, (String)Environment.CUSTOM.toString());
        Environment.fromString(second_url);
        EnvironmentTest.assertNotSame((Object)first_url, (Object)custom.toString());
        EnvironmentTest.assertEquals((String)second_url, (String)Environment.CUSTOM.toString());
        EnvironmentTest.assertEquals((String)second_url, (String)custom.toString());
        EnvironmentTest.assertEquals((Object)((Object)Environment.PRODUCTION), (Object)((Object)Environment.fromString(PROD)));
        EnvironmentTest.assertEquals((Object)((Object)Environment.EDGE), (Object)((Object)Environment.fromString(EDGE)));
        EnvironmentTest.assertEquals((Object)((Object)Environment.STAGING), (Object)((Object)Environment.fromString(STAG)));
        EnvironmentTest.assertNotSame((Object)((Object)Environment.PRODUCTION), (Object)((Object)Environment.EDGE));
        EnvironmentTest.assertNotSame((Object)((Object)Environment.PRODUCTION), (Object)((Object)Environment.STAGING));
        EnvironmentTest.assertNotSame((Object)((Object)Environment.PRODUCTION), (Object)((Object)Environment.CUSTOM));
        EnvironmentTest.assertNotSame((Object)((Object)Environment.EDGE), (Object)((Object)Environment.STAGING));
        EnvironmentTest.assertNotSame((Object)((Object)Environment.EDGE), (Object)((Object)Environment.CUSTOM));
        EnvironmentTest.assertNotSame((Object)((Object)Environment.STAGING), (Object)((Object)Environment.CUSTOM));
        Environment.setCustom(customOriginal);
        SdkTest.logTest(TAG, "FromString");
    }
}

