/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.shoppinglists;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.bus.SessionEvent;
import com.shopgun.android.sdk.bus.SgnBus;
import com.shopgun.android.sdk.bus.ShoppinglistEvent;
import com.shopgun.android.sdk.database.DatabaseWrapper;
import com.shopgun.android.sdk.database.DbUtils;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Share;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.ShoppinglistItem;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.HandlerDelivery;
import com.shopgun.android.sdk.network.impl.JsonArrayRequest;
import com.shopgun.android.sdk.network.impl.JsonObjectRequest;
import com.shopgun.android.sdk.utils.Api;
import com.shopgun.android.sdk.utils.ListUtils;
import com.shopgun.android.sdk.utils.PermissionUtils;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SyncManager {
    public static final String TAG = Constants.getTag(SyncManager.class);
    private static final boolean SAVE_NETWORK_LOG = false;
    final Object RESUME_LOCK = new Object();
    private final Stack<Request<?>> mCurrentRequests = new Stack();
    HandlerThread mThread;
    boolean isPaused = false;
    private int mSyncSpeed = 10000;
    private int mSyncCount = 0;
    private boolean mHasFirstSync = false;
    private ShopGun mShopGun;
    private DatabaseWrapper mDatabase;
    private Handler mHandler;
    private boolean mMigrateOfflineLists = false;
    private Object mRequestTag = new Object();
    private ShoppinglistEvent.Builder mBuilder = new ShoppinglistEvent.Builder(true);
    private Delivery mDelivery;
    private Runnable mSyncLoop = new Runnable(){

        @Override
        public void run() {
            User u = SyncManager.this.mShopGun.getUser();
            if (!u.isLoggedIn()) {
                SyncLog.sync(TAG, "SyncManager(" + SyncManager.this.mSyncCount + ") - skip-loop-cycle (NotLoggedIn)");
                return;
            }
            if (SyncManager.this.mShopGun.isStarted()) {
                SyncManager.this.mHandler.postDelayed(SyncManager.this.mSyncLoop, (long)SyncManager.this.mSyncSpeed);
            }
            if (!SyncManager.this.mCurrentRequests.isEmpty()) {
                SyncLog.sync(TAG, "SyncManager(" + SyncManager.this.mSyncCount + ") - skip-loop-cycle (ReqInFlight)");
                return;
            }
            if (!SyncManager.this.mShopGun.isOnline()) {
                SyncLog.sync(TAG, "SyncManager(" + SyncManager.this.mSyncCount + ") - skip-loop-cycle (Offline)");
                return;
            }
            if (SyncManager.this.isPaused()) {
                SyncLog.sync(TAG, "SyncManager(" + SyncManager.this.mSyncCount + ") - skip-loop-cycle (Paused)");
                return;
            }
            SyncManager.this.performSyncCycle(u);
        }
    };

    public SyncManager(ShopGun shopGun, DatabaseWrapper db) {
        this.mShopGun = shopGun;
        this.mDatabase = db;
        this.mThread = new HandlerThread(TAG, 10);
        this.mThread.start();
        this.mHandler = new Handler(this.mThread.getLooper());
        this.mDelivery = new HandlerDelivery(this.mHandler);
    }

    public void onEvent(SessionEvent e) {
        if (e.isNewUser()) {
            this.mHasFirstSync = false;
            this.mSyncCount = 0;
            this.forceSync();
        }
    }

    private void performSyncCycle(User user) {
        List<Shoppinglist> lists = this.mDatabase.getLists(user, true);
        if (this.syncLocalListChanges(lists, user)) {
            SyncLog.sync(TAG, "SyncManager(" + this.mSyncCount + ") - syncLocalListChanges");
            return;
        }
        boolean hasLocalChanges = false;
        for (Shoppinglist sl : lists) {
            hasLocalChanges = this.syncLocalItemChanges(sl, user) || hasLocalChanges;
            hasLocalChanges = this.syncLocalShareChanges(sl, user) || hasLocalChanges;
        }
        if (hasLocalChanges) {
            SyncLog.sync(TAG, "SyncManager(" + this.mSyncCount + ") - hasLocalChanges");
            return;
        }
        if (this.mSyncCount % 3 == 0) {
            SyncLog.sync(TAG, "SyncManager(" + this.mSyncCount + ") - syncAllLists");
            this.syncLists(user);
        } else if (this.mSyncCount % 10 == 0) {
            SyncLog.sync(TAG, "SyncManager(" + this.mSyncCount + ") - syncAllItems");
            List<Shoppinglist> localLists = this.mDatabase.getLists(user);
            for (Shoppinglist sl : localLists) {
                this.syncItems(sl, user);
            }
        } else {
            SyncLog.sync(TAG, "SyncManager(" + this.mSyncCount + ") - checkModified");
            this.syncListsModified(user);
        }
        ++this.mSyncCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        Object object = this.RESUME_LOCK;
        synchronized (object) {
            return this.isPaused;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSync() {
        Object object = this.RESUME_LOCK;
        synchronized (object) {
            this.isPaused = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSync() {
        Object object = this.RESUME_LOCK;
        synchronized (object) {
            this.isPaused = false;
        }
    }

    public boolean hasFirstSync() {
        return this.mHasFirstSync;
    }

    public void forceSync() {
        this.mHandler.removeCallbacks(this.mSyncLoop);
        this.mHandler.post(this.mSyncLoop);
    }

    public void onStart() {
        this.mDatabase.open();
        SgnBus.getInstance().register((Object)this);
        this.forceSync();
    }

    public void onStop() {
        this.mDatabase.close();
        this.forceSync();
        SgnBus.getInstance().unregister((Object)this);
        this.mHasFirstSync = false;
        this.mSyncCount = -1;
    }

    public void setSyncSpeed(int time) {
        this.mSyncSpeed = time == 10000 || time == 6000 || time == 3000 ? time : 10000;
    }

    public void setMigrateOfflineLists(boolean migrate) {
        this.mMigrateOfflineLists = migrate;
    }

    public boolean isMigratingOfflineLists() {
        return this.mMigrateOfflineLists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(Request<?> r) {
        r.setIgnoreCache(true);
        Stack<Request<?>> stack = this.mCurrentRequests;
        synchronized (stack) {
            this.mCurrentRequests.add(r);
        }
        r.setDelivery(this.mDelivery);
        r.setTag(this.mRequestTag);
        this.mShopGun.add(r);
    }

    private boolean isPullReq(Request<?> r) {
        String u = r.getUrl();
        return u.contains("modified") || u.endsWith("shoppinglists") || u.endsWith("items");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void popRequest() {
        Stack<Request<?>> stack = this.mCurrentRequests;
        synchronized (stack) {
            try {
                this.mCurrentRequests.pop();
            }
            catch (Exception e) {
                SgnLog.e(TAG, e.getMessage(), e);
            }
        }
    }

    private void syncLists(final User user) {
        Response.Listener<JSONArray> listListener = new Response.Listener<JSONArray>(){

            @Override
            public void onComplete(JSONArray response, ShopGunError error) {
                if (response != null) {
                    List<Shoppinglist> localLists = SyncManager.this.mDatabase.getLists(user, true);
                    ArrayList<Shoppinglist> serverLists = Shoppinglist.fromJSON(response);
                    Collections.reverse(serverLists);
                    SyncManager.this.prepareServerList(serverLists);
                    SyncManager.this.mergeListsToDb(serverLists, localLists, user);
                    if (SyncManager.this.mSyncCount == 1) {
                        if (SyncManager.this.mMigrateOfflineLists && serverLists.isEmpty() && localLists.isEmpty()) {
                            DbUtils.migrateOfflineLists(SyncManager.this.mShopGun.getListManager(), SyncManager.this.mDatabase, false);
                        }
                        SyncManager.this.mHasFirstSync = true;
                        ((SyncManager)SyncManager.this).mBuilder.firstSync = true;
                    }
                    SyncManager.this.popRequestAndPostShoppinglistEvent();
                } else {
                    SyncManager.this.popRequest();
                }
            }
        };
        JsonArrayRequest listRequest = new JsonArrayRequest(Request.Method.GET, Api.Endpoint.lists(user.getUserId()), listListener);
        listRequest.getParameters().remove("offset");
        listRequest.getParameters().remove("limit");
        listRequest.setSaveNetworkLog(false);
        this.addRequest(listRequest);
    }

    private void prepareServerList(List<Shoppinglist> serverList) {
        for (Shoppinglist sl : serverList) {
            for (Share share : sl.getShares().values()) {
                share.setState(2);
            }
        }
    }

    private void mergeListsToDb(List<Shoppinglist> serverList, List<Shoppinglist> localList, User user) {
        if (serverList.isEmpty() && localList.isEmpty()) {
            return;
        }
        HashMap<String, Shoppinglist> localMap = new HashMap<String, Shoppinglist>();
        HashMap<String, Shoppinglist> serverMap = new HashMap<String, Shoppinglist>();
        HashSet union = new HashSet();
        for (Shoppinglist sl : localList) {
            localMap.put(sl.getId(), sl);
        }
        for (Shoppinglist sl : serverList) {
            serverMap.put(sl.getId(), sl);
        }
        union.addAll(serverMap.keySet());
        union.addAll(localMap.keySet());
        for (String key : union) {
            if (localMap.containsKey(key)) {
                Shoppinglist localSl = (Shoppinglist)localMap.get(key);
                if (serverMap.containsKey(key)) {
                    Shoppinglist serverSl = (Shoppinglist)serverMap.get(key);
                    if (!localSl.getModified().before(serverSl.getModified())) continue;
                    serverSl.setState(2);
                    this.mBuilder.edit(serverSl);
                    this.mDatabase.editList(serverSl, user);
                    this.mDatabase.cleanShares(serverSl, user);
                    continue;
                }
                this.mBuilder.del(localSl);
                for (ShoppinglistItem sli : this.mDatabase.getItems(localSl, user)) {
                    this.mBuilder.del(sli);
                }
                this.mDatabase.deleteItems(localSl.getId(), null, user);
                this.mDatabase.deleteList(localSl, user);
                continue;
            }
            Shoppinglist add = (Shoppinglist)serverMap.get(key);
            add.setState(0);
            this.mBuilder.add(add);
            this.mDatabase.insertList(add, user);
        }
        for (Shoppinglist sl : this.mBuilder.getAddedLists()) {
            this.syncItems(sl, user);
        }
        for (Shoppinglist sl : this.mBuilder.getEditedLists()) {
            this.syncItems(sl, user);
        }
    }

    private void syncListsModified(User user) {
        List<Shoppinglist> lists = this.mDatabase.getLists(user);
        Iterator<Shoppinglist> it = lists.iterator();
        while (it.hasNext()) {
            Shoppinglist sl = it.next();
            if (sl.getState() == 1) {
                it.remove();
            }
            if (sl.getState() == 0) {
                this.syncItems(sl, user);
                it.remove();
            }
            sl.setState(1);
        }
        this.mDatabase.insertLists(lists, user);
        for (Shoppinglist sl : lists) {
            this.requestListsModified(sl, user);
        }
    }

    private void requestListsModified(final Shoppinglist sl, final User user) {
        Response.Listener<JSONObject> modifiedListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    sl.setState(2);
                    try {
                        String modified = response.getString("modified");
                        if (sl.getModified().before(Utils.stringToDate(modified))) {
                            SyncManager.this.syncItems(sl, user);
                        } else {
                            SyncManager.this.mDatabase.editList(sl, user);
                        }
                    }
                    catch (JSONException e) {
                        SgnLog.e(TAG, e.getMessage(), e);
                        SyncManager.this.mDatabase.editList(sl, user);
                    }
                    SyncManager.this.popRequestAndPostShoppinglistEvent();
                } else {
                    SyncManager.this.popRequest();
                    SyncManager.this.revertList(sl, user);
                }
            }
        };
        JsonObjectRequest modifiedRequest = new JsonObjectRequest(Api.Endpoint.listModified(user.getUserId(), sl.getId()), modifiedListener);
        modifiedRequest.setSaveNetworkLog(false);
        this.addRequest(modifiedRequest);
    }

    private void syncItems(final Shoppinglist sl, final User user) {
        sl.setState(1);
        this.mDatabase.editList(sl, user);
        Response.Listener<JSONArray> itemListener = new Response.Listener<JSONArray>(){

            @Override
            public void onComplete(JSONArray response, ShopGunError error) {
                if (response != null) {
                    sl.setState(2);
                    SyncManager.this.mDatabase.editList(sl, user);
                    List<ShoppinglistItem> localItems = SyncManager.this.mDatabase.getItems(sl, user, true);
                    List<ShoppinglistItem> serverItems = ShoppinglistItem.fromJSON(response);
                    Collections.reverse(serverItems);
                    for (ShoppinglistItem sli : serverItems) {
                        sli.setState(2);
                    }
                    SyncManager.this.mergeItemsToDb(serverItems, localItems, user);
                    localItems = SyncManager.this.mDatabase.getItems(sl, user);
                    ListUtils.sortItems(localItems);
                    if (PermissionUtils.allowEdit(sl, user)) {
                        String tmp = "00000000-0000-0000-0000-000000000000";
                        for (ShoppinglistItem sli : localItems) {
                            if (!tmp.equals(sli.getPreviousId())) {
                                sli.setPreviousId(tmp);
                                sli.setModified(new Date());
                                sli.setState(0);
                                if (((SyncManager)SyncManager.this).mBuilder.items.containsKey(sli.getId())) {
                                    SyncManager.this.mBuilder.add(sli);
                                } else {
                                    SyncManager.this.mBuilder.edit(sli);
                                }
                                SyncManager.this.mDatabase.editItems(sli, user);
                            }
                            tmp = sli.getId();
                        }
                    }
                    SyncManager.this.popRequestAndPostShoppinglistEvent();
                } else {
                    SyncManager.this.popRequest();
                    SyncManager.this.revertList(sl, user);
                }
            }
        };
        JsonArrayRequest itemRequest = new JsonArrayRequest(Request.Method.GET, Api.Endpoint.listitems(user.getUserId(), sl.getId()), itemListener);
        itemRequest.getParameters().remove("offset");
        itemRequest.getParameters().remove("limit");
        itemRequest.setSaveNetworkLog(false);
        this.addRequest(itemRequest);
    }

    private void mergeItemsToDb(List<ShoppinglistItem> serverItems, List<ShoppinglistItem> localItems, User user) {
        if (serverItems.isEmpty() && localItems.isEmpty()) {
            return;
        }
        HashMap<String, ShoppinglistItem> localMap = new HashMap<String, ShoppinglistItem>();
        HashMap<String, ShoppinglistItem> serverMap = new HashMap<String, ShoppinglistItem>();
        HashSet union = new HashSet();
        for (ShoppinglistItem sli : localItems) {
            localMap.put(sli.getId(), sli);
        }
        for (ShoppinglistItem sli : serverItems) {
            serverMap.put(sli.getId(), sli);
        }
        union.addAll(serverMap.keySet());
        union.addAll(localMap.keySet());
        for (String key : union) {
            if (localMap.containsKey(key)) {
                ShoppinglistItem localSli = (ShoppinglistItem)localMap.get(key);
                if (serverMap.containsKey(key)) {
                    ShoppinglistItem serverSli = (ShoppinglistItem)serverMap.get(key);
                    if (localSli.getModified().before(serverSli.getModified())) {
                        this.mBuilder.edit(serverSli);
                        this.mDatabase.editItems(serverSli, user);
                        continue;
                    }
                    if (!localSli.getMeta().toString().equals(serverSli.getMeta().toString())) {
                        this.mBuilder.edit(serverSli);
                        this.mDatabase.editItems(serverSli, user);
                        continue;
                    }
                    if (!localSli.equals(serverSli)) continue;
                    SgnLog.d(TAG, "We have a mismatch");
                    continue;
                }
                ShoppinglistItem delSli = (ShoppinglistItem)localMap.get(key);
                if (delSli.getState() == 0) continue;
                this.mBuilder.del(delSli);
                this.mDatabase.deleteItem(delSli, user);
                continue;
            }
            ShoppinglistItem serverSli = (ShoppinglistItem)serverMap.get(key);
            this.mBuilder.add(serverSli);
            this.mDatabase.insertItem(serverSli, user);
        }
    }

    private boolean syncLocalListChanges(List<Shoppinglist> lists, User user) {
        int count = lists.size();
        block5: for (Shoppinglist sl : lists) {
            switch (sl.getState()) {
                case 0: {
                    this.putList(sl, user);
                    continue block5;
                }
                case 4: {
                    this.delList(sl, user);
                    continue block5;
                }
                case 5: {
                    this.revertList(sl, user);
                    continue block5;
                }
            }
            --count;
        }
        return count != 0;
    }

    private boolean syncLocalItemChanges(Shoppinglist sl, User user) {
        List<ShoppinglistItem> items = this.mDatabase.getItems(sl, user, true);
        int count = items.size();
        block5: for (ShoppinglistItem sli : items) {
            switch (sli.getState()) {
                case 0: {
                    this.putItem(sli, user);
                    continue block5;
                }
                case 4: {
                    this.delItem(sli, user);
                    continue block5;
                }
                case 5: {
                    this.revertItem(sli, user);
                    continue block5;
                }
            }
            --count;
        }
        return count != 0;
    }

    private void putList(final Shoppinglist sl, final User user) {
        sl.setState(1);
        this.mDatabase.editList(sl, user);
        Response.Listener<JSONObject> listListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    Shoppinglist serverSl = Shoppinglist.fromJSON(response);
                    Shoppinglist localSl = SyncManager.this.mDatabase.getList(serverSl.getId(), user);
                    if (localSl != null && !serverSl.getModified().equals(localSl.getModified())) {
                        serverSl.setState(2);
                        serverSl.setPreviousId(serverSl.getPreviousId() == null ? sl.getPreviousId() : serverSl.getPreviousId());
                        SyncManager.this.mDatabase.editList(serverSl, user);
                        SyncManager.this.mBuilder.edit(serverSl);
                    }
                    SyncManager.this.popRequest();
                    SyncManager.this.syncLocalItemChanges(sl, user);
                } else {
                    SyncManager.this.popRequest();
                    if (error.getCode() != 10200) {
                        SyncManager.this.revertList(sl, user);
                    }
                }
            }
        };
        String url = Api.Endpoint.list(user.getUserId(), sl.getId());
        JsonObjectRequest listReq = new JsonObjectRequest(Request.Method.PUT, url, sl.toJSON(), listListener);
        this.addRequest(listReq);
    }

    private void delList(final Shoppinglist sl, final User user) {
        Response.Listener<JSONObject> listListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    SyncManager.this.mDatabase.deleteList(sl, user);
                    SyncManager.this.mDatabase.deleteShares(sl, user);
                    SyncManager.this.mDatabase.deleteItems(sl.getId(), null, user);
                    SyncManager.this.popRequest();
                } else {
                    SyncManager.this.popRequest();
                    switch (error.getCode()) {
                        case 1501: {
                            SyncManager.this.mDatabase.deleteList(sl, user);
                            break;
                        }
                        case 10200: {
                            break;
                        }
                        default: {
                            SyncManager.this.revertList(sl, user);
                        }
                    }
                }
            }
        };
        String url = Api.Endpoint.list(user.getUserId(), sl.getId());
        JsonObjectRequest listReq = new JsonObjectRequest(Request.Method.DELETE, url, null, listListener);
        listReq.getParameters().put("modified", Utils.dateToString(sl.getModified()));
        this.addRequest(listReq);
    }

    private void revertList(final Shoppinglist sl, final User user) {
        if (sl.getState() != 5) {
            sl.setState(5);
            this.mDatabase.editList(sl, user);
        }
        Response.Listener<JSONObject> listListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    Shoppinglist serverSl = Shoppinglist.fromJSON(response);
                    serverSl.setState(2);
                    serverSl.setPreviousId(serverSl.getPreviousId() == null ? sl.getPreviousId() : serverSl.getPreviousId());
                    SyncManager.this.mDatabase.editList(serverSl, user);
                    SyncManager.this.mBuilder.add(serverSl);
                    SyncManager.this.syncLocalItemChanges(sl, user);
                } else {
                    SyncManager.this.mDatabase.deleteList(sl, user);
                    SyncManager.this.mBuilder.del(sl);
                }
                SyncManager.this.popRequestAndPostShoppinglistEvent();
            }
        };
        String url = Api.Endpoint.list(user.getUserId(), sl.getId());
        JsonObjectRequest listReq = new JsonObjectRequest(url, listListener);
        this.addRequest(listReq);
    }

    private void putItem(final ShoppinglistItem sli, final User user) {
        sli.setState(1);
        this.mDatabase.editItems(sli, user);
        Response.Listener<JSONObject> itemListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    ShoppinglistItem server = ShoppinglistItem.fromJSON(response);
                    ShoppinglistItem local = SyncManager.this.mDatabase.getItem(sli.getId(), user);
                    if (local != null && !local.getModified().equals(server.getModified())) {
                        server.setState(2);
                        if (server.getPreviousId() == null) {
                            server.setPreviousId(sli.getPreviousId());
                        }
                        SyncManager.this.mDatabase.editItems(server, user);
                        SyncManager.this.mBuilder.edit(server);
                    }
                    SyncManager.this.popRequestAndPostShoppinglistEvent();
                } else {
                    SyncManager.this.popRequest();
                    switch (error.getCode()) {
                        case 10200: {
                            break;
                        }
                        default: {
                            SyncManager.this.revertItem(sli, user);
                        }
                    }
                }
            }
        };
        String url = Api.Endpoint.listitem(user.getUserId(), sli.getShoppinglistId(), sli.getId());
        JsonObjectRequest itemReq = new JsonObjectRequest(Request.Method.PUT, url, sli.toJSON(), itemListener);
        this.addRequest(itemReq);
    }

    private void delItem(final ShoppinglistItem sli, final User user) {
        Response.Listener<JSONObject> itemListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    SyncManager.this.mDatabase.deleteItem(sli, user);
                    SyncManager.this.popRequest();
                } else {
                    SyncManager.this.popRequest();
                    switch (error.getCode()) {
                        case 1501: {
                            SyncManager.this.mDatabase.deleteItem(sli, user);
                            break;
                        }
                        case 10200: {
                            break;
                        }
                        default: {
                            SyncManager.this.revertItem(sli, user);
                        }
                    }
                }
            }
        };
        String url = Api.Endpoint.listitem(user.getUserId(), sli.getShoppinglistId(), sli.getId());
        JsonObjectRequest itemReq = new JsonObjectRequest(Request.Method.DELETE, url, null, itemListener);
        itemReq.getParameters().put("modified", Utils.dateToString(sli.getModified()));
        this.addRequest(itemReq);
    }

    private void revertItem(final ShoppinglistItem sli, final User user) {
        if (sli.getState() != 5) {
            sli.setState(5);
            this.mDatabase.editItems(sli, user);
        }
        Response.Listener<JSONObject> itemListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                List<ShoppinglistItem> items;
                if (response != null) {
                    ShoppinglistItem serverSli = ShoppinglistItem.fromJSON(response);
                    serverSli.setState(2);
                    serverSli.setPreviousId(serverSli.getPreviousId() == null ? sli.getPreviousId() : serverSli.getPreviousId());
                    SyncManager.this.mBuilder.edit(serverSli);
                } else {
                    SyncManager.this.mDatabase.deleteItem(sli, user);
                    SyncManager.this.mBuilder.del(sli);
                }
                Shoppinglist sl = SyncManager.this.mDatabase.getList(sli.getShoppinglistId(), user);
                if (sl != null && !(items = SyncManager.this.mDatabase.getItems(sl, user, true)).isEmpty()) {
                    Collections.sort(items, ShoppinglistItem.MODIFIED_DESCENDING);
                    ShoppinglistItem newestItem = items.get(0);
                    sl.setModified(newestItem.getModified());
                    SyncManager.this.mDatabase.editList(sl, user);
                    SyncManager.this.mBuilder.edit(sl);
                }
                SyncManager.this.popRequestAndPostShoppinglistEvent();
            }
        };
        String url = Api.Endpoint.listitem(user.getUserId(), sli.getShoppinglistId(), sli.getId());
        JsonObjectRequest itemReq = new JsonObjectRequest(url, itemListener);
        this.addRequest(itemReq);
    }

    private boolean syncLocalShareChanges(Shoppinglist sl, User user) {
        List<Share> shares = this.mDatabase.getShares(sl, user, true);
        int count = shares.size();
        block5: for (Share s : shares) {
            if (s.isAccessOwner()) {
                if (s.getState() == 4) {
                    this.mDatabase.deleteShare(s, user);
                    SgnLog.v(TAG, "API doesn't allow owner to be 'deleted'. Deleting from own DB and ignoring.");
                } else if (s.getState() != 2) {
                    s.setState(2);
                    s.setShoppinglistId(sl.getId());
                    this.mDatabase.editShare(s, user);
                    SgnLog.v(TAG, "Owner cannot be edited. Resetting share.state and ignoring.");
                }
                --count;
                continue;
            }
            switch (s.getState()) {
                case 0: {
                    this.putShare(s, user);
                    continue block5;
                }
                case 4: {
                    this.delShare(s, user);
                    continue block5;
                }
                case 5: {
                    this.revertShare(s, user);
                    continue block5;
                }
            }
            --count;
        }
        return count != 0;
    }

    private void putShare(final Share s, final User user) {
        s.setState(1);
        this.mDatabase.editShare(s, user);
        Response.Listener<JSONObject> shareListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    Share serverShare = Share.fromJSON(response);
                    serverShare.setState(2);
                    serverShare.setShoppinglistId(s.getShoppinglistId());
                    SyncManager.this.mDatabase.editShare(serverShare, user);
                    SyncManager.this.popRequest();
                } else if (error.getFailedOnField() != null) {
                    SyncManager.this.mDatabase.deleteShare(s, user);
                    Shoppinglist sl = SyncManager.this.mDatabase.getList(s.getShoppinglistId(), user);
                    if (sl != null) {
                        sl.removeShare(s);
                        SyncManager.this.mBuilder.edit(sl);
                        SyncManager.this.popRequestAndPostShoppinglistEvent();
                    } else {
                        SyncManager.this.popRequest();
                    }
                } else {
                    SyncManager.this.popRequest();
                    SyncManager.this.revertShare(s, user);
                }
            }
        };
        String url = Api.Endpoint.listShareEmail(user.getUserId(), s.getShoppinglistId(), s.getEmail());
        JsonObjectRequest shareReq = new JsonObjectRequest(Request.Method.PUT, url, s.toJSON(), shareListener);
        this.addRequest(shareReq);
    }

    private void delShare(final Share s, final User user) {
        Response.Listener<JSONObject> shareListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    if (user.getEmail().equals(s.getEmail())) {
                        SyncManager.this.mDatabase.deleteList(s.getShoppinglistId(), user);
                        SyncManager.this.mDatabase.deleteItems(s.getShoppinglistId(), null, user);
                        SyncManager.this.mDatabase.deleteShares(s.getShoppinglistId(), user);
                    } else {
                        SyncManager.this.mDatabase.deleteShare(s, user);
                    }
                    SyncManager.this.popRequest();
                } else {
                    SyncManager.this.popRequest();
                    switch (error.getCode()) {
                        case 10200: {
                            break;
                        }
                        case 1501: {
                            SyncManager.this.mDatabase.deleteShare(s, user);
                            break;
                        }
                        default: {
                            SyncManager.this.revertShare(s, user);
                        }
                    }
                }
            }
        };
        String url = Api.Endpoint.listShareEmail(user.getUserId(), s.getShoppinglistId(), s.getEmail());
        JsonObjectRequest shareReq = new JsonObjectRequest(Request.Method.DELETE, url, null, shareListener);
        this.addRequest(shareReq);
    }

    private void revertShare(final Share s, final User user) {
        if (s.getState() != 5) {
            s.setState(5);
            this.mDatabase.editShare(s, user);
        }
        Response.Listener<JSONObject> shareListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    Share serverShare = Share.fromJSON(response);
                    serverShare.setState(2);
                    serverShare.setShoppinglistId(s.getShoppinglistId());
                    SyncManager.this.mDatabase.editShare(serverShare, user);
                    Shoppinglist sl = SyncManager.this.mDatabase.getList(s.getShoppinglistId(), user);
                    if (sl != null) {
                        sl.removeShare(s);
                        SyncManager.this.mBuilder.edit(sl);
                        SyncManager.this.popRequestAndPostShoppinglistEvent();
                    } else {
                        SyncManager.this.popRequest();
                    }
                } else {
                    SyncManager.this.mDatabase.deleteShare(s, user);
                    SyncManager.this.popRequest();
                }
            }
        };
        String url = Api.Endpoint.listShareEmail(user.getUserId(), s.getShoppinglistId(), s.getEmail());
        JsonObjectRequest shareReq = new JsonObjectRequest(url, shareListener);
        this.addRequest(shareReq);
    }

    private void popRequestAndPostShoppinglistEvent() {
        this.popRequest();
        if (this.mCurrentRequests.isEmpty() && !this.isPaused() && this.mBuilder.hasChanges()) {
            final ShoppinglistEvent e = this.mBuilder.build();
            this.mBuilder = new ShoppinglistEvent.Builder(true);
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    SgnBus.getInstance().post((Object)e);
                }
            });
        }
    }

    static class SyncLog {
        private static final boolean LOG_SYNC = false;
        private static final boolean LOG = false;

        SyncLog() {
        }

        public static int sync(String tag, String msg) {
            return 0;
        }

        public static int log(String tag, String msg) {
            return 0;
        }
    }

    public static interface SyncSpeed {
        public static final int SLOW = 10000;
        public static final int MEDIUM = 6000;
        public static final int FAST = 3000;
    }
}

