/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.shoppinglists;

import com.shopgun.android.sdk.database.DatabaseWrapper;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.model.User;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.JsonObjectRequest;
import com.shopgun.android.sdk.shoppinglists.SyncManagerHelper;
import com.shopgun.android.sdk.utils.Api;
import java.util.ArrayList;
import org.json.JSONObject;

public class ListSyncHelper
extends SyncManagerHelper<Shoppinglist> {
    public ListSyncHelper(DatabaseWrapper database) {
        super(database);
    }

    @Override
    public boolean syncLocalChanges(ArrayList<Shoppinglist> lists, User user) {
        int count = lists.size();
        block5: for (Shoppinglist sl : lists) {
            switch (sl.getState()) {
                case 0: {
                    this.put(sl, user);
                    continue block5;
                }
                case 4: {
                    this.delete(sl, user);
                    continue block5;
                }
                case 5: {
                    this.revert(sl, user);
                    continue block5;
                }
            }
            --count;
        }
        return count != 0;
    }

    @Override
    public boolean put(final Shoppinglist object, final User user) {
        object.setState(1);
        this.getDB().editList(object, user);
        Response.Listener<JSONObject> listListener = new Response.Listener<JSONObject>(){

            @Override
            public void onComplete(JSONObject response, ShopGunError error) {
                if (response != null) {
                    Shoppinglist serverSl = Shoppinglist.fromJSON(response);
                    Shoppinglist localSl = ListSyncHelper.this.getDB().getList(serverSl.getId(), user);
                    if (localSl != null && !serverSl.getModified().equals(localSl.getModified())) {
                        serverSl.setState(2);
                        serverSl.setPreviousId(serverSl.getPreviousId() == null ? object.getPreviousId() : serverSl.getPreviousId());
                        ListSyncHelper.this.getDB().editList(serverSl, user);
                    }
                    ListSyncHelper.this.popRequest();
                } else {
                    ListSyncHelper.this.popRequest();
                    if (error.getCode() != 10200) {
                        ListSyncHelper.this.revert(object, user);
                    }
                }
            }
        };
        String url = Api.Endpoint.list(user.getUserId(), object.getId());
        JsonObjectRequest listReq = new JsonObjectRequest(Request.Method.PUT, url, object.toJSON(), listListener);
        this.addRequest(listReq);
        return true;
    }

    @Override
    public boolean delete(Shoppinglist object, User user) {
        return false;
    }

    @Override
    public boolean insert(Shoppinglist object, User user) {
        return false;
    }

    @Override
    public boolean revert(Shoppinglist object, User user) {
        return false;
    }
}

