/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.requests;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.RequestQueue;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.JsonArrayRequest;
import com.shopgun.android.sdk.requests.InternalOkError;
import com.shopgun.android.sdk.requests.LoaderDelivery;
import com.shopgun.android.sdk.requests.LoaderRequest;
import com.shopgun.android.sdk.requests.ModelListLoaderRequest;
import com.shopgun.android.sdk.requests.ModelRequestTools;
import java.util.ArrayList;
import org.json.JSONArray;

public abstract class ModelListRequest<T>
extends JsonArrayRequest
implements Delivery {
    public static final String TAG = Constants.getTag(ModelListRequest.class);
    private final ModelListLoaderRequest<T> mLoaderRequest;
    private final LoaderRequest.Listener<T> mLoaderListener;
    private final LoaderDelivery<T> mDelivery;

    public ModelListRequest(String url, LoaderRequest.Listener<T> listener) {
        this(url, null, listener);
    }

    public ModelListRequest(String url, ModelListLoaderRequest<T> request, LoaderRequest.Listener<T> listener) {
        super(url, (Response.Listener<JSONArray>)null);
        this.mLoaderRequest = request;
        this.mLoaderListener = listener;
        this.mDelivery = new LoaderDelivery<T>(this.mLoaderListener);
    }

    public ModelListLoaderRequest<T> getLoaderRequest() {
        return this.mLoaderRequest;
    }

    @Override
    public synchronized Request setRequestQueue(RequestQueue requestQueue) {
        super.setRequestQueue(requestQueue);
        if (this.getTag() == null) {
            this.setTag(new Object());
        }
        super.setDelivery(this);
        return this;
    }

    @Override
    public Response<JSONArray> parseCache(Cache c) {
        if (this.mLoaderRequest != null && this.mLoaderRequest.getData() != null) {
            return Response.fromError(new InternalOkError());
        }
        return super.parseCache(c);
    }

    @Override
    public Request setDelivery(Delivery d) {
        throw new RuntimeException(new IllegalAccessException("Custom delivery for model requests is not allowed"));
    }

    public abstract T parse(JSONArray var1);

    @Override
    public synchronized void cancel() {
        super.cancel();
        if (this.mLoaderRequest != null) {
            this.mLoaderRequest.cancel();
        }
    }

    @Override
    public synchronized void postResponse(Request<?> request, Response<?> response) {
        request.addEvent("post-response");
        if (this.isCanceled()) {
            request.addEvent("loaderRequest-have-been-canceled");
        } else if (response.isSuccess()) {
            request.addEvent("parsing-response-to-model-objects");
            T data = this.parse((JSONArray)response.result);
            boolean intermediate = ModelRequestTools.runLoader(this, this.mLoaderRequest, data, this.getRequestQueue());
            this.mDelivery.deliver((Request)this, response, data, new ArrayList<ShopGunError>(0), intermediate);
        } else if (response.error instanceof InternalOkError) {
            request.addEvent("running-loader-request-with-original-data");
            Object data = this.mLoaderRequest.getData();
            boolean intermediate = ModelRequestTools.runLoader(this, this.mLoaderRequest, data, this.getRequestQueue());
            this.mDelivery.deliver((Request)this, response, data, new ArrayList<ShopGunError>(0), intermediate);
        } else {
            this.mDelivery.deliver((Request)this, response, null, response.error, false);
        }
    }

    protected boolean loadDealer() {
        return this.mLoaderRequest.loadDealer();
    }

    protected ModelListRequest<T> loadDealer(boolean dealer) {
        this.mLoaderRequest.loadDealer(dealer);
        return this;
    }

    protected boolean loadHotspots() {
        return this.mLoaderRequest.loadHotspots();
    }

    protected ModelListRequest<T> loadHotspots(boolean hotspots) {
        this.mLoaderRequest.loadHotspots(hotspots);
        return this;
    }

    protected boolean loadPages() {
        return this.mLoaderRequest.loadPages();
    }

    protected ModelListRequest<T> loadPages(boolean pages) {
        this.mLoaderRequest.loadPages(pages);
        return this;
    }

    protected boolean loadStore() {
        return this.mLoaderRequest.loadStore();
    }

    protected ModelListRequest<T> loadStore(boolean store) {
        this.mLoaderRequest.loadStore(store);
        return this;
    }

    protected boolean loadCatalog() {
        return this.mLoaderRequest.loadCatalog();
    }

    protected ModelListRequest<T> loadCatalog(boolean catalog) {
        this.mLoaderRequest.loadCatalog(catalog);
        return this;
    }
}

