/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.photoview.gestures;

import android.view.MotionEvent;
import com.shopgun.android.sdk.photoview.PhotoView;

public interface OnGestureListener {
    public void onDrag(float var1, float var2);

    public void onFling(float var1, float var2, float var3, float var4);

    public void onScale(float var1, float var2, float var3);

    public boolean onSingleTab(MotionEvent var1);

    public boolean onDoubleTab(MotionEvent var1);

    public boolean onLongPress(MotionEvent var1);

    public static class SimpleOnGestureListener
    implements OnGestureListener {
        private PhotoView mPhotoview;

        public SimpleOnGestureListener(PhotoView photoView) {
            this.setPhotoView(photoView);
        }

        public PhotoView getPhotoView() {
            return this.mPhotoview;
        }

        public void setPhotoView(PhotoView photoView) {
            this.mPhotoview = photoView;
        }

        @Override
        public void onDrag(float dx, float dy) {
            this.mPhotoview.onDrag(dx, dy);
        }

        @Override
        public void onFling(float startX, float startY, float velocityX, float velocityY) {
            this.mPhotoview.onFling(startX, startY, velocityX, velocityY);
        }

        @Override
        public void onScale(float scaleFactor, float focusX, float focusY) {
            this.mPhotoview.onScale(scaleFactor, focusX, focusY);
        }

        @Override
        public boolean onSingleTab(MotionEvent e) {
            return this.mPhotoview.onSingleTab(e);
        }

        @Override
        public boolean onDoubleTab(MotionEvent e) {
            return this.mPhotoview.onDoubleTab(e);
        }

        @Override
        public boolean onLongPress(MotionEvent e) {
            return this.mPhotoview.onLongPress(e);
        }
    }
}

