/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.photoview.gestures;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.photoview.gestures.GestureDetector;
import com.shopgun.android.sdk.photoview.gestures.OnGestureListener;

public class CupcakeGestureDetector
implements GestureDetector {
    public static final String TAG = Constants.getTag(CupcakeGestureDetector.class);
    final float mTouchSlop;
    final float mMinimumVelocity;
    final android.view.GestureDetector mGestureDetector;
    protected OnGestureListener mListener;
    final GestureDetector.SimpleOnGestureListener mSimpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public void onLongPress(MotionEvent e) {
            if (CupcakeGestureDetector.this.mListener != null) {
                CupcakeGestureDetector.this.mListener.onLongPress(e);
            }
        }

        public boolean onDoubleTap(MotionEvent e) {
            return CupcakeGestureDetector.this.mListener != null && CupcakeGestureDetector.this.mListener.onDoubleTab(e);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            return CupcakeGestureDetector.this.mListener != null && CupcakeGestureDetector.this.mListener.onSingleTab(e);
        }
    };
    float mLastTouchX;
    float mLastTouchY;
    private VelocityTracker mVelocityTracker;
    private boolean mIsDragging;

    public CupcakeGestureDetector(Context context) {
        this.mGestureDetector = new android.view.GestureDetector(context, (GestureDetector.OnGestureListener)this.mSimpleOnGestureListener);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mTouchSlop = configuration.getScaledTouchSlop();
    }

    @Override
    public void setOnGestureListener(OnGestureListener listener) {
        this.mListener = listener;
    }

    float getActiveX(MotionEvent ev) {
        return ev.getX();
    }

    float getActiveY(MotionEvent ev) {
        return ev.getY();
    }

    @Override
    public boolean isScaling() {
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.mVelocityTracker = VelocityTracker.obtain();
                if (null != this.mVelocityTracker) {
                    this.mVelocityTracker.addMovement(ev);
                } else {
                    SgnLog.i(TAG, "Velocity tracker is null");
                }
                this.mLastTouchX = this.getActiveX(ev);
                this.mLastTouchY = this.getActiveY(ev);
                this.mIsDragging = false;
                break;
            }
            case 2: {
                float x = this.getActiveX(ev);
                float y = this.getActiveY(ev);
                float dx = x - this.mLastTouchX;
                float dy = y - this.mLastTouchY;
                if (!this.mIsDragging) {
                    boolean bl = this.mIsDragging = Math.sqrt(dx * dx + dy * dy) >= (double)this.mTouchSlop;
                }
                if (!this.mIsDragging) break;
                if (this.mListener != null) {
                    this.mListener.onDrag(dx, dy);
                }
                this.mLastTouchX = x;
                this.mLastTouchY = y;
                if (null == this.mVelocityTracker) break;
                this.mVelocityTracker.addMovement(ev);
                break;
            }
            case 3: {
                if (null == this.mVelocityTracker) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 1: {
                if (this.mIsDragging && null != this.mVelocityTracker) {
                    this.mLastTouchX = this.getActiveX(ev);
                    this.mLastTouchY = this.getActiveY(ev);
                    this.mVelocityTracker.addMovement(ev);
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float vX = this.mVelocityTracker.getXVelocity();
                    float vY = this.mVelocityTracker.getYVelocity();
                    if (Math.max(Math.abs(vX), Math.abs(vY)) >= this.mMinimumVelocity && this.mListener != null) {
                        this.mListener.onFling(this.mLastTouchX, this.mLastTouchY, -vX, -vY);
                    }
                }
                if (null == this.mVelocityTracker) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        this.mGestureDetector.onTouchEvent(ev);
        return true;
    }
}

