/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.photoview;

import android.annotation.TargetApi;
import android.os.Build;
import android.view.View;

public class Compat {
    private static final int SIXTY_FPS_INTERVAL = 16;

    public static void postOnAnimation(View view, Runnable runnable) {
        if (Build.VERSION.SDK_INT >= 16) {
            Compat.postOnAnimationJellyBean(view, runnable);
        } else {
            view.postDelayed(runnable, 16L);
        }
    }

    @TargetApi(value=16)
    private static void postOnAnimationJellyBean(View view, Runnable runnable) {
        view.postOnAnimation(runnable);
    }

    public static int getPointerIndex(int action) {
        if (Build.VERSION.SDK_INT >= 11) {
            return Compat.getPointerIndexHoneyComb(action);
        }
        return Compat.getPointerIndexEclair(action);
    }

    @TargetApi(value=5)
    private static int getPointerIndexEclair(int action) {
        return (action & 0xFF00) >> 8;
    }

    @TargetApi(value=11)
    private static int getPointerIndexHoneyComb(int action) {
        return (action & 0xFF00) >> 8;
    }
}

