/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip.widget;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.widget.TextView;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.R;

public class LoadingTextView
extends TextView {
    public static final String TAG = Constants.getTag(LoadingTextView.class);
    public static final int DELAY = 350;
    public static final int NUM_DOTS = 5;
    private Handler mHandler;
    private int mDots = 1;
    private boolean mCountUp = true;
    private String mLoadingText;
    Runnable mTextRunner = new Runnable(){

        @Override
        public void run() {
            LoadingTextView.this.mHandler.postDelayed(LoadingTextView.this.mTextRunner, 350L);
            StringBuilder sb = new StringBuilder();
            sb.append(LoadingTextView.this.mLoadingText == null ? "" : LoadingTextView.this.mLoadingText).append("\n");
            for (int i = 0; i < LoadingTextView.this.mDots; ++i) {
                sb.append(".");
            }
            LoadingTextView.this.setText(sb.toString());
            if (LoadingTextView.this.mCountUp) {
                LoadingTextView.this.mDots++;
                LoadingTextView.this.mCountUp = LoadingTextView.this.mDots != 5;
            } else {
                LoadingTextView.this.mDots--;
                LoadingTextView.this.mCountUp = LoadingTextView.this.mDots == 1;
            }
        }
    };

    public LoadingTextView(Context context) {
        super(context);
        this.init();
    }

    public LoadingTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LoadingTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void init() {
        this.mHandler = new Handler();
    }

    public void setLoadingText(String header) {
        this.mLoadingText = header;
    }

    public void error() {
        this.error(this.getResources().getString(R.string.com_shopgun_android_sdk_pageflip_page_error, new Object[]{this.mLoadingText}));
    }

    public void error(String text) {
        this.stop();
        super.setText((CharSequence)text);
    }

    public void stop() {
        this.mHandler.removeCallbacks(this.mTextRunner);
        this.mDots = 1;
        this.mCountUp = true;
    }

    public void start() {
        this.stop();
        this.mTextRunner.run();
    }
}

