/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip.utils;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Hotspot;
import java.util.List;

public class PageflipClickCoordinate {
    public static final String TAG = Constants.getTag(PageflipClickCoordinate.class);
    private final int mPage;
    private final float mActualX;
    private final float mActualY;
    private final List<Hotspot> mHotspots;

    public PageflipClickCoordinate(Catalog c, int[] pages, float x, float y) {
        float pagesLength = pages.length;
        float pageWidth = 1.0f / pagesLength;
        int position = (int)Math.floor(x / pageWidth);
        this.mPage = pages[position];
        this.mActualX = x % pageWidth * pagesLength;
        this.mActualY = y;
        this.mHotspots = c.getHotspots().getHotspots(this.mPage, this.mActualX, this.mActualY, pages);
    }

    public int getPage() {
        return this.mPage;
    }

    public float getX() {
        return this.mActualX;
    }

    public float getY() {
        return this.mActualY;
    }

    public List<Hotspot> getHotspots() {
        return this.mHotspots;
    }

    public String toString() {
        String format = "%s[page:%s, x:%2f, y:%2f, hotspot.size:%s]";
        return String.format(format, PageflipClickCoordinate.class.getSimpleName(), this.mPage, Float.valueOf(this.mActualX), Float.valueOf(this.mActualY), this.mHotspots.size());
    }
}

