/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip.stats.impl;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.api.Endpoints;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.pageflip.Orientation;
import com.shopgun.android.sdk.pageflip.ReaderConfig;
import com.shopgun.android.sdk.pageflip.stats.Clock;
import com.shopgun.android.sdk.pageflip.stats.PageEvent;
import com.shopgun.android.sdk.pageflip.stats.PageflipStatsCollector;
import com.shopgun.android.sdk.pageflip.stats.StatDelivery;
import com.shopgun.android.sdk.pageflip.utils.PageflipUtils;
import java.util.ArrayList;
import java.util.List;

public class PageflipStatsCollectorImpl
implements PageflipStatsCollector {
    public static final String TAG = Constants.getTag(PageflipStatsCollectorImpl.class);
    private static final boolean LOG = false;
    private final String mViewSession;
    private final String mCatalogId;
    private final int[] mPages;
    private final Orientation mOrientation;
    private final Clock mClock;
    private final StatDelivery mDelivery;
    private PageEvent mView;
    private PageEvent mZoom;

    public PageflipStatsCollectorImpl(String viewSession, Catalog catalog, int[] pages, ReaderConfig config, Clock clock, StatDelivery delivery) {
        this(viewSession, catalog.getId(), pages, config.getOrientation(), clock, delivery);
    }

    public PageflipStatsCollectorImpl(String viewSession, String catalogId, int[] pages, Orientation orientation, Clock clock, StatDelivery delivery) {
        this.mViewSession = viewSession;
        this.mCatalogId = catalogId;
        this.mPages = pages;
        this.mOrientation = orientation;
        this.mClock = clock;
        this.mDelivery = delivery;
    }

    @Override
    public void startView() {
        this.log("startView");
        if (this.mView == null) {
            this.mView = PageEvent.view(this.mViewSession, this.mPages, this.mOrientation, this.mClock);
        }
        this.mView.start();
    }

    @Override
    public void stopView() {
        this.log("stopView");
        if (this.mView == null) {
            this.mView = PageEvent.view(this.mViewSession, this.mPages, this.mOrientation, this.mClock);
        }
        if (this.mZoom != null) {
            this.stopZoom();
        }
        this.mView.stop();
    }

    @Override
    public void startZoom() {
        this.log("startZoom");
        this.startView();
        if (this.mZoom != null) {
            this.stopZoom();
        }
        this.mZoom = PageEvent.zoom(this.mViewSession, this.mPages, this.mOrientation, this.mClock);
        this.mView.addSubEvent(this.mZoom);
        this.mZoom.start();
    }

    @Override
    public void stopZoom() {
        this.log("stopZoom");
        if (this.mZoom == null) {
            this.startView();
            this.mZoom = PageEvent.zoom(this.mViewSession, this.mPages, this.mOrientation, this.mClock);
            this.mView.addSubEvent(this.mZoom);
        }
        this.mZoom.stop();
        this.mZoom = null;
    }

    @Override
    public void collect() {
        this.log("collect");
        if (this.mView == null) {
            this.log("Nothing to collect, ignoring");
            return;
        }
        if (this.mView.isCollected()) {
            this.log("Already collected, ignore");
            return;
        }
        this.stopView();
        for (PageEvent ve : this.getEvents()) {
            if (ve.isCollected()) {
                return;
            }
            ve.setCollected(true);
            this.mDelivery.deliver(Endpoints.catalogCollect(this.mCatalogId), ve.toJSON());
        }
    }

    public PageEvent getCurrentEvent() {
        return this.mView;
    }

    @Override
    public PageEvent getRootEvent() {
        return this.mView;
    }

    @Override
    public List<PageEvent> getEvents() {
        ArrayList<PageEvent> list = new ArrayList<PageEvent>();
        if (this.mView != null) {
            list.add(this.mView);
            list.addAll(this.mView.getSubEventsRecursive());
        }
        return list;
    }

    @Override
    public void reset() {
        this.mView = null;
        this.mZoom = null;
    }

    private void log(String s) {
    }

    public String toString() {
        String format = "%s[ viewSession:%s, catalogId:%s, pages:%s, orientation:%s, clock:%s, delivery:%s ]";
        return String.format(format, this.getClass().getSimpleName(), this.mViewSession, this.mCatalogId, PageflipUtils.join("-", this.mPages), this.mOrientation.toString(), this.mClock.getClass().getSimpleName(), this.mDelivery.getClass().getSimpleName());
    }
}

