/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip.stats;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.pageflip.Orientation;
import com.shopgun.android.sdk.pageflip.stats.Clock;
import com.shopgun.android.sdk.pageflip.stats.EventType;
import com.shopgun.android.sdk.pageflip.utils.PageflipUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class PageEvent {
    public static final String TAG = Constants.getTag(PageEvent.class);
    private final EventType mEventType;
    private final String mViewSession;
    private final int[] mPages;
    private final Orientation mOrientation;
    private final Clock mClock;
    private boolean mCollected = false;
    private boolean mStarted = false;
    private boolean mStopped = false;
    private long mStart = 0L;
    private long mStop = 0L;
    private ArrayList<PageEvent> mSubEvents = new ArrayList();

    public static PageEvent view(String viewSession, int[] pages, Orientation orientation, Clock c) {
        return new PageEvent(EventType.VIEW, viewSession, orientation, pages, c);
    }

    public static PageEvent zoom(String viewSession, int[] pages, Orientation orientation, Clock c) {
        return new PageEvent(EventType.ZOOM, viewSession, orientation, pages, c);
    }

    public PageEvent(EventType type, String viewSession, Orientation orientation, int[] pages, Clock c) {
        this.mEventType = type;
        this.mViewSession = viewSession;
        this.mPages = pages;
        this.mOrientation = orientation;
        this.mClock = c;
    }

    public void start() {
        if (!this.isStarted()) {
            this.mStart = this.mClock.now();
        }
        this.mStarted = true;
    }

    public void stop() {
        if (this.isActive()) {
            this.mStop = this.mClock.now();
        } else if (!this.isStarted()) {
            long now;
            this.mStart = now = this.mClock.now();
            this.mStop = now;
        }
        this.mStopped = true;
    }

    public long getDuration() {
        long delta = 0L;
        for (PageEvent e : this.getSubEvents()) {
            delta += e.getDuration();
        }
        return this.getDurationAbsolute() - delta;
    }

    public long getDurationAbsolute() {
        return (this.isActive() ? this.mClock.now() : this.mStop) - this.mStart;
    }

    public boolean isActive() {
        return this.mStarted && !this.mStopped;
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    public boolean isStopped() {
        return this.mStopped;
    }

    public void reset() {
        this.mStarted = false;
        this.mStopped = false;
        this.mStart = 0L;
        this.mStop = 0L;
        for (PageEvent e : this.mSubEvents) {
            e.reset();
        }
        this.mSubEvents.clear();
    }

    public EventType getType() {
        return this.mEventType;
    }

    public String getViewSession() {
        return this.mViewSession;
    }

    public int[] getPages() {
        return this.mPages;
    }

    public long getStart() {
        return this.mStart;
    }

    public long getStop() {
        return this.mStop;
    }

    public Clock getClock() {
        return this.mClock;
    }

    private Orientation getOrientation() {
        return this.mOrientation;
    }

    public boolean isCollected() {
        return this.mCollected;
    }

    public void setCollected(boolean collected) {
        this.mCollected = collected;
    }

    public void addSubEvent(PageEvent e) {
        this.mSubEvents.add(e);
    }

    public List<PageEvent> getSubEvents() {
        return this.mSubEvents;
    }

    public List<PageEvent> getSubEventsRecursive() {
        if (this.mSubEvents.isEmpty()) {
            return this.mSubEvents;
        }
        ArrayList<PageEvent> tmp = new ArrayList<PageEvent>(this.mSubEvents);
        for (PageEvent e : this.mSubEvents) {
            tmp.addAll(e.getSubEventsRecursive());
        }
        return tmp;
    }

    public String toString() {
        return "";
    }

    public JSONObject toDebugJSON() {
        JSONObject o = this.toJSON();
        try {
            o.put("start", this.mStart);
            o.put("stop", this.mStop);
            o.put("clock", (Object)this.mClock.getClass().getSimpleName());
            o.put("sub-event-count", this.mSubEvents.size());
            o.put("durationAbs", this.getDurationAbsolute());
        }
        catch (JSONException e) {
            SgnLog.d(TAG, e.getMessage(), e);
        }
        return o;
    }

    public JSONObject toJSON() {
        try {
            JSONObject o = new JSONObject();
            o.put("type", (Object)this.mEventType.toString());
            o.put("ms", this.getDuration());
            o.put("orientation", (Object)this.mOrientation.toString());
            o.put("pages", (Object)PageflipUtils.join(",", this.mPages));
            o.put("view_session", (Object)this.mViewSession);
            return o;
        }
        catch (JSONException e) {
            SgnLog.d(TAG, e.getMessage(), e);
            return new JSONObject();
        }
    }
}

