/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip;

import android.content.Context;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.shopgun.android.sdk.Constants;
import java.lang.reflect.Field;

public class PageflipViewPager
extends ViewPager {
    public static final String TAG = Constants.getTag(PageflipViewPager.class);
    private OnPageBoundListener mOnPageBoundListener;
    private ScrollerCustomDuration mScroller = null;
    private boolean mIsBeingDragged = false;
    private float mLastMotionX;
    private boolean mOutOfBoundsCalled = false;

    public PageflipViewPager(Context context) {
        super(context);
        this.init();
    }

    public PageflipViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.setScroller();
    }

    public void setOnPageBound(OnPageBoundListener l) {
        this.mOnPageBoundListener = l;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.mIsBeingDragged = false;
        try {
            this.mIsBeingDragged = super.onInterceptTouchEvent(ev);
            this.mLastMotionX = ev.getX();
        }
        catch (IllegalArgumentException e) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        boolean isWorking = false;
        try {
            isWorking = super.onTouchEvent(ev);
            if (this.mIsBeingDragged && isWorking) {
                this.tryBounds(ev);
            }
        }
        catch (IllegalArgumentException e) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return isWorking;
    }

    private void tryBounds(MotionEvent ev) {
        switch (ev.getAction() & 0xFF) {
            case 2: {
                if (this.mOutOfBoundsCalled) break;
                float x = ev.getX();
                float deltaX = this.mLastMotionX - x;
                this.mLastMotionX = x;
                int lastItemIndex = this.getAdapter().getCount() - 1;
                int currentItem = this.getCurrentItem();
                if (deltaX < 0.0f && currentItem == 0) {
                    if (this.mOnPageBoundListener != null) {
                        this.mOnPageBoundListener.onLeftBound();
                    }
                    this.mOutOfBoundsCalled = true;
                    break;
                }
                if (!(deltaX > 0.0f) || currentItem != lastItemIndex) break;
                if (this.mOnPageBoundListener != null) {
                    this.mOnPageBoundListener.onRightBound();
                }
                this.mOutOfBoundsCalled = true;
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                this.mOutOfBoundsCalled = false;
            }
        }
    }

    private void setScroller() {
        try {
            Class<ViewPager> viewpager = ViewPager.class;
            Field scroller = viewpager.getDeclaredField("mScroller");
            scroller.setAccessible(true);
            Field interpolator = viewpager.getDeclaredField("sInterpolator");
            interpolator.setAccessible(true);
            this.mScroller = new ScrollerCustomDuration(this.getContext(), (Interpolator)interpolator.get(null));
            scroller.set((Object)this, (Object)this.mScroller);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setScrollDurationFactor(double scrollFactor) {
        this.mScroller.setScrollDurationFactor(scrollFactor);
    }

    public static interface OnPageBoundListener {
        public void onLeftBound();

        public void onRightBound();
    }

    public class ScrollerCustomDuration
    extends Scroller {
        private double mScrollFactor;

        public ScrollerCustomDuration(Context context) {
            super(context);
            this.mScrollFactor = 1.0;
        }

        public ScrollerCustomDuration(Context context, Interpolator interpolator) {
            super(context, interpolator);
            this.mScrollFactor = 1.0;
        }

        public void setScrollDurationFactor(double scrollFactor) {
            this.mScrollFactor = scrollFactor;
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            super.startScroll(startX, startY, dx, dy, (int)((double)duration * this.mScrollFactor));
        }
    }
}

