/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.R;
import com.shopgun.android.sdk.SgnFragment;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Branding;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Hotspot;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.pageflip.CatalogPageCallback;
import com.shopgun.android.sdk.pageflip.CatalogPagerAdapter;
import com.shopgun.android.sdk.pageflip.OnDrawPage;
import com.shopgun.android.sdk.pageflip.PageOverviewDialog;
import com.shopgun.android.sdk.pageflip.PageflipListener;
import com.shopgun.android.sdk.pageflip.PageflipPage;
import com.shopgun.android.sdk.pageflip.PageflipViewPager;
import com.shopgun.android.sdk.pageflip.ReaderConfig;
import com.shopgun.android.sdk.pageflip.impl.DoublePageReaderConfig;
import com.shopgun.android.sdk.pageflip.stats.Clock;
import com.shopgun.android.sdk.pageflip.stats.PageflipStatsCollector;
import com.shopgun.android.sdk.pageflip.stats.StatDelivery;
import com.shopgun.android.sdk.pageflip.stats.impl.ClockFactory;
import com.shopgun.android.sdk.pageflip.stats.impl.PageflipStatsCollectorImpl;
import com.shopgun.android.sdk.pageflip.stats.impl.StatDeliveryImpl;
import com.shopgun.android.sdk.pageflip.utils.PageflipUtils;
import com.shopgun.android.sdk.pageflip.widget.LoadingTextView;
import com.shopgun.android.sdk.requests.LoaderRequest;
import com.shopgun.android.sdk.requests.impl.CatalogRequest;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

public class PageflipFragment
extends SgnFragment
implements LoaderRequest.Listener<Catalog> {
    public static final String TAG = Constants.getTag(PageflipFragment.class);
    public static final String ARG_CATALOG = Constants.getArg(PageflipFragment.class, "catalog");
    public static final String ARG_CATALOG_ID = Constants.getArg(PageflipFragment.class, "catalog-id");
    public static final String ARG_READER_CONFIG = Constants.getArg(PageflipFragment.class, "reader-config");
    public static final String ARG_PAGE = Constants.getArg(PageflipFragment.class, "page");
    public static final String ARG_VIEW_SESSION = Constants.getArg(PageflipFragment.class, "view-session");
    public static final String ARG_BRANDING = Constants.getArg(PageflipFragment.class, "branding");
    private static final double PAGER_SCROLL_FACTOR = 0.5;
    private Catalog mCatalog;
    private String mCatalogId;
    private Branding mBranding;
    private ViewGroup mContainer;
    private FrameLayout mFrame;
    private LoadingTextView mLoader;
    private PageflipViewPager mPager;
    private CatalogPagerAdapter mAdapter;
    private ReaderConfig mConfig;
    private int mCurrentPosition = 0;
    private boolean mInternalResumed = false;
    private String mViewSessionUuid;
    private List<OnDrawPage> mDrawList = new ArrayList<OnDrawPage>();
    private Fragment mIntroFragment;
    private Fragment mOutroFragment;
    private Bundle mSavedInstanceState;
    private PageflipListenerWrapper mWrapperListener = new PageflipListenerWrapper();
    private CatalogRequest mCatalogRequest;
    private Clock mClock = ClockFactory.getClock();
    private StatDelivery mStatsDelivery;
    private CatalogPageCallback mCatalogPageCallback = new CatalogPageCallback(){

        @Override
        public void onSingleClick(View v, int page, float x, float y, List<Hotspot> hotspots) {
            PageflipFragment.this.mWrapperListener.onSingleClick(v, page, x, y, hotspots);
        }

        @Override
        public void onDoubleClick(View v, int page, float x, float y, List<Hotspot> hotspots) {
            PageflipFragment.this.mWrapperListener.onDoubleClick(v, page, x, y, hotspots);
        }

        @Override
        public void onLongClick(View v, int page, float x, float y, List<Hotspot> hotspots) {
            PageflipFragment.this.mWrapperListener.onLongClick(v, page, x, y, hotspots);
        }

        @Override
        public void onZoom(View v, int[] pages, boolean isZoomed) {
            PageflipFragment.this.mWrapperListener.onZoom(v, pages, isZoomed);
        }

        @Override
        public Catalog getCatalog() {
            return PageflipFragment.this.mCatalog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bitmap onDrawPage(int page, int[] pages, Bitmap b) {
            1 var4_4 = this;
            synchronized (var4_4) {
                PageflipFragment.this.mCatalog.getHotspots().normalize(b);
            }
            for (OnDrawPage odp : PageflipFragment.this.mDrawList) {
                Bitmap tmp = odp.onDraw(PageflipFragment.this.mCatalog, page, pages, b);
                if (tmp == b && b.isRecycled()) {
                    throw new IllegalStateException("Original bitmap returned, but has been recycled.");
                }
                if (tmp != b && !b.isRecycled()) {
                    throw new IllegalStateException("New bitmap returned, but source bitmap haven't been recycled.");
                }
                b = tmp;
            }
            return b;
        }

        @Override
        public PageflipStatsCollector getCollector(int[] pages) {
            return new PageflipStatsCollectorImpl(PageflipFragment.this.mViewSessionUuid, PageflipFragment.this.mCatalog, pages, PageflipFragment.this.mConfig, PageflipFragment.this.mClock, PageflipFragment.this.mStatsDelivery);
        }
    };
    private ViewPager.OnPageChangeListener mOnPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageSelected(int position) {
            int prev = PageflipFragment.this.mCurrentPosition;
            PageflipFragment.this.mCurrentPosition = position;
            if (PageflipFragment.this.isPagesReady()) {
                PageflipFragment.this.getPage(prev).onInvisible();
                PageflipFragment.this.getPage(PageflipFragment.this.mCurrentPosition).onVisible();
            }
            PageflipFragment.this.mWrapperListener.onPageChange(position, PageflipFragment.this.getPages());
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageScrollStateChanged(int state) {
            PageflipFragment.this.mWrapperListener.onDragStateChanged(state);
        }
    };
    private PageflipViewPager.OnPageBoundListener mPageBoundListener = new PageflipViewPager.OnPageBoundListener(){

        @Override
        public void onLeftBound() {
            PageflipFragment.this.mWrapperListener.onOutOfBounds(true);
        }

        @Override
        public void onRightBound() {
            PageflipFragment.this.mWrapperListener.onOutOfBounds(false);
        }
    };

    public static PageflipFragment newInstance(Catalog c) {
        return PageflipFragment.newInstance(c, 1);
    }

    public static PageflipFragment newInstance(Catalog c, int page) {
        return PageflipFragment.newInstance(c, page, new DoublePageReaderConfig());
    }

    public static PageflipFragment newInstance(Catalog c, int page, ReaderConfig config) {
        return PageflipFragment.newInstance(c, c.getId(), page, config, c.getBranding());
    }

    public static PageflipFragment newInstance(String catalogId) {
        return PageflipFragment.newInstance(catalogId, 1);
    }

    public static PageflipFragment newInstance(String catalogId, int page) {
        return PageflipFragment.newInstance(catalogId, page, null);
    }

    public static PageflipFragment newInstance(String catalogId, int page, Branding branding) {
        return PageflipFragment.newInstance(catalogId, page, branding, new DoublePageReaderConfig());
    }

    public static PageflipFragment newInstance(String catalogId, int page, Branding branding, ReaderConfig config) {
        return PageflipFragment.newInstance(null, catalogId, page, config, branding);
    }

    private static PageflipFragment newInstance(Catalog catalog, String catalogId, int page, ReaderConfig config, Branding branding) {
        Bundle b = new Bundle();
        if (catalog != null) {
            b.putParcelable(ARG_CATALOG, (Parcelable)catalog);
            b.putString(ARG_CATALOG_ID, catalog.getId());
        } else if (catalogId != null) {
            b.putString(ARG_CATALOG_ID, catalogId);
        } else {
            throw new IllegalStateException("Pageflip must have either a catalog or a catalog.id set");
        }
        b.putParcelable(ARG_READER_CONFIG, (Parcelable)config);
        b.putInt(ARG_PAGE, page);
        b.putParcelable(ARG_BRANDING, (Parcelable)branding);
        b.putString(ARG_VIEW_SESSION, Utils.createUUID());
        PageflipFragment f = new PageflipFragment();
        f.setArguments(b);
        return f;
    }

    private boolean isPagesReady() {
        return this.mAdapter != null && this.mAdapter.getItem(this.mCurrentPosition).isResumed();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        this.mContainer = container;
        this.mFrame = (FrameLayout)inflater.inflate(R.layout.shopgun_sdk_layout_pageflip, this.mContainer, false);
        this.mLoader = (LoadingTextView)this.mFrame.findViewById(R.id.shopgun_sdk_layout_pageflip_loader);
        this.mPager = (PageflipViewPager)this.mFrame.findViewById(R.id.shopgun_sdk_layout_pageflip_viewpager);
        this.mPager.setScrollDurationFactor(0.5);
        this.mPager.addOnPageChangeListener(this.mOnPageChangeListener);
        this.mPager.setOnPageBound(this.mPageBoundListener);
        this.mPager.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (PageflipFragment.this.isPagesReady()) {
                    PageflipFragment.this.mPager.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    ((PageflipPage)PageflipFragment.this.mAdapter.getItem(PageflipFragment.this.mCurrentPosition)).onVisible();
                }
            }
        });
        if (this.mSavedInstanceState != null) {
            this.onRestoreState(this.mSavedInstanceState);
        } else {
            this.onRestoreState(savedInstanceState);
        }
        this.mSavedInstanceState = null;
        this.mStatsDelivery = new StatDeliveryImpl(this.getShopgun());
        return this.mFrame;
    }

    private void onRestoreState(Bundle savedInstanceState) {
        Bundle args = new Bundle();
        if (this.getArguments() != null) {
            args.putAll(this.getArguments());
        }
        if (savedInstanceState != null) {
            args.putAll(savedInstanceState);
        }
        this.mConfig = (ReaderConfig)args.getParcelable(ARG_READER_CONFIG);
        if (this.mConfig == null) {
            this.mConfig = new DoublePageReaderConfig();
        }
        this.mConfig.setConfiguration(this.getActivity().getResources().getConfiguration());
        this.setPage(args.getInt(ARG_PAGE, 1));
        if (args.containsKey(ARG_CATALOG)) {
            this.setCatalog((Catalog)args.getParcelable(ARG_CATALOG));
            this.mBranding = this.mCatalog.getBranding();
        } else if (args.containsKey(ARG_CATALOG_ID)) {
            this.setCatalogId(args.getString(ARG_CATALOG_ID));
            this.mBranding = (Branding)args.getParcelable(ARG_BRANDING);
        } else {
            this.mLoader.error("No catalog provided");
        }
        this.mViewSessionUuid = args.getString(ARG_VIEW_SESSION);
        if (this.mViewSessionUuid == null) {
            this.mViewSessionUuid = Utils.createUUID();
        }
    }

    private void showContent(boolean show) {
        this.mLoader.setVisibility(show ? 4 : 0);
        this.mPager.setVisibility(show ? 0 : 4);
    }

    public PageflipListener getListener() {
        return this.mWrapperListener.getListener();
    }

    public void setPageflipListener(PageflipListener l) {
        this.mWrapperListener.setListener(l);
    }

    public void addOnDrawPage(OnDrawPage odp) {
        this.mDrawList.add(odp);
    }

    public void removeOnDrawPage(OnDrawPage odp) {
        this.mDrawList.remove(odp);
    }

    public int[] getPages() {
        return this.mConfig.positionToPages(this.mCurrentPosition, this.mCatalog.getPageCount());
    }

    public int[] getPagesCorrected() {
        int pos = this.mCurrentPosition;
        if (this.mConfig.hasIntro() && this.mCurrentPosition == 0) {
            pos = this.mCurrentPosition + 1;
        } else if (this.mConfig.hasOutro() && this.mAdapter.getCount() - 1 == this.mCurrentPosition) {
            pos = this.mCurrentPosition - 1;
        }
        return this.mConfig.positionToPages(pos, this.mCatalog.getPageCount());
    }

    public void setPage(int page) {
        if (page > 0) {
            this.setPosition(this.mConfig.pageToPosition(page));
        }
    }

    public int getPosition() {
        return this.mCurrentPosition;
    }

    public void setPosition(int position) {
        if (position >= 0) {
            this.mCurrentPosition = position;
            if (this.mPager != null) {
                this.mPager.setCurrentItem(this.mCurrentPosition);
            }
        }
    }

    public void nextPage() {
        this.mPager.setCurrentItem(this.mCurrentPosition + 1, true);
    }

    public void previousPage() {
        this.mPager.setCurrentItem(this.mCurrentPosition - 1, true);
    }

    public Branding getBranding() {
        return this.mBranding;
    }

    private void setBranding(Branding b) {
        if (b == null) {
            return;
        }
        this.mBranding = b;
        this.mLoader.setLoadingText(this.mBranding.getName());
        this.mLoader.setTextColor(b.getMaterialColor().getSecondaryText());
        this.mFrame.setBackgroundColor(this.mBranding.getColor());
        this.mContainer.setBackgroundColor(this.mBranding.getColor());
    }

    public boolean isReady() {
        return this.mAdapter != null;
    }

    public boolean isCatalogReady() {
        return PageflipUtils.isCatalogReady(this.mCatalog);
    }

    public void setCatalogId(String catalogId) {
        this.mCatalogId = catalogId;
    }

    public void onSaveInstanceState(Bundle outState) {
        try {
            int page = this.getPagesCorrected()[0];
            outState.putInt(ARG_PAGE, page);
        }
        catch (Exception e) {
            SgnLog.w(TAG, "Pageflip isn't ready, to save all state", e);
        }
        if (this.mCatalog != null) {
            outState.putParcelable(ARG_CATALOG, (Parcelable)this.mCatalog);
        }
        outState.putString(ARG_CATALOG_ID, this.mCatalogId);
        outState.putString(ARG_VIEW_SESSION, this.mViewSessionUuid);
        outState.putParcelable(ARG_BRANDING, (Parcelable)this.mBranding);
        this.mSavedInstanceState = outState;
        super.onSaveInstanceState(outState);
    }

    public void onResume() {
        super.onResume();
        this.internalResume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalResume() {
        PageflipFragment pageflipFragment = this;
        synchronized (pageflipFragment) {
            if (this.mInternalResumed) {
                return;
            }
            this.mInternalResumed = true;
        }
        this.showContent(false);
        this.setBranding(this.mBranding);
        this.mLoader.start();
        this.ensureCatalog();
    }

    private void ensureCatalog() {
        if (this.isCatalogReady()) {
            this.onRequestComplete(this.mCatalog, (List<ShopGunError>)new ArrayList<ShopGunError>(0));
        } else {
            this.mCatalogRequest = this.mCatalog != null ? new CatalogRequestCacheIgnore(this.mCatalog, (LoaderRequest.Listener<Catalog>)this) : new CatalogRequestCacheIgnore(this.mCatalogId, (LoaderRequest.Listener<Catalog>)this);
            this.mCatalogRequest.loadHotspots(true);
            this.mCatalogRequest.loadPages(true);
            this.getShopgun().add(this.mCatalogRequest);
        }
    }

    @Override
    public void onRequestComplete(Catalog response, List<ShopGunError> errors) {
        if (!errors.isEmpty()) {
            this.mLoader.error();
            this.mWrapperListener.onError(errors.get(0));
            this.showContent(false);
        } else {
            this.setCatalog(response);
            this.setBranding(this.mCatalog.getBranding());
            int heap = Utils.getMaxHeap((Context)this.getActivity());
            this.mAdapter = new CatalogPagerAdapter(this.getChildFragmentManager(), heap, this.mCatalogPageCallback, this.mConfig);
            this.mAdapter.setIntroFragment(this.mIntroFragment);
            this.mAdapter.setOutroFragment(this.mOutroFragment);
            this.mPager.setAdapter((PagerAdapter)this.mAdapter);
            this.mPager.setCurrentItem(this.mCurrentPosition);
            this.showContent(true);
            this.mWrapperListener.onReady();
            this.mWrapperListener.onPageChange(this.mCurrentPosition, this.getPages());
        }
    }

    @Override
    public void onRequestIntermediate(Catalog response, List<ShopGunError> errors) {
        this.mCatalogRequest.setIgnoreCache(false);
        if (errors.isEmpty()) {
            this.setCatalog(response);
            this.setBranding(this.mCatalog.getBranding());
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        boolean land;
        super.onConfigurationChanged(newConfig);
        boolean bl = land = newConfig.orientation == 2;
        if (land != this.mConfig.isLandscape()) {
            this.internalPause();
            Bundle b = new Bundle();
            this.onSaveInstanceState(b);
            this.onRestoreState(b);
            this.mSavedInstanceState = null;
            this.internalResume();
        }
    }

    public void onPause() {
        this.internalPause();
        super.onPause();
    }

    public void onStop() {
        if (this.mSavedInstanceState == null) {
            this.onSaveInstanceState(new Bundle());
        }
        super.onStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalPause() {
        PageflipFragment pageflipFragment = this;
        synchronized (pageflipFragment) {
            if (!this.mInternalResumed) {
                return;
            }
            this.mInternalResumed = false;
        }
        if (this.isPagesReady()) {
            this.getPage(this.mCurrentPosition).onInvisible();
        }
        this.mLoader.stop();
        if (this.mCatalogRequest != null) {
            this.mCatalogRequest.cancel();
        }
        this.clearAdapter();
    }

    private void clearAdapter() {
        if (this.mAdapter != null) {
            this.mAdapter.clearState();
        }
        this.mPager.setAdapter(null);
        this.showContent(false);
    }

    public Catalog getCatalog() {
        return this.mCatalog;
    }

    private Fragment getFragment(int position) {
        return this.mAdapter.getItem(position);
    }

    private PageflipPage getPage(int position) {
        return (PageflipPage)this.getFragment(position);
    }

    public void setCatalog(Catalog c) {
        if (c != null && c != this.mCatalog) {
            this.mCatalog = c;
            this.mCatalogId = this.mCatalog.getId();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        int page = PageOverviewDialog.parseOnActivityResult(requestCode, resultCode, data);
        if (page != -1) {
            this.setPage(page);
        }
    }

    public void showPageOverview() {
        if (this.isCatalogReady()) {
            int page = this.getPagesCorrected()[0];
            PageOverviewDialog f = PageOverviewDialog.newInstance(this, this.mCatalog, page);
            f.show(this.getChildFragmentManager(), PageOverviewDialog.TAG);
        }
    }

    public void setIntroFragment(Fragment intro) {
        if (intro != null && !(intro instanceof PageflipPage)) {
            String msg = String.format("%s must implement %s", intro.getClass().getSimpleName(), PageflipPage.class.getCanonicalName());
            throw new ClassCastException(msg);
        }
        this.mIntroFragment = intro;
        if (this.mAdapter != null) {
            this.mAdapter.setIntroFragment(this.mIntroFragment);
        }
    }

    public Fragment getIntroFragment() {
        return this.mIntroFragment;
    }

    public void setOutroFragment(Fragment outro) {
        if (outro != null && !(outro instanceof PageflipPage)) {
            String msg = String.format("%s must implement %s", outro.getClass().getSimpleName(), PageflipPage.class.getCanonicalName());
            throw new ClassCastException(msg);
        }
        this.mOutroFragment = outro;
        if (this.mAdapter != null) {
            this.mAdapter.setOutroFragment(this.mOutroFragment);
        }
    }

    public Fragment getOutroFragment() {
        return this.mOutroFragment;
    }

    class CatalogRequestCacheIgnore
    extends CatalogRequest {
        private boolean mIgnoreCache;

        public CatalogRequestCacheIgnore(String catalogId, LoaderRequest.Listener<Catalog> listener) {
            super(catalogId, listener);
            this.mIgnoreCache = true;
        }

        public CatalogRequestCacheIgnore(Catalog catalog, LoaderRequest.Listener<Catalog> listener) {
            super(catalog, listener);
            this.mIgnoreCache = true;
        }

        @Override
        protected Response<JSONObject> parseNetworkResponse(NetworkResponse response) {
            this.mIgnoreCache = false;
            return super.parseNetworkResponse(response);
        }

        @Override
        public boolean ignoreCache() {
            return this.mIgnoreCache;
        }
    }

    protected class PageflipListenerWrapper
    implements PageflipListener {
        protected PageflipListener mListener;

        protected PageflipListenerWrapper() {
        }

        private boolean post() {
            return this.mListener != null;
        }

        public PageflipListener getListener() {
            return this.mListener;
        }

        public void setListener(PageflipListener l) {
            this.mListener = l;
        }

        @Override
        public void onReady() {
            if (this.post()) {
                this.mListener.onReady();
            }
        }

        @Override
        public void onPageChange(int position, int[] pages) {
            if (this.post()) {
                this.mListener.onPageChange(position, pages);
            }
        }

        @Override
        public void onOutOfBounds(boolean left) {
            if (this.post()) {
                this.mListener.onOutOfBounds(left);
            }
        }

        @Override
        public void onError(ShopGunError error) {
            ShopGunError shopGunError = error = error == null ? new ShopGunError(0, "Unknown Error", "No details available") : error;
            if (this.post()) {
                this.mListener.onError(error);
            }
        }

        @Override
        public void onDragStateChanged(int state) {
            if (this.post()) {
                this.mListener.onDragStateChanged(state);
            }
        }

        @Override
        public void onSingleClick(View v, int page, float x, float y, List<Hotspot> hotspots) {
            if (this.post()) {
                this.mListener.onSingleClick(v, page, x, y, hotspots);
            }
        }

        @Override
        public void onDoubleClick(View v, int page, float x, float y, List<Hotspot> hotspots) {
            if (this.post()) {
                this.mListener.onDoubleClick(v, page, x, y, hotspots);
            }
        }

        @Override
        public void onLongClick(View v, int page, float x, float y, List<Hotspot> hotspots) {
            if (this.post()) {
                this.mListener.onLongClick(v, page, x, y, hotspots);
            }
        }

        @Override
        public void onZoom(View v, int[] pages, boolean zoonIn) {
            if (this.post()) {
                this.mListener.onZoom(v, pages, zoonIn);
            }
        }
    }
}

