/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.SectionIndexer;
import android.widget.TextView;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.utils.CatalogThumbTransformation;
import com.shopgun.android.sdk.utils.ColorUtils;
import com.shopgun.android.sdk.utils.Utils;
import com.shopgun.android.utils.DisplayUtils;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Transformation;

public class PageOverviewDialog
extends DialogFragment {
    public static final String TAG = Constants.getTag(PageOverviewDialog.class);
    public static final int REQUEST_CODE = 6543654;
    public static final String EXTRA_PAGE = Constants.getArg("pageOverviewDialog.page");
    private static final String ARG_CATALOG = Constants.getArg("pageOverviewDialog.catalog");
    private static final String ARG_PAGE = Constants.getArg("pageOverviewDialog.page");
    private static final int MAX_WIDTH = 177;
    private static final int MAX_COLUMNS = 3;
    private Catalog mCatalog;
    private int mPage = 1;
    private GridView mGrid;

    public static PageOverviewDialog newInstance(Fragment target, Catalog c, int page) {
        Bundle b = new Bundle();
        b.putParcelable(ARG_CATALOG, (Parcelable)c);
        b.putInt(ARG_PAGE, page);
        PageOverviewDialog f = new PageOverviewDialog();
        if (target != null) {
            f.setTargetFragment(target, 6543654);
        }
        f.setArguments(b);
        return f;
    }

    public static PageOverviewDialog newInstance(Catalog c, int page) {
        return PageOverviewDialog.newInstance(null, c, page);
    }

    public static int parseOnActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 6543654 && -1 == resultCode) {
            return data.getExtras().getInt(EXTRA_PAGE);
        }
        return -1;
    }

    public void onCreate(Bundle savedInstanceState) {
        if (this.getArguments() != null) {
            Catalog c = (Catalog)this.getArguments().getParcelable(ARG_CATALOG);
            this.setCatalog(c);
            this.setPage(this.getArguments().getInt(ARG_PAGE));
        }
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        if (this.getDialog() != null) {
            this.getDialog().getWindow().requestFeature(1);
        }
        int spacePx = Utils.convertDpToPx(6, (Context)this.getActivity());
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.mGrid = new GridView((Context)this.getActivity());
        this.mGrid.setLayoutParams(lp);
        this.mGrid.setPadding(spacePx, spacePx, spacePx, spacePx);
        this.mGrid.setAdapter((ListAdapter)new GalleryAdapter());
        this.mGrid.setFastScrollEnabled(true);
        if (Build.VERSION.SDK_INT >= 11) {
            this.mGrid.setFastScrollAlwaysVisible(true);
        }
        this.mGrid.setHorizontalSpacing(spacePx);
        this.mGrid.setVerticalSpacing(spacePx);
        this.mGrid.setGravity(1);
        this.mGrid.setStretchMode(2);
        this.mGrid.setBackgroundColor(this.mCatalog.getBranding().getColor());
        int columns = (int)Math.floor(DisplayUtils.getScreenWidth((Context)this.getContext()) / 177);
        this.mGrid.setNumColumns(Math.min(columns, 3));
        this.mGrid.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                PageOverviewDialog.this.dismiss();
                if (PageOverviewDialog.this.getTargetFragment() != null) {
                    Intent i = new Intent();
                    i.putExtra(EXTRA_PAGE, position + 1);
                    PageOverviewDialog.this.getTargetFragment().onActivityResult(PageOverviewDialog.this.getTargetRequestCode(), -1, i);
                }
            }
        });
        if (this.mPage != 1) {
            this.mGrid.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (PageOverviewDialog.this.isAdded()) {
                        PageOverviewDialog.this.mGrid.setSelection(PageOverviewDialog.this.mPage - 1);
                    }
                }
            }, 300L);
        }
        return this.mGrid;
    }

    public void setCatalog(Catalog c) {
        this.mCatalog = c;
    }

    public void setPage(int page) {
        this.mPage = page;
    }

    public void dismiss() {
        this.mGrid.setAdapter(null);
        super.dismiss();
    }

    public void onResume() {
        super.onResume();
        if (this.mCatalog.getPages() == null || this.mCatalog.getPages().isEmpty()) {
            this.dismiss();
        }
    }

    public class GalleryAdapter
    extends BaseAdapter
    implements SectionIndexer {
        String[] mSections;
        Context mContext;

        public GalleryAdapter() {
            this.mContext = PageOverviewDialog.this.getActivity();
            this.mSections = new String[this.getCount()];
            for (int i = 0; i < this.getCount(); ++i) {
                this.mSections[i] = String.valueOf(i + 1);
            }
        }

        public int getCount() {
            return PageOverviewDialog.this.mCatalog.getPages() == null ? 0 : PageOverviewDialog.this.mCatalog.getPages().size();
        }

        public Object getItem(int position) {
            return PageOverviewDialog.this.mCatalog.getPages().get(position).getThumb();
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            int wrap = -2;
            int fill = -1;
            AbsListView.LayoutParams lp = new AbsListView.LayoutParams(fill, fill);
            FrameLayout fl = new FrameLayout(this.mContext);
            fl.setLayoutParams((ViewGroup.LayoutParams)lp);
            int ivSize = Utils.convertDpToPx(115, this.mContext);
            FrameLayout.LayoutParams ivlp = new FrameLayout.LayoutParams(ivSize, ivSize, 1);
            ImageView iv = new ImageView(this.mContext);
            iv.setLayoutParams((ViewGroup.LayoutParams)ivlp);
            fl.addView((View)iv);
            int g = 81;
            FrameLayout.LayoutParams tvlp = new FrameLayout.LayoutParams(wrap, wrap, g);
            TextView tv = new TextView(this.mContext);
            tv.setText((CharSequence)String.valueOf(position + 1));
            tv.setTextColor(-1);
            tv.setTextSize(20.0f);
            tv.setTypeface(null, 1);
            tv.setLayoutParams((ViewGroup.LayoutParams)tvlp);
            int vpad = Utils.convertDpToPx(0, this.mContext);
            int hpad = Utils.convertDpToPx(5, this.mContext);
            tv.setPadding(hpad, vpad, hpad, vpad);
            tv.setBackgroundDrawable((Drawable)this.getDrawable());
            fl.addView((View)tv);
            String url = PageOverviewDialog.this.mCatalog.getPages().get(position).getThumb();
            Picasso.with((Context)this.mContext).load(url).transform((Transformation)new CatalogThumbTransformation(PageOverviewDialog.this.mCatalog)).into(iv);
            return fl;
        }

        private GradientDrawable getDrawable() {
            int color = PageOverviewDialog.this.mCatalog.getBranding().getColor();
            color = ColorUtils.setAlphaComponent(color, 160);
            float radius = Utils.convertDpToPx(3, (Context)PageOverviewDialog.this.getActivity());
            GradientDrawable gd = new GradientDrawable();
            gd.setColor(color);
            gd.setCornerRadius(radius);
            gd.setStroke(1, -2144325584);
            return gd;
        }

        public Object[] getSections() {
            return this.mSections;
        }

        public int getPositionForSection(int sectionIndex) {
            return sectionIndex;
        }

        public int getSectionForPosition(int position) {
            return position;
        }
    }
}

