/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Parcel;
import android.os.Parcelable;

public enum Orientation implements Parcelable
{
    LANDSCAPE{

        public String toString() {
            return "landscape";
        }
    }
    ,
    PORTRAIT{

        public String toString() {
            return "portrait";
        }
    };

    private static Orientation[] allValues;
    public static final Parcelable.Creator<Orientation> CREATOR;

    public static Orientation fromOrdinal(int n) {
        return allValues[n > allValues.length ? 0 : n];
    }

    public static Orientation fromContext(Context c) {
        return Orientation.fromConfiguration(c.getResources().getConfiguration());
    }

    public static Orientation fromConfiguration(Configuration c) {
        if (c == null) {
            return PORTRAIT;
        }
        switch (c.orientation) {
            case 2: {
                return LANDSCAPE;
            }
            case 1: {
                return PORTRAIT;
            }
        }
        return PORTRAIT;
    }

    public boolean isLandscape() {
        return this == LANDSCAPE;
    }

    public boolean isPortrait() {
        return this == PORTRAIT;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.ordinal());
    }

    static {
        allValues = Orientation.values();
        CREATOR = new Parcelable.Creator<Orientation>(){

            public Orientation createFromParcel(Parcel source) {
                return Orientation.fromOrdinal(source.readInt());
            }

            public Orientation[] newArray(int size) {
                return new Orientation[size];
            }
        };
    }
}

