/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.pageflip;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.R;
import com.shopgun.android.sdk.SgnFragment;
import com.shopgun.android.sdk.log.AppLogEntry;
import com.shopgun.android.sdk.log.Event;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.pageflip.CatalogPageCallback;
import com.shopgun.android.sdk.pageflip.PageLoader;
import com.shopgun.android.sdk.pageflip.PageflipPage;
import com.shopgun.android.sdk.pageflip.stats.PageEvent;
import com.shopgun.android.sdk.pageflip.stats.PageflipStatsCollector;
import com.shopgun.android.sdk.pageflip.utils.PageflipClickCoordinate;
import com.shopgun.android.sdk.pageflip.utils.PageflipUtils;
import com.shopgun.android.sdk.pageflip.widget.LoadingTextView;
import com.shopgun.android.sdk.pageflip.widget.ZoomPhotoView;
import com.shopgun.android.sdk.photoview.PhotoView;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

public class CatalogPageFragment
extends SgnFragment
implements PhotoView.OnPhotoTapListener,
PhotoView.OnPhotoDoubleClickListener,
PhotoView.OnPhotoLongClickListener,
ZoomPhotoView.OnZoomChangeListener,
PageLoader.PageLoaderListener,
PageflipPage {
    public static final String TAG = Constants.getTag(CatalogPageFragment.class);
    private static boolean LOG = false;
    protected static final float MAX_SCALE = 3.0f;
    protected static final String ARG_PAGE = Constants.getArg(CatalogPageFragment.class, "page");
    protected static final String ARG_POSITION = Constants.getArg(CatalogPageFragment.class, "position");
    protected static final String ARG_CONFIG = Constants.getArg(CatalogPageFragment.class, "config");
    private int[] mPages;
    private int mPosition = -1;
    private PageLoader.Config mConfig;
    private boolean mPageVisible = false;
    private ZoomPhotoView mPhotoView;
    private LoadingTextView mLoader;
    private PageflipStatsCollector mStats;
    private PageLoader mPageLoader;
    private CatalogPageCallback mCallback;

    public static CatalogPageFragment newInstance(int position, int[] pages, PageLoader.Config config) {
        Bundle b = new Bundle();
        b.putIntArray(ARG_PAGE, pages);
        b.putInt(ARG_POSITION, position);
        b.putParcelable(ARG_CONFIG, (Parcelable)config);
        CatalogPageFragment f = new CatalogPageFragment();
        f.setArguments(b);
        return f;
    }

    public void onCreate(Bundle savedInstanceState) {
        if (this.getArguments() != null) {
            this.mPages = this.getArguments().getIntArray(ARG_PAGE);
            this.mPosition = this.getArguments().getInt(ARG_POSITION, 0);
            this.mConfig = (PageLoader.Config)this.getArguments().getParcelable(ARG_CONFIG);
        }
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.shopgun_sdk_layout_page, container, false);
        this.mPhotoView = (ZoomPhotoView)view.findViewById(R.id.shopgun_sdk_layout_page_photoview);
        this.mLoader = (LoadingTextView)view.findViewById(R.id.shopgun_sdk_layout_page_pagenum);
        this.mPhotoView.setMaximumScale(3.0f);
        this.toggleContentVisibility(true);
        return view;
    }

    private void toggleContentVisibility(boolean isLoading) {
        if (!this.isAdded()) {
            return;
        }
        this.mPhotoView.setVisibility(isLoading ? 4 : 0);
        this.mLoader.setVisibility(isLoading ? 0 : 4);
        if (isLoading) {
            this.updateBranding();
            this.mLoader.setLoadingText(PageflipUtils.join("-", this.mPages));
            this.mLoader.start();
        }
    }

    private void updateBranding() {
        if (this.isAdded() && this.mCallback.getCatalog() != null) {
            int brandingColor = this.mCallback.getCatalog().getBranding().getMaterialColor().getSecondaryText();
            this.mLoader.setTextColor(brandingColor);
        }
    }

    public void setCatalogPageCallback(CatalogPageCallback callback) {
        this.mCallback = callback;
    }

    public int[] getPages() {
        return this.mPages;
    }

    private boolean ensureLoader() {
        if (this.isAdded()) {
            if (this.mPageLoader == null) {
                if (this.mConfig == null) {
                    this.mConfig = new PageLoader.Config((Context)this.getActivity(), this.mPages, this.mCallback.getCatalog());
                }
                this.mPageLoader = new PageLoader((Context)this.getActivity(), this.mConfig);
                this.mPageLoader.setPageLoaderListener(this);
                this.log(this.mConfig.toString());
            }
            return true;
        }
        return false;
    }

    private void loadView() {
        if (this.mPhotoView == null) {
            return;
        }
        if (this.mPhotoView.isBitmapValid()) {
            return;
        }
        if (this.ensureLoader()) {
            this.mPageLoader.into(this.mPhotoView, PageLoader.Quality.MEDIUM);
        }
    }

    private void loadZoom() {
        if (this.ensureLoader()) {
            this.mPageLoader.into(this.mPhotoView, PageLoader.Quality.HIGH);
        }
    }

    public void onResume() {
        this.log("onResume");
        this.updateBranding();
        this.mPhotoView.setOnPhotoDoubleClickListener(this);
        this.mPhotoView.setOnPhotoLongClickListener(this);
        this.mPhotoView.setOnPhotoTapListener(this);
        this.loadView();
        super.onResume();
    }

    @Override
    public float getPageWidth() {
        return 1.0f;
    }

    @Override
    public void onVisible() {
        this.log("onVisible");
        if (this.mStats == null) {
            this.mStats = this.mCallback.getCollector(this.mPages);
        }
        this.updateBranding();
        this.loadView();
        if (!this.mPageVisible && this.mPhotoView != null && this.mPhotoView.getBitmap() != null) {
            this.mPhotoView.setOnZoomListener(this);
            this.mStats.startView();
        }
        this.mPageVisible = true;
    }

    @Override
    public void onInvisible() {
        this.log("onInvisible");
        if (this.mPageVisible) {
            this.mStats.collect();
            this.verifyIntegrity();
        }
        this.mPhotoView.setOnZoomListener(null);
        this.mPageVisible = false;
        this.mStats = null;
    }

    private void verifyIntegrity() {
        AppLogEntry appLogEntry = new AppLogEntry(this.getShopgun(), "negative-duration", "android@shopgun.com");
        if (this.mStats.getRootEvent() != null && this.mStats.getRootEvent().getDuration() <= 0L) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("PageflipStatsCollector", this.mStats.toString());
            Event event = new Event(this.getShopgun(), "page-stats-collector-event");
            event.setData(new JSONObject(map));
            appLogEntry.addEvent(event);
            List<PageEvent> events = this.mStats.getEvents();
            for (PageEvent subEvent : events) {
                Event e = new Event(this.getShopgun(), "view-event");
                e.setData(subEvent.toDebugJSON());
                appLogEntry.addEvent(e);
            }
            appLogEntry.post();
        }
    }

    public void onPause() {
        this.log("onPause");
        this.mLoader.stop();
        this.mPhotoView.recycle();
        if (this.mPageLoader != null) {
            this.mPageLoader.cancel();
        }
        super.onPause();
    }

    @Override
    public void onPhotoTap(View view, float x, float y) {
        PageflipClickCoordinate c = new PageflipClickCoordinate(this.mCallback.getCatalog(), this.mPages, x, y);
        this.mCallback.onSingleClick((View)this.mPhotoView, c.getPage(), c.getX(), c.getY(), c.getHotspots());
    }

    @Override
    public void onPhotoDoubleTap(View view, float x, float y) {
        PageflipClickCoordinate c = new PageflipClickCoordinate(this.mCallback.getCatalog(), this.mPages, x, y);
        this.mCallback.onDoubleClick((View)this.mPhotoView, c.getPage(), c.getX(), c.getY(), c.getHotspots());
    }

    @Override
    public void onPhotoLongTap(View view, float x, float y) {
        PageflipClickCoordinate c = new PageflipClickCoordinate(this.mCallback.getCatalog(), this.mPages, x, y);
        this.mCallback.onLongClick((View)this.mPhotoView, c.getPage(), c.getX(), c.getY(), c.getHotspots());
    }

    @Override
    public void onZoomChange(boolean isZoomed) {
        this.loadZoom();
        if (isZoomed) {
            this.mStats.startZoom();
        } else {
            this.mStats.stopZoom();
        }
        this.mCallback.onZoom((View)this.mPhotoView, this.mPages, isZoomed);
    }

    @Override
    public void onComplete() {
        this.log("onComplete");
        this.toggleContentVisibility(false);
        if (this.mPageVisible) {
            this.mStats.startView();
        }
    }

    @Override
    public void onError() {
        this.mLoader.stop();
        String page = PageflipUtils.join("-", this.mPages);
        this.mLoader.error(this.getString(R.string.com_shopgun_android_sdk_pageflip_page_error, new Object[]{page}));
    }

    @Override
    public Bitmap onTransform(Bitmap b, int page) {
        return this.mCallback.onDrawPage(page, this.mPages, b);
    }

    private void log(String msg) {
        if (LOG) {
            String format = "pos[%s], pages[%s] %s";
            String text = String.format(format, this.mPosition, PageflipUtils.join(",", this.mPages), msg);
            SgnLog.d(TAG, text);
        }
    }
}

