/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.HttpStack;
import com.shopgun.android.sdk.network.Network;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.NetworkError;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.ByteArrayBuffer;

public class NetworkImpl
implements Network {
    public static final String TAG = Constants.getTag(NetworkImpl.class);
    private static final int BUFFER_SIZE = 4096;
    HttpStack mStack;

    public NetworkImpl(HttpStack stack) {
        this.mStack = stack;
    }

    private static byte[] entityToBytes(HttpEntity entity) throws IllegalStateException, IOException {
        int init_buf = 0L <= entity.getContentLength() ? (int)entity.getContentLength() : 4096;
        ByteArrayBuffer bytes = new ByteArrayBuffer(init_buf);
        InputStream is = entity.getContent();
        if (is == null) {
            return bytes.toByteArray();
        }
        byte[] buf = new byte[init_buf];
        int c = -1;
        while ((c = is.read(buf)) != -1) {
            bytes.append(buf, 0, c);
        }
        return bytes.toByteArray();
    }

    @Override
    public NetworkResponse performRequest(Request<?> request) throws ShopGunError {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        try {
            byte[] content;
            HttpResponse resp = this.mStack.performNetworking(request);
            if (resp.getEntity() == null) {
                content = new byte[]{};
            } else {
                request.addEvent("reading-input");
                content = NetworkImpl.entityToBytes(resp.getEntity());
            }
            int respLength = content.length;
            int bodyLength = request.getBody() == null ? 0 : request.getBody().length;
            request.stats(respLength, bodyLength);
            for (Header h : resp.getAllHeaders()) {
                responseHeaders.put(h.getName(), h.getValue());
            }
            return new NetworkResponse(resp.getStatusLine().getStatusCode(), content, responseHeaders);
        }
        catch (Exception e) {
            SgnLog.e(TAG, e.getMessage(), e);
            throw new NetworkError(e);
        }
    }
}

