/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MemoryCache
implements Cache {
    public static final String TAG = Constants.getTag(MemoryCache.class);
    private static final int AVG_ITEM_SIZE = 4096;
    private int mMaxItems = 256;
    private int mPercentToClean = 20;
    private Map<String, Cache.Item> mCache;

    public MemoryCache() {
        this.setLimit(Runtime.getRuntime().maxMemory() / 8L);
        float loadFactor = 1.5f;
        boolean accessOrder = true;
        this.mCache = Collections.synchronizedMap(new LinkedHashMap(this.mMaxItems, loadFactor, accessOrder));
    }

    public void setCleanLimit(int percentToClean) {
        if (percentToClean <= 0 || 100 <= percentToClean) {
            throw new IllegalArgumentException("Percent a number between 0-100");
        }
        this.mPercentToClean = percentToClean;
    }

    public void setLimit(long maxMemLimit) {
        if (maxMemLimit > Runtime.getRuntime().maxMemory()) {
            throw new IllegalArgumentException("maxMemLimit cannot be more than max heap size");
        }
        this.mMaxItems = (int)(maxMemLimit / 4096L);
        SgnLog.v(TAG, "New memory limit: " + maxMemLimit / 1024L + "kb (approx " + this.mMaxItems + " items)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void put(Request<?> request, Response<?> response) {
        if (request.getMethod() != Request.Method.GET || !request.isCacheable() || request.isCacheHit() || response.cache == null) return;
        request.addEvent("add-response-to-cache");
        Class<MemoryCache> clazz = MemoryCache.class;
        synchronized (MemoryCache.class) {
            this.mCache.putAll(response.cache);
            this.checkSize();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void checkSize() {
        int size = this.mCache.size();
        if (size > this.mMaxItems) {
            float percentToRemove = (float)this.mPercentToClean / 100.0f;
            int itemsToRemove = (int)((float)size * percentToRemove);
            Iterator<Map.Entry<String, Cache.Item>> it = this.mCache.entrySet().iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
                if (itemsToRemove-- != 0) continue;
            }
            SgnLog.d(TAG, "Cleaned " + TAG + " new size: " + this.mCache.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache.Item get(String key) {
        Class<MemoryCache> clazz = MemoryCache.class;
        synchronized (MemoryCache.class) {
            Cache.Item c = this.mCache.get(key);
            if (c == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            if (c.isExpired()) {
                this.mCache.remove(key);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Class<MemoryCache> clazz = MemoryCache.class;
        synchronized (MemoryCache.class) {
            this.mCache.clear();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

