/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.NetworkResponse;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;
import com.shopgun.android.sdk.network.ShopGunError;
import com.shopgun.android.sdk.network.impl.JsonCacheHelper;
import com.shopgun.android.sdk.network.impl.JsonRequest;
import com.shopgun.android.sdk.network.impl.ParseError;
import com.shopgun.android.sdk.utils.Utils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonStringRequest
extends JsonRequest<String> {
    public static final String TAG = Constants.getTag(JsonStringRequest.class);
    private static Map<String, String> mFilterTypes = new HashMap<String, String>();

    public JsonStringRequest(String url, Response.Listener<String> listener) {
        super(url, listener);
    }

    public JsonStringRequest(Request.Method method, String url, String requestBody, Response.Listener<String> listener) {
        super(method, url, requestBody, listener);
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        String jsonString = null;
        try {
            jsonString = new String(response.data, this.getParamsEncoding()).trim();
        }
        catch (UnsupportedEncodingException e) {
            jsonString = new String(response.data).trim();
        }
        if (Utils.isSuccess(response.statusCode)) {
            if (jsonString.startsWith("{") && jsonString.endsWith("}")) {
                try {
                    JSONObject jObject = new JSONObject(jsonString);
                    JsonCacheHelper.cacheJSONObject(this, jObject);
                }
                catch (JSONException e) {
                    return Response.fromError(new ParseError((Exception)((Object)e), JSONObject.class));
                }
            }
            if (jsonString.startsWith("[") && jsonString.endsWith("]")) {
                try {
                    JSONArray jArray = new JSONArray(jsonString);
                    JsonCacheHelper.cacheJSONArray(this, jArray);
                }
                catch (JSONException e) {
                    return Response.fromError(new ParseError((Exception)((Object)e), JSONArray.class));
                }
            }
            return Response.fromSuccess(jsonString, this.getCache());
        }
        try {
            JSONObject jObject = new JSONObject(jsonString);
            ShopGunError e = ShopGunError.fromJSON(jObject);
            return Response.fromError(e);
        }
        catch (Exception e) {
            return Response.fromError(new ParseError(e, JSONObject.class));
        }
    }

    @Override
    protected Response<String> parseCache(Cache c) {
        Response<JSONObject> cacheObject;
        String[] path = this.getUrl().split("/");
        String cacheString = null;
        if (mFilterTypes.containsKey(path[path.length - 1])) {
            Response<JSONArray> cacheArray = JsonCacheHelper.getJSONArray(this, c);
            if (cacheArray != null) {
                cacheString = ((JSONArray)cacheArray.result).toString();
            }
        } else if (mFilterTypes.containsKey(path[path.length - 2]) && (cacheObject = JsonCacheHelper.getJSONObject(this, c)) != null) {
            cacheString = ((JSONObject)cacheObject.result).toString();
        }
        if (cacheString != null) {
            Response<String> cache = Response.fromSuccess(cacheString, null);
            return cache;
        }
        return null;
    }

    static {
        mFilterTypes.put("catalogs", "catalog_ids");
        mFilterTypes.put("offers", "offer_ids");
        mFilterTypes.put("dealers", "dealer_ids");
        mFilterTypes.put("stores", "store_ids");
    }
}

