/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.network.HttpStack;
import com.shopgun.android.sdk.network.RedirectProtocol;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.utils.Utils;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;

public class HttpURLNetwork
implements HttpStack {
    public static final String TAG = Constants.getTag(HttpURLNetwork.class);
    Pattern mHostPatternPrefix = Pattern.compile("^(shopgun\\.com|etilbudsavis\\.dk|api\\.etilbudsavis\\.dk|api-edge\\.etilbudsavis\\.dk|api-staging\\.etilbudsavis\\.dk).*$");
    Pattern mHostPatternPostfix = Pattern.compile(".*?(shopgun\\.com|etilbudsavis\\.dk)");
    final RedirectProtocol mRedirectProtocol;

    public HttpURLNetwork(RedirectProtocol redirectProtocol) {
        this.mRedirectProtocol = redirectProtocol;
    }

    @Override
    public HttpResponse performNetworking(Request<?> request) throws IOException {
        String tmpUrl = Utils.requestToUrlAndQueryString(request);
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(new URL(tmpUrl));
        return this.performNetworking(request, urls);
    }

    private HttpResponse performNetworking(Request<?> request, ArrayList<URL> urls) throws IOException {
        URL redirectUrl;
        URL url = urls.get(urls.size() - 1);
        HttpURLConnection connection = this.openConnection(request, url);
        HttpResponse response = this.getHttpResponse(connection);
        if (response.getStatusLine().getStatusCode() == -1) {
            throw new IOException("Connection returned invalid response code.");
        }
        if (this.mRedirectProtocol.isRedirectRequested(request, response, urls) && (redirectUrl = this.mRedirectProtocol.getRedirectLocation(request, response, urls)) != null) {
            urls.add(redirectUrl);
            return this.performNetworking(request, urls);
        }
        HttpEntity entity = HttpURLNetwork.getEntity(connection);
        response.setEntity(entity);
        if (urls.size() > 1) {
            this.mRedirectProtocol.onRedirectComplete(request, urls);
        }
        return response;
    }

    private HttpURLConnection openConnection(Request<?> request, URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(request.getTimeOut());
        connection.setReadTimeout(request.getTimeOut());
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        this.setHeaders(request, connection);
        this.setRequestMethod(connection, request);
        return connection;
    }

    private void setHeaders(Request<?> request, HttpURLConnection connection) {
        HashMap<String, String> headers = new HashMap<String, String>(request.getHeaders().size());
        headers.putAll(request.getHeaders());
        for (String key : headers.keySet()) {
            connection.setRequestProperty(key, (String)headers.get(key));
        }
    }

    private void setRequestMethod(HttpURLConnection connection, Request<?> request) throws IOException {
        String method = request.getMethod().toString();
        connection.setRequestMethod(method);
        switch (request.getMethod()) {
            case POST: 
            case PUT: {
                HttpURLNetwork.addBodyIfExists(connection, request);
                break;
            }
        }
    }

    private HttpResponse getHttpResponse(HttpURLConnection connection) throws IOException {
        ProtocolVersion pv = new ProtocolVersion("HTTP", 1, 1);
        String rm = connection.getResponseMessage();
        BasicHttpResponse response = new BasicHttpResponse(pv, connection.getResponseCode(), rm);
        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
            if (header.getKey() == null) continue;
            BasicHeader h = new BasicHeader(header.getKey(), header.getValue().get(0));
            response.addHeader((Header)h);
        }
        return response;
    }

    private static HttpEntity getEntity(HttpURLConnection connection) {
        InputStream inputStream;
        BasicHttpEntity entity = new BasicHttpEntity();
        try {
            inputStream = connection.getInputStream();
        }
        catch (IOException ioe) {
            inputStream = connection.getErrorStream();
        }
        entity.setContent(inputStream);
        entity.setContentLength((long)connection.getContentLength());
        entity.setContentEncoding(connection.getContentEncoding());
        entity.setContentType(connection.getContentType());
        return entity;
    }

    private static void addBodyIfExists(HttpURLConnection connection, Request<?> request) throws IOException {
        byte[] body = request.getBody();
        if (body != null) {
            connection.setDoOutput(true);
            connection.addRequestProperty("Content-Type", request.getBodyContentType());
            DataOutputStream out = new DataOutputStream(connection.getOutputStream());
            out.write(body);
            out.close();
        }
    }
}

