/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network.impl;

import android.os.Handler;
import android.os.Looper;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.Response;

public class HandlerDelivery
implements Delivery {
    private final Handler mHandler;

    public HandlerDelivery() {
        this(new Handler(Looper.getMainLooper()));
    }

    public HandlerDelivery(Handler handler) {
        this.mHandler = handler;
    }

    @Override
    public void postResponse(Request<?> request, Response<?> response) {
        if (request.isCanceled()) {
            request.finish("cancelled-at-delivery");
        } else if (request.getDelivery() != null && !this.equals(request.getDelivery())) {
            request.addEvent("post-to-custom-delivery");
            request.getDelivery().postResponse(request, response);
        } else {
            request.addEvent("post-response");
            this.mHandler.post((Runnable)new Delivery.DeliveryRunnable(request, response));
        }
    }
}

