/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.network;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.ShopGun;
import com.shopgun.android.sdk.log.EventLog;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.network.Cache;
import com.shopgun.android.sdk.network.CacheDispatcher;
import com.shopgun.android.sdk.network.Delivery;
import com.shopgun.android.sdk.network.Network;
import com.shopgun.android.sdk.network.NetworkDispatcher;
import com.shopgun.android.sdk.network.NetworkUtils;
import com.shopgun.android.sdk.network.Request;
import com.shopgun.android.sdk.network.impl.HandlerDelivery;
import com.shopgun.android.sdk.utils.Utils;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestQueue {
    public static final String TAG = Constants.getTag(RequestQueue.class);
    private static final int DEFAULT_NETWORK_THREAD_POOL_SIZE = 4;
    private final ShopGun mShopGun;
    private final Set<Request<?>> mCurrentRequests = new HashSet();
    private final PriorityBlockingQueue<Request<?>> mCacheQueue = new PriorityBlockingQueue();
    private final PriorityBlockingQueue<Request<?>> mNetworkQueue = new PriorityBlockingQueue();
    private final LinkedList<Request<?>> mSessionParking = new LinkedList();
    private final Network mNetwork;
    private final Cache mCache;
    private final Delivery mDelivery;
    private final AtomicInteger mSequenceGenerator = new AtomicInteger();
    public int dataIn = 0;
    public int dataOut = 0;
    private NetworkDispatcher[] mNetworkDispatchers;
    private CacheDispatcher mCacheDispatcher;

    public RequestQueue(ShopGun shopGun, Cache cache, Network network, int poolSize, Delivery delivery) {
        this.mShopGun = shopGun;
        this.mCache = cache;
        this.mNetwork = network;
        this.mNetworkDispatchers = new NetworkDispatcher[poolSize];
        this.mDelivery = delivery;
    }

    public RequestQueue(ShopGun shopGun, Cache cache, Network network) {
        this(shopGun, cache, network, 4, new HandlerDelivery());
    }

    public void start() {
        this.mCacheDispatcher = new CacheDispatcher(this.mCacheQueue, this.mNetworkQueue, this.mCache, this.mDelivery);
        this.mCacheDispatcher.start();
        for (int i = 0; i < this.mNetworkDispatchers.length; ++i) {
            NetworkDispatcher networkDispatcher;
            this.mNetworkDispatchers[i] = networkDispatcher = new NetworkDispatcher(this.mShopGun, this, this.mNetworkQueue, this.mNetwork, this.mCache, this.mDelivery);
            networkDispatcher.start();
        }
    }

    public void stop() {
        if (this.mCacheDispatcher != null) {
            this.mCacheDispatcher.quit();
        }
        for (NetworkDispatcher n : this.mNetworkDispatchers) {
            if (n == null) continue;
            n.quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runParkedQueue() {
        if (this.mShopGun.getSessionManager().isRequestInFlight()) {
            SgnLog.i(TAG, "Cannot resume yet, session request still in flight.");
            return;
        }
        LinkedList<Request<?>> linkedList = this.mSessionParking;
        synchronized (linkedList) {
            for (Request request : this.mSessionParking) {
                request.addEvent("resuming-request");
                this.mCacheQueue.add(request);
            }
            this.mSessionParking.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finish(Request<?> request) {
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            this.mCurrentRequests.remove(request);
        }
    }

    public EventLog getLog() {
        return SgnLog.getLogger().getLog();
    }

    public Network getNetwork() {
        return this.mNetwork;
    }

    public Cache getCache() {
        return this.mCache;
    }

    public void clear() {
        this.mCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request<?> add(Request<?> request) {
        Collection<Request<?>> collection = this.mCurrentRequests;
        synchronized (collection) {
            this.mCurrentRequests.add(request);
        }
        this.prepareRequest(request);
        request.setRequestQueue(this);
        request.setSequence(this.mSequenceGenerator.incrementAndGet());
        this.appendRequestNetworkLog(request);
        if (this.mShopGun.getSessionManager().isRequestInFlight() && !this.isSessionEndpoint(request)) {
            request.addEvent("added-to-parking-queue");
            collection = this.mSessionParking;
            synchronized (collection) {
                this.mSessionParking.add(request);
            }
        } else {
            request.addEvent("added-to-queue");
            if (this.isSessionEndpoint(request) && request != this.mShopGun.getSessionManager().getRequestInFlight()) {
                SgnLog.w(TAG, "Session changes should be handled by SessionManager. This request might cause problems");
            }
            this.mCacheQueue.add(request);
        }
        return request;
    }

    private void appendRequestNetworkLog(Request<?> r) {
        JSONObject log = r.getNetworkLog();
        try {
            log.put("method", (Object)r.getMethod().toString());
            log.put("url", (Object)Utils.requestToUrlAndQueryString(r));
            log.put("Content-Type", (Object)r.getBodyContentType());
            log.put("headers", (Object)new JSONObject(r.getHeaders()));
            log.put("time", (Object)Utils.dateToString(new Date()));
        }
        catch (JSONException e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancelAll(Object tag) {
        int count = 0;
        if (tag == null) {
            return count;
        }
        Set<Request<?>> set = this.mCurrentRequests;
        synchronized (set) {
            for (Request<?> r : this.mCurrentRequests) {
                if (r.getTag() != tag || r.isCanceled()) continue;
                ++count;
                r.cancel();
            }
        }
        return count;
    }

    private boolean isSessionEndpoint(Request<?> r) {
        return r.getUrl().contains("/v2/sessions");
    }

    private void prepareRequest(Request<?> request) {
        request.addEvent("preparing-sdk-parameters");
        request.setUrl(this.mShopGun.getEnvironment().apply(request.getUrl()));
        String version = this.mShopGun.getAppVersion();
        if (version != null) {
            request.getParameters().put("api_av", version);
        }
        request.getParameters().put("r_locale", Locale.getDefault().toString());
        if (request.useLocation()) {
            NetworkUtils.appendLocationParams(request.getParameters(), this.mShopGun.getLocation());
        }
    }

    public int getRequestCount() {
        return this.mSequenceGenerator.get();
    }
}

