/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Size
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Size.class);
    public static Parcelable.Creator<Size> CREATOR = new Parcelable.Creator<Size>(){

        public Size createFromParcel(Parcel source) {
            return new Size(source);
        }

        public Size[] newArray(int size) {
            return new Size[size];
        }
    };
    private double mFrom = 1.0;
    private double mTo = 1.0;

    public Size() {
    }

    private Size(Parcel in) {
        this.mFrom = in.readDouble();
        this.mTo = in.readDouble();
    }

    public static List<Size> fromJSON(JSONArray array) {
        ArrayList<Size> list = new ArrayList<Size>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Size.fromJSON(o));
        }
        return list;
    }

    public static Size fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Size s = new Size().setFrom(o.getFrom()).setTo(o.getTo());
        o.getStats().log(TAG);
        return s;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setFrom(this.getFrom()).setTo(this.getTo()).toJSON();
    }

    public double getFrom() {
        return this.mFrom;
    }

    public Size setFrom(double from) {
        this.mFrom = from;
        return this;
    }

    public double getTo() {
        return this.mTo;
    }

    public Size setTo(double to) {
        this.mTo = to;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mFrom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mTo);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Size other = (Size)obj;
        if (Double.doubleToLongBits(this.mFrom) != Double.doubleToLongBits(other.mFrom)) {
            return false;
        }
        return Double.doubleToLongBits(this.mTo) == Double.doubleToLongBits(other.mTo);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.mFrom);
        dest.writeDouble(this.mTo);
    }
}

