/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Pieces
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Pieces.class);
    public static Parcelable.Creator<Pieces> CREATOR = new Parcelable.Creator<Pieces>(){

        public Pieces createFromParcel(Parcel source) {
            return new Pieces(source);
        }

        public Pieces[] newArray(int size) {
            return new Pieces[size];
        }
    };
    private int mFrom = 1;
    private int mTo = 1;

    public Pieces() {
    }

    private Pieces(Parcel in) {
        this.mFrom = in.readInt();
        this.mTo = in.readInt();
    }

    public static List<Pieces> fromJSON(JSONArray array) {
        ArrayList<Pieces> list = new ArrayList<Pieces>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Pieces.fromJSON(o));
        }
        return list;
    }

    public static Pieces fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Pieces p = new Pieces().setFrom((int)o.getFrom()).setTo((int)o.getTo());
        o.getStats().log(TAG);
        return p;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setFrom(this.getFrom()).setTo(this.getTo()).toJSON();
    }

    public int getFrom() {
        return this.mFrom;
    }

    public Pieces setFrom(int from) {
        this.mFrom = from;
        return this;
    }

    public int getTo() {
        return this.mTo;
    }

    public Pieces setTo(int to) {
        this.mTo = to;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mFrom;
        result = 31 * result + this.mTo;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Pieces other = (Pieces)obj;
        if (this.mFrom != other.mFrom) {
            return false;
        }
        return this.mTo == other.mTo;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mFrom);
        dest.writeInt(this.mTo);
    }
}

