/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.interfaces.IJson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Permission
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Permission.class);
    public static Parcelable.Creator<Permission> CREATOR = new Parcelable.Creator<Permission>(){

        public Permission createFromParcel(Parcel source) {
            return new Permission(source);
        }

        public Permission[] newArray(int size) {
            return new Permission[size];
        }
    };
    private HashMap<String, ArrayList<String>> mPermissions = new HashMap();

    public Permission() {
    }

    private Permission(Parcel in) {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            ArrayList value = new ArrayList();
            in.readStringList(value);
            this.mPermissions.put(key, value);
        }
    }

    public static List<Permission> fromJSON(JSONArray array) {
        ArrayList<Permission> list = new ArrayList<Permission>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Permission.fromJSON(o));
        }
        return list;
    }

    public static Permission fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        Permission p = new Permission();
        try {
            JSONArray groups = object.names();
            if (groups == null) {
                return p;
            }
            for (int i = 0; i < groups.length(); ++i) {
                String group = groups.get(i).toString();
                JSONArray jArray = object.getJSONArray(group);
                ArrayList<String> permissions = new ArrayList<String>();
                for (int j = 0; j < jArray.length(); ++j) {
                    permissions.add(jArray.get(j).toString());
                }
                p.getPermissions().put(group, permissions);
            }
        }
        catch (JSONException e) {
            SgnLog.e(TAG, "", e);
        }
        return p;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject o = new JSONObject();
        try {
            Iterator<String> it = this.getPermissions().keySet().iterator();
            while (it.hasNext()) {
                JSONArray jArray = new JSONArray();
                String name = it.next();
                for (String value : this.getPermissions().get(name)) {
                    jArray.put((Object)value);
                }
                o.put(name, (Object)jArray);
            }
        }
        catch (JSONException e) {
            SgnLog.e(TAG, e.getMessage(), e);
        }
        return o;
    }

    public ArrayList<String> getGroupPermissions(String group) {
        return this.mPermissions.get(group);
    }

    public Permission put(String group, ArrayList<String> permissions) {
        if (this.mPermissions.containsKey(group)) {
            this.mPermissions.get(group).addAll(permissions);
        } else {
            this.mPermissions.put(group, permissions);
        }
        return this;
    }

    public HashMap<String, ArrayList<String>> getPermissions() {
        return this.mPermissions;
    }

    public Permission putAll(HashMap<String, ArrayList<String>> permissions) {
        this.mPermissions.putAll(permissions);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mPermissions == null ? 0 : this.mPermissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Permission other = (Permission)obj;
        return !(this.mPermissions == null ? other.mPermissions != null : !this.mPermissions.equals(other.mPermissions));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mPermissions.size());
        for (Map.Entry<String, ArrayList<String>> e : this.mPermissions.entrySet()) {
            dest.writeString(e.getKey());
            dest.writeStringList((List)e.getValue());
        }
    }
}

