/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Branding;
import com.shopgun.android.sdk.model.Catalog;
import com.shopgun.android.sdk.model.Dealer;
import com.shopgun.android.sdk.model.Images;
import com.shopgun.android.sdk.model.Links;
import com.shopgun.android.sdk.model.Pricing;
import com.shopgun.android.sdk.model.Quantity;
import com.shopgun.android.sdk.model.Store;
import com.shopgun.android.sdk.model.interfaces.ICatalog;
import com.shopgun.android.sdk.model.interfaces.IDealer;
import com.shopgun.android.sdk.model.interfaces.IErn;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.model.interfaces.IStore;
import com.shopgun.android.sdk.utils.SgnJson;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class Offer
implements IErn<Offer>,
IJson<JSONObject>,
ICatalog<Offer>,
IDealer<Offer>,
IStore<Offer>,
Parcelable {
    public static final String TAG = Constants.getTag(Offer.class);
    private String mErn;
    private String mHeading;
    private String mDescription;
    private int mCatalogPage = 0;
    private Pricing mPricing;
    private Quantity mQuantity;
    private Images mImages;
    private Links mLinks;
    private Date mRunFrom;
    private Date mRunTill;
    private String mDealerUrl;
    private String mDealerId;
    private String mStoreUrl;
    private String mStoreId;
    private String mCatalogUrl;
    private String mCatalogId;
    private Set<String> mCategoryIds = new HashSet<String>();
    private Branding mBranding;
    private Catalog mCatalog;
    private Dealer mDealer;
    private Store mStore;
    public static final Parcelable.Creator<Offer> CREATOR = new Parcelable.Creator<Offer>(){

        public Offer createFromParcel(Parcel source) {
            return new Offer(source);
        }

        public Offer[] newArray(int size) {
            return new Offer[size];
        }
    };

    public Offer() {
    }

    public Offer(Offer offer) {
        Offer tmp = Utils.copyParcelable(offer, CREATOR);
        this.mErn = tmp.mErn;
        this.mHeading = tmp.mHeading;
        this.mDescription = tmp.mDescription;
        this.mCatalogPage = tmp.mCatalogPage;
        this.mPricing = tmp.mPricing;
        this.mQuantity = tmp.mQuantity;
        this.mImages = tmp.mImages;
        this.mLinks = tmp.mLinks;
        this.mRunFrom = tmp.mRunFrom;
        this.mRunTill = tmp.mRunTill;
        this.mDealerUrl = tmp.mDealerUrl;
        this.mDealerId = tmp.mDealerId;
        this.mStoreUrl = tmp.mStoreUrl;
        this.mStoreId = tmp.mStoreId;
        this.mCatalogUrl = tmp.mCatalogUrl;
        this.mCatalogId = tmp.mCatalogId;
        this.mCategoryIds = tmp.mCategoryIds;
        this.mCatalog = tmp.mCatalog;
        this.mDealer = tmp.mDealer;
        this.mStore = tmp.mStore;
        this.mBranding = tmp.mBranding;
    }

    public static List<Offer> fromJSON(JSONArray array) {
        ArrayList<Offer> list = new ArrayList<Offer>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Offer.fromJSON(o));
        }
        return list;
    }

    public static Offer fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        o.isErnTypeOrThrow("offer", Offer.class);
        Offer offer = new Offer().setId(o.getId()).setErn(o.getErn()).setHeading(o.getHeading()).setPricing(o.getPricing()).setQuantity(o.getQuantity()).setRunFrom(o.getRunFrom()).setRunTill(o.getRunTill());
        offer.setDescription(o.getDescription()).setCatalogPage(o.getCatalogPage()).setImages(o.getImages()).setLinks(o.getLinks()).setDealerUrl(o.getDealerUrl()).setDealerId(o.getDealerId()).setStoreUrl(o.getStoreUrl()).setStoreId(o.getStoreId()).setCatalogUrl(o.getCatalogUrl()).setCatalogId(o.getCatalogId()).setCategoryIds(o.getCategoryIds()).setBranding(o.getBranding());
        offer.mDealer = o.getDealer();
        offer.mStore = o.getStore();
        offer.mCatalog = o.getCatalog();
        if (!(object.has("branding") || object.has("images") || object.has("links"))) {
            o.getStats().ignoreRejectedKeys("catalog_page", "description", "images", "links", "dealer_url", "dealer_id", "store_url", "store_id", "catalog_url", "catalog_id", "category_ids", "branding");
        }
        o.getStats().ignoreForgottenKeys("publish").ignoreRejectedKeys("dealer", "store", "catalog").log(TAG);
        return offer;
    }

    public boolean isHotspot() {
        return this.mImages == null || this.mLinks == null;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setId(this.getId()).setErn(this.getErn()).setHeading(this.getHeading()).setDescription(this.getDescription()).setCatalogPage(this.getCatalogPage()).setPricing(this.getPricing()).setQuantity(this.getQuantity()).setImages(this.getImages()).setLinks(this.getLinks()).setRunFrom(this.getRunFrom()).setRunTill(this.getRunTill()).setDealerUrl(this.getDealerUrl()).setDealerId(this.getDealerId()).setStoreUrl(this.getStoreUrl()).setStoreId(this.getStoreId()).setCatalogUrl(this.getCatalogUrl()).setCatalogId(this.getCatalogId()).putDealer(this.getDealer()).putStore(this.getStore()).putCatalog(this.getCatalog()).setBranding(this.getBranding()).setCategoryIds(this.getCategoryIds()).toJSON();
    }

    @Override
    public String getId() {
        if (this.mErn == null) {
            return null;
        }
        String[] parts = this.mErn.split(":");
        return parts[parts.length - 1];
    }

    @Override
    public Offer setId(String id) {
        this.setErn(id == null ? null : String.format("ern:%s:%s", this.getErnType(), id));
        return this;
    }

    @Override
    public String getErn() {
        return this.mErn;
    }

    @Override
    public Offer setErn(String ern) {
        if (ern == null || ern.startsWith("ern:") && ern.split(":").length == 3 && ern.contains(this.getErnType())) {
            this.mErn = ern;
        }
        return this;
    }

    @Override
    public String getErnType() {
        return "offer";
    }

    public String getHeading() {
        return this.mHeading;
    }

    public Offer setHeading(String heading) {
        this.mHeading = heading;
        return this;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public Offer setDescription(String description) {
        this.mDescription = description;
        return this;
    }

    public int getCatalogPage() {
        return this.mCatalogPage;
    }

    public Offer setCatalogPage(int catalogPage) {
        this.mCatalogPage = catalogPage;
        return this;
    }

    public Pricing getPricing() {
        return this.mPricing;
    }

    public Offer setPricing(Pricing pricing) {
        this.mPricing = pricing;
        return this;
    }

    public Quantity getQuantity() {
        return this.mQuantity;
    }

    public Offer setQuantity(Quantity quantity) {
        this.mQuantity = quantity;
        return this;
    }

    public Images getImages() {
        return this.mImages;
    }

    public Offer setImages(Images images) {
        this.mImages = images;
        return this;
    }

    public Links getLinks() {
        return this.mLinks;
    }

    public Offer setLinks(Links links) {
        this.mLinks = links;
        return this;
    }

    public Date getRunFrom() {
        return this.mRunFrom;
    }

    public Offer setRunFrom(Date date) {
        this.mRunFrom = Utils.roundTime(date);
        return this;
    }

    public Date getRunTill() {
        return this.mRunTill;
    }

    public Offer setRunTill(Date date) {
        this.mRunTill = Utils.roundTime(date);
        return this;
    }

    public String getDealerUrl() {
        return this.mDealerUrl;
    }

    public Offer setDealerUrl(String url) {
        this.mDealerUrl = url;
        return this;
    }

    @Override
    public String getDealerId() {
        return this.mDealerId;
    }

    public Offer setDealerId(String dealerId) {
        this.mDealerId = dealerId;
        if (this.mDealerId == null) {
            this.mDealer = null;
        } else if (this.mDealer != null && !this.mDealerId.equals(this.mDealer.getId())) {
            this.mDealer = null;
        }
        return this;
    }

    public String getStoreUrl() {
        return this.mStoreUrl;
    }

    public Offer setStoreUrl(String url) {
        this.mStoreUrl = url;
        return this;
    }

    @Override
    public String getStoreId() {
        return this.mStoreId;
    }

    public Offer setStoreId(String storeId) {
        this.mStoreId = storeId;
        if (this.mStoreId == null) {
            this.mStore = null;
        } else if (this.mStore != null && !this.mStoreId.equals(this.mStore.getId())) {
            this.mStore = null;
        }
        return this;
    }

    public String getCatalogUrl() {
        return this.mCatalogUrl;
    }

    public Offer setCatalogUrl(String url) {
        this.mCatalogUrl = url;
        return this;
    }

    @Override
    public String getCatalogId() {
        return this.mCatalogId;
    }

    public Offer setCatalogId(String catalogId) {
        this.mCatalogId = catalogId;
        if (this.mCatalogId == null) {
            this.mCatalog = null;
        } else if (this.mCatalog != null && !this.mCatalogId.equals(this.mCatalog.getId())) {
            this.mCatalog = null;
        }
        return this;
    }

    @Override
    public Catalog getCatalog() {
        return this.mCatalog;
    }

    @Override
    public Offer setCatalog(Catalog catalog) {
        this.mCatalog = catalog;
        this.mCatalogId = this.mCatalog == null ? null : this.mCatalog.getId();
        return this;
    }

    @Override
    public Dealer getDealer() {
        return this.mDealer;
    }

    @Override
    public Offer setDealer(Dealer dealer) {
        this.mDealer = dealer;
        this.mDealerId = this.mDealer == null ? null : this.mDealer.getId();
        return this;
    }

    @Override
    public Store getStore() {
        return this.mStore;
    }

    @Override
    public Offer setStore(Store store) {
        this.mStore = store;
        this.mStoreId = this.mStore == null ? null : this.mStore.getId();
        return this;
    }

    public Set<String> getCategoryIds() {
        return this.mCategoryIds;
    }

    public Offer setCategoryIds(Set<String> categoryIds) {
        this.mCategoryIds = categoryIds;
        return this;
    }

    public Branding getBranding() {
        return this.mBranding;
    }

    public Offer setBranding(Branding branding) {
        this.mBranding = branding;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Offer offer = (Offer)o;
        if (this.mCatalogPage != offer.mCatalogPage) {
            return false;
        }
        if (this.mErn != null ? !this.mErn.equals(offer.mErn) : offer.mErn != null) {
            return false;
        }
        if (this.mHeading != null ? !this.mHeading.equals(offer.mHeading) : offer.mHeading != null) {
            return false;
        }
        if (this.mDescription != null ? !this.mDescription.equals(offer.mDescription) : offer.mDescription != null) {
            return false;
        }
        if (this.mPricing != null ? !this.mPricing.equals(offer.mPricing) : offer.mPricing != null) {
            return false;
        }
        if (this.mQuantity != null ? !this.mQuantity.equals(offer.mQuantity) : offer.mQuantity != null) {
            return false;
        }
        if (this.mImages != null ? !this.mImages.equals(offer.mImages) : offer.mImages != null) {
            return false;
        }
        if (this.mLinks != null ? !this.mLinks.equals(offer.mLinks) : offer.mLinks != null) {
            return false;
        }
        if (this.mRunFrom != null ? !this.mRunFrom.equals(offer.mRunFrom) : offer.mRunFrom != null) {
            return false;
        }
        if (this.mRunTill != null ? !this.mRunTill.equals(offer.mRunTill) : offer.mRunTill != null) {
            return false;
        }
        if (this.mDealerUrl != null ? !this.mDealerUrl.equals(offer.mDealerUrl) : offer.mDealerUrl != null) {
            return false;
        }
        if (this.mDealerId != null ? !this.mDealerId.equals(offer.mDealerId) : offer.mDealerId != null) {
            return false;
        }
        if (this.mStoreUrl != null ? !this.mStoreUrl.equals(offer.mStoreUrl) : offer.mStoreUrl != null) {
            return false;
        }
        if (this.mStoreId != null ? !this.mStoreId.equals(offer.mStoreId) : offer.mStoreId != null) {
            return false;
        }
        if (this.mCatalogUrl != null ? !this.mCatalogUrl.equals(offer.mCatalogUrl) : offer.mCatalogUrl != null) {
            return false;
        }
        if (this.mCatalogId != null ? !this.mCatalogId.equals(offer.mCatalogId) : offer.mCatalogId != null) {
            return false;
        }
        if (this.mCategoryIds != null ? !this.mCategoryIds.equals(offer.mCategoryIds) : offer.mCategoryIds != null) {
            return false;
        }
        if (this.mBranding != null ? !this.mBranding.equals(offer.mBranding) : offer.mBranding != null) {
            return false;
        }
        if (this.mCatalog != null ? !this.mCatalog.equals(offer.mCatalog) : offer.mCatalog != null) {
            return false;
        }
        if (this.mDealer != null ? !this.mDealer.equals(offer.mDealer) : offer.mDealer != null) {
            return false;
        }
        return this.mStore != null ? this.mStore.equals(offer.mStore) : offer.mStore == null;
    }

    public int hashCode() {
        int result = this.mErn != null ? this.mErn.hashCode() : 0;
        result = 31 * result + (this.mHeading != null ? this.mHeading.hashCode() : 0);
        result = 31 * result + (this.mDescription != null ? this.mDescription.hashCode() : 0);
        result = 31 * result + this.mCatalogPage;
        result = 31 * result + (this.mPricing != null ? this.mPricing.hashCode() : 0);
        result = 31 * result + (this.mQuantity != null ? this.mQuantity.hashCode() : 0);
        result = 31 * result + (this.mImages != null ? this.mImages.hashCode() : 0);
        result = 31 * result + (this.mLinks != null ? this.mLinks.hashCode() : 0);
        result = 31 * result + (this.mRunFrom != null ? this.mRunFrom.hashCode() : 0);
        result = 31 * result + (this.mRunTill != null ? this.mRunTill.hashCode() : 0);
        result = 31 * result + (this.mDealerUrl != null ? this.mDealerUrl.hashCode() : 0);
        result = 31 * result + (this.mDealerId != null ? this.mDealerId.hashCode() : 0);
        result = 31 * result + (this.mStoreUrl != null ? this.mStoreUrl.hashCode() : 0);
        result = 31 * result + (this.mStoreId != null ? this.mStoreId.hashCode() : 0);
        result = 31 * result + (this.mCatalogUrl != null ? this.mCatalogUrl.hashCode() : 0);
        result = 31 * result + (this.mCatalogId != null ? this.mCatalogId.hashCode() : 0);
        result = 31 * result + (this.mCategoryIds != null ? this.mCategoryIds.hashCode() : 0);
        result = 31 * result + (this.mBranding != null ? this.mBranding.hashCode() : 0);
        result = 31 * result + (this.mCatalog != null ? this.mCatalog.hashCode() : 0);
        result = 31 * result + (this.mDealer != null ? this.mDealer.hashCode() : 0);
        result = 31 * result + (this.mStore != null ? this.mStore.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mErn);
        dest.writeString(this.mHeading);
        dest.writeString(this.mDescription);
        dest.writeInt(this.mCatalogPage);
        dest.writeParcelable((Parcelable)this.mPricing, 0);
        dest.writeParcelable((Parcelable)this.mQuantity, 0);
        dest.writeParcelable((Parcelable)this.mImages, 0);
        dest.writeParcelable((Parcelable)this.mLinks, 0);
        dest.writeLong(this.mRunFrom != null ? this.mRunFrom.getTime() : -1L);
        dest.writeLong(this.mRunTill != null ? this.mRunTill.getTime() : -1L);
        dest.writeString(this.mDealerUrl);
        dest.writeString(this.mDealerId);
        dest.writeString(this.mStoreUrl);
        dest.writeString(this.mStoreId);
        dest.writeString(this.mCatalogUrl);
        dest.writeString(this.mCatalogId);
        dest.writeStringList(new ArrayList<String>(this.mCategoryIds));
        dest.writeParcelable((Parcelable)this.mBranding, 0);
        dest.writeParcelable((Parcelable)this.mCatalog, 0);
        dest.writeParcelable((Parcelable)this.mDealer, 0);
        dest.writeParcelable((Parcelable)this.mStore, 0);
    }

    protected Offer(Parcel in) {
        this.mErn = in.readString();
        this.mHeading = in.readString();
        this.mDescription = in.readString();
        this.mCatalogPage = in.readInt();
        this.mPricing = (Pricing)in.readParcelable(Pricing.class.getClassLoader());
        this.mQuantity = (Quantity)in.readParcelable(Quantity.class.getClassLoader());
        this.mImages = (Images)in.readParcelable(Images.class.getClassLoader());
        this.mLinks = (Links)in.readParcelable(Links.class.getClassLoader());
        long tmpMRunFrom = in.readLong();
        this.mRunFrom = tmpMRunFrom == -1L ? null : new Date(tmpMRunFrom);
        long tmpMRunTill = in.readLong();
        this.mRunTill = tmpMRunTill == -1L ? null : new Date(tmpMRunTill);
        this.mDealerUrl = in.readString();
        this.mDealerId = in.readString();
        this.mStoreUrl = in.readString();
        this.mStoreId = in.readString();
        this.mCatalogUrl = in.readString();
        this.mCatalogId = in.readString();
        ArrayList catIds = new ArrayList();
        in.readStringList(catIds);
        this.mCategoryIds = new HashSet<String>(catIds);
        this.mBranding = (Branding)in.readParcelable(Branding.class.getClassLoader());
        this.mCatalog = (Catalog)in.readParcelable(Catalog.class.getClassLoader());
        this.mDealer = (Dealer)in.readParcelable(Dealer.class.getClassLoader());
        this.mStore = (Store)in.readParcelable(Store.class.getClassLoader());
    }
}

