/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Dimension;
import com.shopgun.android.sdk.model.Hotspot;
import com.shopgun.android.sdk.model.Offer;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HotspotMap
implements IJson<JSONArray>,
Parcelable {
    public static final String TAG = Constants.getTag(HotspotMap.class);
    private static final String TYPE_OFFER = "offer";
    private static final int[] mRectColors = new int[]{-16777216, -16776961, -16711936, -65536, -256, -65281};
    @SuppressLint(value={"UseSparseArrays"})
    private HashMap<Integer, List<Hotspot>> mMap = new HashMap();
    private boolean mIsNormalized = false;
    public static final Parcelable.Creator<HotspotMap> CREATOR = new Parcelable.Creator<HotspotMap>(){

        public HotspotMap createFromParcel(Parcel source) {
            return new HotspotMap(source);
        }

        public HotspotMap[] newArray(int size) {
            return new HotspotMap[size];
        }
    };

    public HotspotMap() {
    }

    public void put(int page, List<Hotspot> list) {
        this.mMap.put(page, list);
    }

    public List<Hotspot> get(int page) {
        return this.mMap.get(page);
    }

    public static HotspotMap fromJSON(Dimension d, JSONArray hotspots) {
        HotspotMap map = new HotspotMap();
        if (hotspots == null) {
            return map;
        }
        for (int i = 0; i < hotspots.length(); ++i) {
            JSONObject hotspot = hotspots.optJSONObject(i);
            String type = hotspot.optString("type", null);
            if (!TYPE_OFFER.equals(type)) continue;
            try {
                JSONObject offer = hotspot.getJSONObject(TYPE_OFFER);
                Offer o = Offer.fromJSON(offer);
                int color = mRectColors[i % mRectColors.length];
                JSONObject rectangleList = hotspot.getJSONObject("locations");
                List<String> keys = Utils.copyIterator(rectangleList.keys());
                for (String key : keys) {
                    Integer page = Integer.valueOf(key);
                    JSONArray rect = rectangleList.getJSONArray(key);
                    if (!map.mMap.containsKey(page)) {
                        map.put(page, new ArrayList<Hotspot>());
                    }
                    Hotspot h = Hotspot.fromJSON(rect);
                    h.setPage(page);
                    h.setOffer(o);
                    h.setType(type);
                    h.setColor(color);
                    h.setDualPage(keys.size() > 1);
                    map.get(page).add(h);
                }
                continue;
            }
            catch (JSONException e) {
                SgnLog.e(TAG, e.getMessage(), e);
            }
        }
        map.normalize(d);
        return map;
    }

    public synchronized void normalize(Bitmap b) {
        if (!this.mIsNormalized) {
            this.normalize(Dimension.fromBitmap(b));
        }
    }

    public synchronized void normalize(Dimension d) {
        if (this.mIsNormalized || !d.isSet()) {
            return;
        }
        Set<Integer> keys = this.mMap.keySet();
        if (keys.isEmpty()) {
            return;
        }
        for (Integer i : keys) {
            List<Hotspot> hotspots = this.get(i);
            if (hotspots == null || hotspots.isEmpty()) continue;
            for (Hotspot h : hotspots) {
                h.normalize(d);
            }
        }
        this.mIsNormalized = true;
    }

    public List<Hotspot> getHotspots(int page, double xPercent, double yPercent, int[] pages) {
        return this.getHotspots(page, xPercent, yPercent, 0.02, pages);
    }

    public List<Hotspot> getHotspots(int page, double xPercent, double yPercent, double minArea, int[] pages) {
        ArrayList<Hotspot> list = new ArrayList<Hotspot>();
        List<Hotspot> lh = this.mMap.get(page);
        if (lh == null) {
            return list;
        }
        for (Hotspot h : lh) {
            if (!h.inBounds(xPercent, yPercent, minArea, pages)) continue;
            list.add(h);
        }
        return list;
    }

    @Override
    public JSONArray toJSON() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotspotMap that = (HotspotMap)o;
        return this.mIsNormalized == that.mIsNormalized && !(this.mMap == null ? that.mMap != null : !this.mMap.equals(that.mMap));
    }

    public int hashCode() {
        int result = this.mMap != null ? this.mMap.hashCode() : 0;
        result = 31 * result + (this.mIsNormalized ? 1 : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMap.size());
        for (Map.Entry<Integer, List<Hotspot>> e : this.mMap.entrySet()) {
            dest.writeInt(e.getKey().intValue());
            dest.writeTypedList(e.getValue());
        }
        dest.writeByte(this.mIsNormalized ? (byte)1 : 0);
    }

    protected HotspotMap(Parcel in) {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Integer key = in.readInt();
            ArrayList<Hotspot> value = new ArrayList<Hotspot>();
            in.readTypedList(value, Hotspot.CREATOR);
            this.put(key, value);
        }
        this.mIsNormalized = in.readByte() != 0;
    }
}

