/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.graphics.Bitmap;
import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Dimension
implements IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Dimension.class);
    public static Parcelable.Creator<Dimension> CREATOR = new Parcelable.Creator<Dimension>(){

        public Dimension createFromParcel(Parcel source) {
            return new Dimension(source);
        }

        public Dimension[] newArray(int size) {
            return new Dimension[size];
        }
    };
    private double mWidth = Double.NaN;
    private double mHeight = Double.NaN;

    public static Dimension fromBitmap(Bitmap b) {
        Dimension d = new Dimension();
        d.setWidth(1.0);
        double h = (float)b.getHeight() / (float)b.getWidth();
        d.setHeight(h);
        return d;
    }

    public Dimension() {
    }

    private Dimension(Parcel in) {
        this.mWidth = in.readDouble();
        this.mHeight = in.readDouble();
    }

    public static List<Dimension> fromJSON(JSONArray array) {
        ArrayList<Dimension> list = new ArrayList<Dimension>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Dimension.fromJSON(o));
        }
        return list;
    }

    public static Dimension fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Dimension d = new Dimension().setWidth(o.getWidth()).setHeight(o.getHeight());
        o.getStats().log(TAG);
        return d;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setWidth(this.getWidth()).setHeight(this.getHeight()).toJSON();
    }

    public Double getWidth() {
        return this.mWidth;
    }

    public Dimension setWidth(double width) {
        this.mWidth = width;
        return this;
    }

    public Double getHeight() {
        return this.mHeight;
    }

    public Dimension setHeight(double height) {
        this.mHeight = height;
        return this;
    }

    public boolean isSet() {
        return this.mWidth != Double.NaN && this.mHeight != Double.NaN;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.mHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mWidth);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dimension other = (Dimension)obj;
        if (Double.doubleToLongBits(this.mHeight) != Double.doubleToLongBits(other.mHeight)) {
            return false;
        }
        return Double.doubleToLongBits(this.mWidth) == Double.doubleToLongBits(other.mWidth);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.mWidth);
        dest.writeDouble(this.mHeight);
    }
}

