/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.interfaces.IErn;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.utils.SgnJson;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Country
implements IErn<Country>,
IJson<JSONObject>,
Parcelable {
    public static final String TAG = Constants.getTag(Country.class);
    public static Parcelable.Creator<Country> CREATOR = new Parcelable.Creator<Country>(){

        public Country createFromParcel(Parcel source) {
            return new Country(source);
        }

        public Country[] newArray(int size) {
            return new Country[size];
        }
    };
    private String mErn;
    private String mUnsubscribeUrl;

    public Country() {
    }

    private Country(Parcel in) {
        this.mErn = in.readString();
        this.mUnsubscribeUrl = in.readString();
    }

    public static List<Country> fromJSON(JSONArray array) {
        ArrayList<Country> list = new ArrayList<Country>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            list.add(Country.fromJSON(o));
        }
        return list;
    }

    public static Country fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        Country country = new Country().setId(o.getId()).setErn(o.getErn()).setUnsubscribePrintUrl(o.getUnsubscribePrintUrl());
        o.getStats().ignoreRejectedKeys("ern").log(TAG);
        return country;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setId(this.getId()).setErn(this.getErn()).setUnsubscribePrintUrl(this.getUnsubscribePrintUrl()).toJSON();
    }

    @Override
    public String getId() {
        if (this.mErn == null) {
            return null;
        }
        String[] parts = this.mErn.split(":");
        return parts[parts.length - 1];
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public Country setId(String id) {
        if (id == null) {
            this.setErn(null);
        } else if (id.length() == 2) {
            this.setErn(String.format("ern:%s:%s", this.getErnType(), id.toUpperCase()));
        } else {
            SgnLog.i(TAG, "The country code: " + id + " isn't allowed, see documentation for more details");
        }
        return this;
    }

    @Override
    public String getErn() {
        return this.mErn;
    }

    @Override
    public Country setErn(String ern) {
        if (ern == null || ern.startsWith("ern:") && ern.split(":").length == 3 && ern.contains(this.getErnType())) {
            this.mErn = ern;
        }
        return this;
    }

    @Override
    public String getErnType() {
        return "country";
    }

    public String getUnsubscribePrintUrl() {
        return this.mUnsubscribeUrl;
    }

    public Country setUnsubscribePrintUrl(String url) {
        this.mUnsubscribeUrl = url;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mErn == null ? 0 : this.mErn.hashCode());
        result = 31 * result + (this.mUnsubscribeUrl == null ? 0 : this.mUnsubscribeUrl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Country other = (Country)obj;
        if (this.mErn == null ? other.mErn != null : !this.mErn.equals(other.mErn)) {
            return false;
        }
        return !(this.mUnsubscribeUrl == null ? other.mUnsubscribeUrl != null : !this.mUnsubscribeUrl.equals(other.mUnsubscribeUrl));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mErn);
        dest.writeString(this.mUnsubscribeUrl);
    }
}

