/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.model.Branding;
import com.shopgun.android.sdk.model.Dealer;
import com.shopgun.android.sdk.model.Dimension;
import com.shopgun.android.sdk.model.HotspotMap;
import com.shopgun.android.sdk.model.Images;
import com.shopgun.android.sdk.model.Store;
import com.shopgun.android.sdk.model.interfaces.IDealer;
import com.shopgun.android.sdk.model.interfaces.IErn;
import com.shopgun.android.sdk.model.interfaces.IJson;
import com.shopgun.android.sdk.model.interfaces.IStore;
import com.shopgun.android.sdk.palette.MaterialColor;
import com.shopgun.android.sdk.palette.SgnColor;
import com.shopgun.android.sdk.utils.SgnJson;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class Catalog
implements IErn<Catalog>,
IJson<JSONObject>,
IDealer<Catalog>,
IStore<Catalog>,
Parcelable {
    public static final String TAG = Constants.getTag(Catalog.class);
    private String mErn;
    private String mLabel;
    private MaterialColor mBackground;
    private Date mRunFrom;
    private Date mRunTill;
    private int mPageCount = 0;
    private int mOfferCount = 0;
    private Branding mBranding;
    private String mDealerId;
    private String mDealerUrl;
    private String mStoreId;
    private String mStoreUrl;
    private Dimension mDimension;
    private Images mImages;
    private Set<String> mCategoryIds;
    private String mPdfUrl;
    private List<Images> mPages;
    private Dealer mDealer;
    private Store mStore;
    private HotspotMap mHotspots;
    public static final Parcelable.Creator<Catalog> CREATOR = new Parcelable.Creator<Catalog>(){

        public Catalog createFromParcel(Parcel source) {
            return new Catalog(source);
        }

        public Catalog[] newArray(int size) {
            return new Catalog[size];
        }
    };

    public Catalog() {
    }

    public Catalog(Catalog catalog) {
        Catalog tmp = Utils.copyParcelable(catalog, CREATOR);
        this.mErn = tmp.mErn;
        this.mLabel = tmp.mLabel;
        this.mBackground = tmp.mBackground;
        this.mRunFrom = tmp.mRunFrom;
        this.mRunTill = tmp.mRunTill;
        this.mPageCount = tmp.mPageCount;
        this.mOfferCount = tmp.mOfferCount;
        this.mBranding = tmp.mBranding;
        this.mDealerId = tmp.mDealerId;
        this.mDealerUrl = tmp.mDealerUrl;
        this.mStoreId = tmp.mStoreId;
        this.mStoreUrl = tmp.mStoreUrl;
        this.mDimension = tmp.mDimension;
        this.mImages = tmp.mImages;
        this.mCategoryIds = tmp.mCategoryIds;
        this.mPdfUrl = tmp.mPdfUrl;
        this.mPages = tmp.mPages;
        this.mDealer = tmp.mDealer;
        this.mStore = tmp.mStore;
        this.mHotspots = tmp.mHotspots;
    }

    public static List<Catalog> fromJSON(JSONArray array) {
        ArrayList<Catalog> list = new ArrayList<Catalog>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject o = array.optJSONObject(i);
            if (o == null) continue;
            list.add(Catalog.fromJSON(o));
        }
        return list;
    }

    public static Catalog fromJSON(JSONObject object) {
        if (object == null) {
            return null;
        }
        SgnJson o = new SgnJson(object);
        o.isErnTypeOrThrow("catalog", Catalog.class);
        Catalog c = new Catalog().setId(o.getId()).setErn(o.getErn()).setLabel(o.getLabel()).setBackground(o.getBackground()).setRunFrom(o.getRunFrom()).setRunTill(o.getRunTill()).setPageCount(o.getPageCount()).setOfferCount(o.getOfferCount()).setBranding(o.getBranding()).setDealerId(o.getDealerId()).setDealerUrl(o.getDealerUrl()).setStoreId(o.getStoreId()).setStoreUrl(o.getStoreUrl()).setDimension(o.getDimensions()).setImages(o.getImages()).setCategoryIds(o.getCategoryIds()).setPdfUrl(o.getPdfUrl()).setPages(o.getPages());
        c.mDealer = o.getDealer();
        c.mStore = o.getStore();
        o.getStats().ignoreRejectedKeys("dealer", "store").log(TAG);
        return c;
    }

    @Override
    public JSONObject toJSON() {
        return new SgnJson().setId(this.getId()).setErn(this.getErn()).setLabel(this.getLabel()).setBackground(this.getBackgroundMaterialColor()).setRunFrom(this.getRunFrom()).setRunTill(this.getRunTill()).setPagecount(this.getPageCount()).setOfferCount(this.getOfferCount()).setBranding(this.getBranding()).setDealerId(this.getDealerId()).setDealerUrl(this.getDealerUrl()).setStoreId(this.getStoreId()).setStoreUrl(this.getStoreUrl()).setDimensions(this.getDimension()).setImages(this.getImages()).setCategoryIds(this.getCategoryIds()).setPdfUrl(this.getPdfUrl()).putDealer(this.getDealer()).putStore(this.getStore()).putPages(this.getPages()).toJSON();
    }

    @Override
    public String getId() {
        if (this.mErn == null) {
            return null;
        }
        String[] parts = this.mErn.split(":");
        return parts[parts.length - 1];
    }

    @Override
    public Catalog setId(String id) {
        this.setErn(id == null ? null : String.format("ern:%s:%s", this.getErnType(), id));
        return this;
    }

    @Override
    public String getErn() {
        return this.mErn;
    }

    @Override
    public Catalog setErn(String ern) {
        if (ern == null || ern.startsWith("ern:") && ern.split(":").length == 3 && ern.contains(this.getErnType())) {
            this.mErn = ern;
        }
        return this;
    }

    @Override
    public String getErnType() {
        return "catalog";
    }

    public String getLabel() {
        return this.mLabel;
    }

    public Catalog setLabel(String label) {
        this.mLabel = label;
        return this;
    }

    public int getBackground() {
        return this.getBackgroundMaterialColor().getValue();
    }

    public MaterialColor getBackgroundMaterialColor() {
        if (this.mBackground == null) {
            this.mBackground = new SgnColor();
        }
        return this.mBackground;
    }

    public Catalog setBackground(int background) {
        this.setBackground(new SgnColor(background));
        return this;
    }

    public Catalog setBackground(MaterialColor background) {
        this.mBackground = background;
        return this;
    }

    public Date getRunFrom() {
        return this.mRunFrom;
    }

    public Catalog setRunFrom(Date date) {
        this.mRunFrom = Utils.roundTime(date);
        return this;
    }

    public Date getRunTill() {
        return this.mRunTill;
    }

    public Catalog setRunTill(Date date) {
        this.mRunTill = Utils.roundTime(date);
        return this;
    }

    public int getPageCount() {
        return this.mPageCount;
    }

    public Catalog setPageCount(int pageCount) {
        this.mPageCount = pageCount;
        return this;
    }

    public int getOfferCount() {
        return this.mOfferCount;
    }

    public Catalog setOfferCount(int offerCount) {
        this.mOfferCount = offerCount;
        return this;
    }

    public Branding getBranding() {
        return this.mBranding;
    }

    public Catalog setBranding(Branding branding) {
        this.mBranding = branding;
        return this;
    }

    @Override
    public String getDealerId() {
        return this.mDealerId;
    }

    public Catalog setDealerId(String dealerId) {
        this.mDealerId = dealerId;
        if (this.mDealerId == null) {
            this.mDealer = null;
        } else if (this.mDealer != null && !this.mDealerId.equals(this.mDealer.getId())) {
            this.mDealer = null;
        }
        return this;
    }

    public String getDealerUrl() {
        return this.mDealerUrl;
    }

    public Catalog setDealerUrl(String url) {
        this.mDealerUrl = url;
        return this;
    }

    @Override
    public String getStoreId() {
        return this.mStoreId;
    }

    public Catalog setStoreId(String storeId) {
        this.mStoreId = storeId;
        if (this.mStoreId == null) {
            this.mStore = null;
        } else if (this.mStore != null && !this.mStoreId.equals(this.mStore.getId())) {
            this.mStore = null;
        }
        return this;
    }

    public String getStoreUrl() {
        return this.mStoreUrl;
    }

    public Catalog setStoreUrl(String url) {
        this.mStoreUrl = url;
        return this;
    }

    public Dimension getDimension() {
        return this.mDimension;
    }

    public Catalog setDimension(Dimension dimension) {
        this.mDimension = dimension;
        return this;
    }

    public Images getImages() {
        return this.mImages;
    }

    public Catalog setImages(Images images) {
        this.mImages = images;
        return this;
    }

    public List<Images> getPages() {
        return this.mPages;
    }

    public Catalog setPages(List<Images> pages) {
        this.mPages = pages;
        return this;
    }

    @Override
    public Store getStore() {
        return this.mStore;
    }

    @Override
    public Catalog setStore(Store store) {
        this.mStore = store;
        this.mStoreId = this.mStore == null ? null : this.mStore.getId();
        return this;
    }

    @Override
    public Dealer getDealer() {
        return this.mDealer;
    }

    @Override
    public Catalog setDealer(Dealer dealer) {
        this.mDealer = dealer;
        this.mDealerId = this.mDealer == null ? null : this.mDealer.getId();
        return this;
    }

    public HotspotMap getHotspots() {
        return this.mHotspots;
    }

    public Catalog setHotspots(HotspotMap hotspots) {
        this.mHotspots = hotspots;
        return this;
    }

    public Set<String> getCategoryIds() {
        return this.mCategoryIds;
    }

    public Catalog setCategoryIds(Set<String> categoryIds) {
        this.mCategoryIds = categoryIds;
        return this;
    }

    @Deprecated
    public Set<String> getCatrgoryIds() {
        return this.getCategoryIds();
    }

    @Deprecated
    public Catalog setCatrgoryIds(Set<String> categoryIds) {
        return this.setCategoryIds(categoryIds);
    }

    public String getPdfUrl() {
        return this.mPdfUrl;
    }

    public Catalog setPdfUrl(String pdfUrl) {
        this.mPdfUrl = pdfUrl;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Catalog catalog = (Catalog)o;
        if (this.mPageCount != catalog.mPageCount) {
            return false;
        }
        if (this.mOfferCount != catalog.mOfferCount) {
            return false;
        }
        if (this.mErn != null ? !this.mErn.equals(catalog.mErn) : catalog.mErn != null) {
            return false;
        }
        if (this.mLabel != null ? !this.mLabel.equals(catalog.mLabel) : catalog.mLabel != null) {
            return false;
        }
        if (this.mBackground != null ? !this.mBackground.equals(catalog.mBackground) : catalog.mBackground != null) {
            return false;
        }
        if (this.mRunFrom != null ? !this.mRunFrom.equals(catalog.mRunFrom) : catalog.mRunFrom != null) {
            return false;
        }
        if (this.mRunTill != null ? !this.mRunTill.equals(catalog.mRunTill) : catalog.mRunTill != null) {
            return false;
        }
        if (this.mBranding != null ? !this.mBranding.equals(catalog.mBranding) : catalog.mBranding != null) {
            return false;
        }
        if (this.mDealerId != null ? !this.mDealerId.equals(catalog.mDealerId) : catalog.mDealerId != null) {
            return false;
        }
        if (this.mDealerUrl != null ? !this.mDealerUrl.equals(catalog.mDealerUrl) : catalog.mDealerUrl != null) {
            return false;
        }
        if (this.mStoreId != null ? !this.mStoreId.equals(catalog.mStoreId) : catalog.mStoreId != null) {
            return false;
        }
        if (this.mStoreUrl != null ? !this.mStoreUrl.equals(catalog.mStoreUrl) : catalog.mStoreUrl != null) {
            return false;
        }
        if (this.mDimension != null ? !this.mDimension.equals(catalog.mDimension) : catalog.mDimension != null) {
            return false;
        }
        if (this.mImages != null ? !this.mImages.equals(catalog.mImages) : catalog.mImages != null) {
            return false;
        }
        if (this.mCategoryIds != null ? !this.mCategoryIds.equals(catalog.mCategoryIds) : catalog.mCategoryIds != null) {
            return false;
        }
        if (this.mPdfUrl != null ? !this.mPdfUrl.equals(catalog.mPdfUrl) : catalog.mPdfUrl != null) {
            return false;
        }
        if (this.mPages != null ? !this.mPages.equals(catalog.mPages) : catalog.mPages != null) {
            return false;
        }
        if (this.mDealer != null ? !this.mDealer.equals(catalog.mDealer) : catalog.mDealer != null) {
            return false;
        }
        if (this.mStore != null ? !this.mStore.equals(catalog.mStore) : catalog.mStore != null) {
            return false;
        }
        return this.mHotspots != null ? this.mHotspots.equals(catalog.mHotspots) : catalog.mHotspots == null;
    }

    public int hashCode() {
        int result = this.mErn != null ? this.mErn.hashCode() : 0;
        result = 31 * result + (this.mLabel != null ? this.mLabel.hashCode() : 0);
        result = 31 * result + (this.mBackground != null ? this.mBackground.hashCode() : 0);
        result = 31 * result + (this.mRunFrom != null ? this.mRunFrom.hashCode() : 0);
        result = 31 * result + (this.mRunTill != null ? this.mRunTill.hashCode() : 0);
        result = 31 * result + this.mPageCount;
        result = 31 * result + this.mOfferCount;
        result = 31 * result + (this.mBranding != null ? this.mBranding.hashCode() : 0);
        result = 31 * result + (this.mDealerId != null ? this.mDealerId.hashCode() : 0);
        result = 31 * result + (this.mDealerUrl != null ? this.mDealerUrl.hashCode() : 0);
        result = 31 * result + (this.mStoreId != null ? this.mStoreId.hashCode() : 0);
        result = 31 * result + (this.mStoreUrl != null ? this.mStoreUrl.hashCode() : 0);
        result = 31 * result + (this.mDimension != null ? this.mDimension.hashCode() : 0);
        result = 31 * result + (this.mImages != null ? this.mImages.hashCode() : 0);
        result = 31 * result + (this.mCategoryIds != null ? this.mCategoryIds.hashCode() : 0);
        result = 31 * result + (this.mPdfUrl != null ? this.mPdfUrl.hashCode() : 0);
        result = 31 * result + (this.mPages != null ? this.mPages.hashCode() : 0);
        result = 31 * result + (this.mDealer != null ? this.mDealer.hashCode() : 0);
        result = 31 * result + (this.mStore != null ? this.mStore.hashCode() : 0);
        result = 31 * result + (this.mHotspots != null ? this.mHotspots.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mErn);
        dest.writeString(this.mLabel);
        dest.writeParcelable((Parcelable)this.mBackground, 0);
        dest.writeLong(this.mRunFrom != null ? this.mRunFrom.getTime() : -1L);
        dest.writeLong(this.mRunTill != null ? this.mRunTill.getTime() : -1L);
        dest.writeInt(this.mPageCount);
        dest.writeInt(this.mOfferCount);
        dest.writeParcelable((Parcelable)this.mBranding, 0);
        dest.writeString(this.mDealerId);
        dest.writeString(this.mDealerUrl);
        dest.writeString(this.mStoreId);
        dest.writeString(this.mStoreUrl);
        dest.writeParcelable((Parcelable)this.mDimension, 0);
        dest.writeParcelable((Parcelable)this.mImages, 0);
        dest.writeStringList(new ArrayList<String>(this.mCategoryIds));
        dest.writeString(this.mPdfUrl);
        dest.writeTypedList(this.mPages);
        dest.writeParcelable((Parcelable)this.mDealer, 0);
        dest.writeParcelable((Parcelable)this.mStore, 0);
        dest.writeParcelable((Parcelable)this.mHotspots, 0);
    }

    protected Catalog(Parcel in) {
        this.mErn = in.readString();
        this.mLabel = in.readString();
        this.mBackground = (MaterialColor)in.readParcelable(MaterialColor.class.getClassLoader());
        long tmpMRunFrom = in.readLong();
        this.mRunFrom = tmpMRunFrom == -1L ? null : new Date(tmpMRunFrom);
        long tmpMRunTill = in.readLong();
        this.mRunTill = tmpMRunTill == -1L ? null : new Date(tmpMRunTill);
        this.mPageCount = in.readInt();
        this.mOfferCount = in.readInt();
        this.mBranding = (Branding)in.readParcelable(Branding.class.getClassLoader());
        this.mDealerId = in.readString();
        this.mDealerUrl = in.readString();
        this.mStoreId = in.readString();
        this.mStoreUrl = in.readString();
        this.mDimension = (Dimension)in.readParcelable(Dimension.class.getClassLoader());
        this.mImages = (Images)in.readParcelable(Images.class.getClassLoader());
        ArrayList catIds = new ArrayList();
        in.readStringList(catIds);
        this.mCategoryIds = new HashSet<String>(catIds);
        this.mPdfUrl = in.readString();
        this.mPages = in.createTypedArrayList(Images.CREATOR);
        this.mDealer = (Dealer)in.readParcelable(Dealer.class.getClassLoader());
        this.mStore = (Store)in.readParcelable(Store.class.getClassLoader());
        this.mHotspots = (HotspotMap)in.readParcelable(HotspotMap.class.getClassLoader());
    }
}

