/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.log;

import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.DefaultLogger;
import com.shopgun.android.sdk.log.SgnLogger;
import com.shopgun.android.utils.ExceptionUtils;
import org.json.JSONObject;

public class SgnLog {
    public static final String TAG = Constants.getTag(SgnLog.class);
    private static final String LOG_D_CHUNK = "[chunk %s/%s] %s";
    private static SgnLogger mLogger = new DefaultLogger();

    public static SgnLogger getLogger() {
        return mLogger;
    }

    public static void setLogger(SgnLogger l) {
        mLogger = l;
    }

    public static int v(String tag, String msg) {
        return mLogger.v(tag, msg);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return mLogger.v(tag, msg, tr);
    }

    public static int d(String tag, String msg) {
        return mLogger.d(tag, msg);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return mLogger.d(tag, msg, tr);
    }

    public static int i(String tag, String msg) {
        return mLogger.i(tag, msg);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return mLogger.i(tag, msg, tr);
    }

    public static int w(String tag, String msg) {
        return mLogger.w(tag, msg);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return mLogger.w(tag, msg, tr);
    }

    public static int e(String tag, String msg) {
        return mLogger.e(tag, msg);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return mLogger.e(tag, msg, tr);
    }

    public static void dAll(String tag, String message) {
        if (message.length() > 4000) {
            int chunkCount = message.length() / 4000;
            for (int i = 0; i <= chunkCount; ++i) {
                int max = 4000 * (i + 1);
                int end = max >= message.length() ? message.length() : max;
                SgnLog.d(tag, String.format(LOG_D_CHUNK, i, chunkCount, message.substring(4000 * i, end)));
            }
        } else {
            SgnLog.d(tag, message);
        }
    }

    public static void printStackTrace(String tag) {
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            SgnLog.d(tag, String.valueOf(ste));
        }
    }

    public static void printParentMethod(String tag) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        SgnLog.d(tag, String.valueOf(trace[4]));
    }

    public static JSONObject exceptionToJson(Throwable t) {
        return ExceptionUtils.exceptionToJson((Throwable)t);
    }
}

