/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.log;

import android.util.Log;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.EventLog;
import com.shopgun.android.sdk.log.SgnLogger;
import com.shopgun.android.utils.ExceptionUtils;

public class DevLogger
implements SgnLogger {
    public static final String TAG = Constants.getTag(DevLogger.class);
    public static final int DEFAULT_EXCEPTION_LOG_SIZE = 32;
    private EventLog mLog;

    public DevLogger() {
        this(32);
    }

    public DevLogger(int logSize) {
        this.mLog = new EventLog(logSize);
    }

    @Override
    public int v(String tag, String msg) {
        return Log.v((String)tag, (String)msg);
    }

    @Override
    public int v(String tag, String msg, Throwable tr) {
        return Log.v((String)tag, (String)msg, (Throwable)tr);
    }

    @Override
    public int d(String tag, String msg) {
        return Log.d((String)tag, (String)msg);
    }

    @Override
    public int d(String tag, String msg, Throwable tr) {
        return Log.d((String)tag, (String)msg, (Throwable)tr);
    }

    @Override
    public int i(String tag, String msg) {
        return Log.i((String)tag, (String)msg);
    }

    @Override
    public int i(String tag, String msg, Throwable tr) {
        return Log.i((String)tag, (String)msg, (Throwable)tr);
    }

    @Override
    public int w(String tag, String msg) {
        return Log.w((String)tag, (String)msg);
    }

    @Override
    public int w(String tag, String msg, Throwable tr) {
        return Log.w((String)tag, (String)msg, (Throwable)tr);
    }

    @Override
    public int e(String tag, String msg) {
        return Log.e((String)tag, (String)msg);
    }

    @Override
    public int e(String tag, String msg, Throwable tr) {
        if (msg == null || msg.length() == 0) {
            msg = tr.getMessage();
        }
        this.mLog.add("exception", ExceptionUtils.exceptionToJson((Throwable)tr));
        return Log.e((String)tag, (String)msg, (Throwable)tr);
    }

    @Override
    public EventLog getLog() {
        return this.mLog;
    }
}

