/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.log;

import android.util.Log;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.log.EventLog;
import com.shopgun.android.sdk.log.SgnLogger;
import com.shopgun.android.utils.ExceptionUtils;

public class DefaultLogger
implements SgnLogger {
    public static final String TAG = Constants.getTag(DefaultLogger.class);
    public static final int DEFAULT_EXCEPTION_LOG_SIZE = 16;
    private EventLog mLog;

    public DefaultLogger() {
        this(16);
    }

    public DefaultLogger(int logSize) {
        this.mLog = new EventLog(logSize);
    }

    @Override
    public int v(String tag, String msg) {
        return 0;
    }

    @Override
    public int v(String tag, String msg, Throwable tr) {
        return 0;
    }

    @Override
    public int d(String tag, String msg) {
        return 0;
    }

    @Override
    public int d(String tag, String msg, Throwable tr) {
        return 0;
    }

    @Override
    public int i(String tag, String msg) {
        return Log.i((String)tag, (String)msg);
    }

    @Override
    public int i(String tag, String msg, Throwable tr) {
        return Log.i((String)tag, (String)msg, (Throwable)tr);
    }

    @Override
    public int w(String tag, String msg) {
        return Log.w((String)tag, (String)msg);
    }

    @Override
    public int w(String tag, String msg, Throwable tr) {
        return Log.w((String)tag, (String)msg, (Throwable)tr);
    }

    @Override
    public int e(String tag, String msg) {
        return Log.e((String)tag, (String)msg);
    }

    @Override
    public int e(String tag, String msg, Throwable tr) {
        if (msg == null || msg.length() == 0) {
            msg = tr.getMessage();
        }
        this.mLog.add("exception", ExceptionUtils.exceptionToJson((Throwable)tr));
        return Log.e((String)tag, (String)msg, (Throwable)tr);
    }

    @Override
    public EventLog getLog() {
        return this.mLog;
    }
}

