/*
 * Decompiled with CFR 0.152.
 */
package com.shopgun.android.sdk.database;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.shopgun.android.sdk.Constants;
import com.shopgun.android.sdk.database.DatabaseHelper;
import com.shopgun.android.sdk.database.DbUtils;
import com.shopgun.android.sdk.log.SgnLog;
import com.shopgun.android.sdk.model.Shoppinglist;
import com.shopgun.android.sdk.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ListSQLiteHelper
extends DatabaseHelper {
    public static final String TAG = Constants.getTag(ListSQLiteHelper.class);
    public static final String TABLE = "shoppinglists";
    public static final String CREATE_TABLE = "create table if not exists shoppinglists(id text primary key, ern text, modified text not null, name text not null, access text not null, state integer not null, previous_id text, type text, meta text, user integer not null );";
    public static final String INSERT_STATEMENT = "INSERT OR REPLACE INTO shoppinglists VALUES (?,?,?,?,?,?,?,?,?,?)";

    public ListSQLiteHelper(Context context) {
        super(context);
    }

    public static void create(SQLiteDatabase db) {
        db.acquireReference();
        db.execSQL(CREATE_TABLE);
        db.releaseReference();
    }

    public static void upgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.acquireReference();
        db.execSQL("DROP TABLE IF EXISTS shoppinglists");
        db.releaseReference();
    }

    public static SQLiteStatement getInsertStatement(SQLiteDatabase db) {
        return db.compileStatement(INSERT_STATEMENT);
    }

    public static void bind(SQLiteStatement s, Shoppinglist sl, String userId) {
        DbUtils.bindOrNull(s, 1, sl.getId());
        DbUtils.bindOrNull(s, 2, sl.getErn());
        DbUtils.bindOrNull(s, 3, Utils.dateToString(sl.getModified()));
        DbUtils.bindOrNull(s, 4, sl.getName());
        DbUtils.bindOrNull(s, 5, sl.getAccess());
        s.bindLong(6, (long)sl.getState());
        DbUtils.bindOrNull(s, 7, sl.getPreviousId());
        DbUtils.bindOrNull(s, 8, sl.getType());
        String meta = sl.getMeta() == null ? null : sl.getMeta().toString();
        DbUtils.bindOrNull(s, 9, meta);
        DbUtils.bindOrNull(s, 10, userId);
    }

    public static List<Shoppinglist> cursorToList(Cursor c) {
        ArrayList<Shoppinglist> list = new ArrayList<Shoppinglist>();
        for (ContentValues cv : DbUtils.cursorToContentValues(c)) {
            Shoppinglist sl = ListSQLiteHelper.contentValuesToObject(cv);
            if (sl == null) continue;
            list.add(sl);
        }
        return list;
    }

    public static Shoppinglist contentValuesToObject(ContentValues cv) {
        Shoppinglist sl = Shoppinglist.fromName(cv.getAsString("name"));
        sl.setId(cv.getAsString("id"));
        sl.setErn(cv.getAsString("ern"));
        sl.setModified(Utils.stringToDate(cv.getAsString("modified")));
        sl.setAccess(cv.getAsString("access"));
        Integer state = cv.getAsInteger("state");
        sl.setState(state == null ? 0 : state);
        sl.setPreviousId(cv.getAsString("previous_id"));
        sl.setType(cv.getAsString("type"));
        try {
            String meta = cv.getAsString("meta");
            sl.setMeta(meta == null ? null : new JSONObject(meta));
        }
        catch (JSONException e) {
            SgnLog.e(TAG, null, e);
        }
        sl.setUserId(cv.getAsInteger("user"));
        return sl;
    }

    public static ContentValues objectToContentValues(Shoppinglist sl, String userId) {
        ContentValues cv = new ContentValues();
        cv.put("id", sl.getId());
        cv.put("ern", sl.getErn());
        cv.put("modified", Utils.dateToString(sl.getModified()));
        cv.put("name", sl.getName());
        cv.put("access", sl.getAccess());
        cv.put("state", Integer.valueOf(sl.getState()));
        cv.put("previous_id", sl.getPreviousId());
        cv.put("type", sl.getType());
        String meta = sl.getMeta() == null ? null : sl.getMeta().toString();
        cv.put("meta", meta);
        cv.put("user", userId);
        return cv;
    }
}

